/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.parts;

import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.henshin.statespace.validation.StateSpaceXYPlot;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class StateSpaceXYPlotDialog
extends Dialog
implements ControlListener {
    private StateSpaceXYPlot plot;
    private Dot[][] dots;
    private Line[][] lines;
    private Legend[] legend;
    private Bar xBar;
    private Bar yBar;
    private Panel panel;
    private FigureCanvas canvas;
    private String title;

    public StateSpaceXYPlotDialog(Shell shell, StateSpaceXYPlot plot, String title) {
        super(shell);
        this.plot = plot;
        this.title = title != null ? title : "Plot";
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        Monitor primary = shell.getDisplay().getPrimaryMonitor();
        org.eclipse.swt.graphics.Rectangle b = primary.getBounds();
        int w = b.width / 2;
        int h = b.height / 2;
        shell.setBounds(w / 2, h / 2, w, h);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(main, 2048);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        this.panel = new Panel();
        this.panel.setLayoutManager((LayoutManager)new XYLayout());
        this.drawFigures((IFigure)this.panel);
        this.canvas = new FigureCanvas(composite);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground(ColorConstants.white);
        this.canvas.setContents((IFigure)this.panel);
        this.canvas.addControlListener((ControlListener)this);
        return composite;
    }

    private void drawFigures(IFigure parent) {
        int j;
        int xSegs = Math.max(2, Math.min(this.plot.getXMaxSegments(), 10));
        int ySegs = Math.max(2, Math.min(this.plot.getYMaxSegments(), 10));
        this.xBar = new Bar(parent, this.plot.getXName(), this.plot.getXMax(), xSegs, false);
        this.yBar = new Bar(parent, this.plot.getYName(), this.plot.getYMax(), ySegs, true);
        this.dots = new Dot[this.plot.getSeriesCount()][];
        int i = 0;
        while (i < this.dots.length) {
            this.dots[i] = new Dot[this.plot.getSeriesLength(i)];
            j = 0;
            while (j < this.dots[i].length) {
                String label = String.valueOf(this.plot.getXName()) + "=" + this.plot.getX(i, j) + "," + this.plot.getYName() + "=" + this.plot.getY(i, j);
                this.dots[i][j] = new Dot(parent, StateSpaceXYPlotDialog.getPlotColor(i), label);
                ++j;
            }
            ++i;
        }
        this.lines = new Line[this.dots.length][];
        i = 0;
        while (i < this.lines.length) {
            this.lines[i] = new Line[this.dots[i].length - 1];
            j = 0;
            while (j < this.lines[i].length) {
                Dot left = this.dots[i][j];
                Dot right = this.dots[i][j + 1];
                this.lines[i][j] = new Line(parent, left, right, StateSpaceXYPlotDialog.getPlotColor(i));
                ++j;
            }
            ++i;
        }
        this.legend = new Legend[this.plot.getSeriesCount()];
        i = 0;
        while (i < this.legend.length) {
            String label = this.plot.getLegend(i);
            if (label != null) {
                this.legend[i] = new Legend(parent, label, StateSpaceXYPlotDialog.getPlotColor(i));
            }
            ++i;
        }
    }

    private void updatePositions() {
        int top = 35;
        int left = 50;
        int right = 40;
        int bottom = 40;
        Viewport port = this.canvas.getViewport();
        int width = port.getHorizontalRangeModel().getExtent() - left - right;
        int height = port.getVerticalRangeModel().getExtent() - bottom - top;
        this.yBar.setStart(new Point(left, top + height));
        this.yBar.setEnd(new Point(left, top));
        this.xBar.setStart(new Point(left, top + height));
        this.xBar.setEnd(new Point(left + width, top + height));
        int i = 0;
        while (i < this.dots.length) {
            int j = 0;
            while (j < this.dots[i].length) {
                int x = this.plot.getXScaled(i, j, width) + left;
                int y = height - this.plot.getYScaled(i, j, height) + top;
                this.dots[i][j].setPosition(x, y);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.legend.length) {
            if (this.legend[i] != null) {
                Dimension size = this.legend[i].getMinimumSize();
                int more = 25;
                this.legend[i].setPosition(left + width + more - size.width, top - more + i * size.height);
            }
            ++i;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Close", true);
    }

    private static Color getPlotColor(int index) {
        switch (index % 9) {
            case 0: {
                return ColorConstants.red;
            }
            case 1: {
                return ColorConstants.blue;
            }
            case 2: {
                return ColorConstants.green;
            }
            case 3: {
                return ColorConstants.cyan;
            }
            case 4: {
                return ColorConstants.darkBlue;
            }
            case 5: {
                return ColorConstants.darkGreen;
            }
            case 6: {
                return ColorConstants.yellow;
            }
            case 7: {
                return ColorConstants.darkGray;
            }
            case 8: {
                return ColorConstants.gray;
            }
        }
        return ColorConstants.gray;
    }

    public void controlResized(ControlEvent e) {
        this.updatePositions();
    }

    public void controlMoved(ControlEvent e) {
    }

    protected boolean isResizable() {
        return true;
    }

    class Bar
    extends Polyline {
        static final int WIDTH = 3;
        static final int ARROW = 20;
        String name;
        double maximum;
        int segments;
        boolean vertical;

        Bar(IFigure parent, String name, double maximum, int segments, boolean vertical) {
            this.name = name;
            this.vertical = vertical;
            this.maximum = maximum;
            this.segments = segments;
            this.setAntialias(1);
            this.setForegroundColor(ColorConstants.black);
            parent.add((IFigure)this);
        }

        public void setEnd(Point end) {
            if (this.vertical) {
                super.setEnd(end.getTranslated(0, -20));
            } else {
                super.setEnd(end.getTranslated(20, 0));
            }
        }

        public Rectangle getBounds() {
            if (this.bounds == null) {
                this.bounds = this.vertical ? this.getPoints().getBounds().getExpanded(43, 10) : this.getPoints().getBounds().getExpanded(10, 43);
            }
            return this.bounds;
        }

        protected void outlineShape(Graphics g) {
            super.outlineShape(g);
            int length = (this.vertical ? this.getStart().y - this.getEnd().y : this.getEnd().x - this.getStart().x) - 20;
            int i = 0;
            while (i < this.segments) {
                int position = i * length / (this.segments - 1);
                double value = (double)i * this.maximum / (double)(this.segments - 1);
                PointList marker = new PointList();
                if (this.vertical) {
                    marker.addPoint(this.getStart().x - 3, this.getStart().y - position);
                    marker.addPoint(this.getStart().x + 3, this.getStart().y - position);
                } else {
                    marker.addPoint(this.getStart().x + position, this.getStart().y - 3);
                    marker.addPoint(this.getStart().x + position, this.getStart().y + 3);
                }
                g.drawPolyline(marker);
                NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
                format.setMinimumFractionDigits(2);
                format.setMaximumFractionDigits(2);
                String text = format.format(value);
                if (text.indexOf(46) >= 0 && text.length() > 4) {
                    text = text.substring(0, text.indexOf(46));
                }
                int h = g.getFontMetrics().getHeight();
                int w = text.length() * g.getFontMetrics().getAverageCharWidth();
                if (this.vertical) {
                    g.drawString(text, this.getStart().x - w - h / 4 - 3, this.getStart().y - position - h / 2);
                } else {
                    g.drawString(text, this.getStart().x + position - h / 4, this.getStart().y + 3 + h / 4);
                }
                ++i;
            }
            PointList arrow = new PointList();
            if (this.vertical) {
                arrow.addPoint(this.getEnd().x - 3, this.getEnd().y + 3);
                arrow.addPoint(this.getEnd().x, this.getEnd().y);
                arrow.addPoint(this.getEnd().x + 3, this.getEnd().y + 3);
            } else {
                arrow.addPoint(this.getEnd().x - 3, this.getEnd().y - 3);
                arrow.addPoint(this.getEnd().x, this.getEnd().y);
                arrow.addPoint(this.getEnd().x - 3, this.getEnd().y + 3);
            }
            g.drawPolyline(arrow);
            if (this.name != null) {
                int h = g.getFontMetrics().getHeight();
                int w = this.name.length() * g.getFontMetrics().getAverageCharWidth();
                if (this.vertical) {
                    g.drawString(this.name, this.getEnd().x - w - 3 - h / 4, this.getEnd().y - h / 4);
                } else {
                    g.drawString(this.name, this.getEnd().x - w + h / 4, this.getEnd().y + h + h / 4 + 3);
                }
            }
        }
    }

    class CenterAnchor
    extends ChopboxAnchor {
        CenterAnchor(IFigure owner) {
            super(owner);
        }

        protected Rectangle getBox() {
            Rectangle bounds = this.getOwner().getBounds().getCopy();
            bounds.x += bounds.width / 2;
            bounds.y += bounds.width / 2;
            bounds.width = 0;
            bounds.height = 0;
            return bounds;
        }
    }

    class Dot
    extends Ellipse {
        Dot(IFigure parent, Color color, String tooltip) {
            this.setSize(new Dimension(5, 5));
            this.setForegroundColor(ColorConstants.gray);
            this.setBackgroundColor(color);
            this.setOpaque(true);
            parent.add((IFigure)this);
            if (tooltip != null) {
                this.setToolTip((IFigure)new Label(tooltip));
            }
        }

        void setPosition(int x, int y) {
            this.getParent().setConstraint((IFigure)this, (Object)new Rectangle(x - 2, y - 2, -1, -1));
        }
    }

    class Legend
    extends RectangleFigure {
        Dot dot1;
        Dot dot2;
        Line line;
        Label label;

        Legend(IFigure parent, String name, Color color) {
            this.setLayoutManager((LayoutManager)new XYLayout());
            this.dot1 = new Dot((IFigure)this, color, null);
            this.add((IFigure)this.dot1);
            this.dot2 = new Dot((IFigure)this, color, null);
            this.add((IFigure)this.dot2);
            this.line = new Line((IFigure)this, this.dot1, this.dot2, color);
            this.add((IFigure)this.line);
            this.label = new Label(name);
            this.add((IFigure)this.label);
            this.setConstraint((IFigure)this.dot1, new Rectangle(0, 4, -1, -1));
            this.setConstraint((IFigure)this.dot2, new Rectangle(10, 4, -1, -1));
            this.setConstraint((IFigure)this.label, new Rectangle(18, 0, -1, -1));
            this.setOutline(false);
            parent.add((IFigure)this);
        }

        void setPosition(int x, int y) {
            this.getParent().setConstraint((IFigure)this, (Object)new Rectangle(x, y, -1, -1));
        }
    }

    class Line
    extends PolylineConnection {
        Line(IFigure parent, Dot source, Dot target, Color color) {
            this.setSourceAnchor((ConnectionAnchor)new CenterAnchor((IFigure)source));
            this.setTargetAnchor((ConnectionAnchor)new CenterAnchor((IFigure)target));
            this.setAntialias(1);
            this.setForegroundColor(color);
            parent.add((IFigure)this);
        }
    }
}

