/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class CopyKernelToMultiRulesAndCreateMappingCommand
extends CompoundCommand {
    protected EditingDomain domain;
    protected AmalgamationUnit amalgamationUnit;
    protected Rule kernelRule;
    protected Rule newMultiRule;
    protected Collection<Mapping> rhsMappings = new ArrayList<Mapping>();
    protected Collection<Mapping> lhsMappings = new ArrayList<Mapping>();

    public CopyKernelToMultiRulesAndCreateMappingCommand(EditingDomain domain, AmalgamationUnit aUnit) {
        this.domain = domain;
        this.amalgamationUnit = aUnit;
    }

    protected boolean prepare() {
        this.kernelRule = this.amalgamationUnit.getKernelRule();
        return this.kernelRule != null;
    }

    public void execute() {
        CopyCommand copyCmd = new CopyCommand(this.domain, (EObject)this.kernelRule, new CopyCommand.Helper());
        this.appendAndExecute((Command)copyCmd);
        this.newMultiRule = (Rule)copyCmd.getResult().iterator().next();
        this.newMultiRule.setName("Copy of " + this.newMultiRule.getName());
        Iterator rightKernelNodes = this.kernelRule.getRhs().getNodes().iterator();
        Iterator rightMultiNodes = this.newMultiRule.getRhs().getNodes().iterator();
        while (rightKernelNodes.hasNext() && rightMultiNodes.hasNext()) {
            this.rhsMappings.add(HenshinFactory.eINSTANCE.createMapping((Node)rightKernelNodes.next(), (Node)rightMultiNodes.next()));
        }
        Iterator leftKernelNodes = this.kernelRule.getLhs().getNodes().iterator();
        Iterator leftMultiNodes = this.newMultiRule.getLhs().getNodes().iterator();
        while (leftKernelNodes.hasNext() && leftMultiNodes.hasNext()) {
            this.lhsMappings.add(HenshinFactory.eINSTANCE.createMapping((Node)leftKernelNodes.next(), (Node)leftMultiNodes.next()));
        }
        this.redo();
    }

    public void undo() {
        this.kernelRule.getTransformationSystem().getRules().remove((Object)this.newMultiRule);
        this.amalgamationUnit.getMultiRules().remove((Object)this.newMultiRule);
        this.amalgamationUnit.getRhsMappings().removeAll(this.rhsMappings);
        this.amalgamationUnit.getLhsMappings().removeAll(this.lhsMappings);
    }

    public void redo() {
        this.kernelRule.getTransformationSystem().getRules().add((Object)this.newMultiRule);
        this.amalgamationUnit.getMultiRules().add((Object)this.newMultiRule);
        this.amalgamationUnit.getRhsMappings().addAll(this.rhsMappings);
        this.amalgamationUnit.getLhsMappings().addAll(this.lhsMappings);
    }

    public Collection<?> getAffectedObjects() {
        return Collections.singleton(this.newMultiRule);
    }
}

