/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.edit.parts.SymbolType;
import org.eclipse.emf.henshin.diagram.part.HenshinVisualIDRegistry;
import org.eclipse.emf.henshin.diagram.providers.HenshinViewProvider;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class HenshinSymbolUpdater {
    private PreferencesHint prefHint;
    private boolean persisted;
    private HenshinViewProvider provider;

    public HenshinSymbolUpdater(PreferencesHint prefHint, boolean persisted) {
        this.prefHint = prefHint;
        this.persisted = persisted;
        this.provider = new HenshinViewProvider();
    }

    public void update(View unitView) {
        View compartment = this.getUnitCompartment(unitView);
        TransformationUnit unit = (TransformationUnit)((View)compartment.eContainer()).getElement();
        EList subUnits = unit.getSubUnits(false);
        HashSet<View> knownSymbols = new HashSet<View>();
        knownSymbols.add(this.ensureSingleSymbol(unit, compartment, SymbolType.UNIT_BEGIN, 15, 15));
        knownSymbols.add(this.ensureSingleSymbol(unit, compartment, SymbolType.UNIT_END, 205, 15));
        if (unit instanceof IndependentUnit && subUnits.size() > 1) {
            knownSymbols.add(this.ensureSingleSymbol(unit, compartment, SymbolType.INDEPENDENT_CHOICE, 50, 15));
        }
        this.deleteUnknownSymbols(unit, compartment, knownSymbols);
    }

    public View ensureSingleSymbol(TransformationUnit unit, View compartment, SymbolType type, int x, int y) {
        List<View> symbols = this.getSymbols(unit, compartment, type);
        while (symbols.size() > 1) {
            ViewUtil.destroy((View)symbols.remove(symbols.size() - 1));
        }
        if (symbols.isEmpty()) {
            return this.createSymbol(unit, compartment, -1, type, x, y);
        }
        return symbols.get(0);
    }

    private void deleteUnknownSymbols(TransformationUnit unit, View compartment, Collection<View> knownSymbols) {
        List<View> allSymbols = this.getSymbols(unit, compartment, null);
        for (View symbol : allSymbols) {
            if (knownSymbols.contains(symbol)) continue;
            ViewUtil.destroy((View)symbol);
        }
    }

    public List<View> getSymbols(TransformationUnit unit, View compartment, SymbolType type) {
        ArrayList<View> result = new ArrayList<View>();
        String visualType = HenshinVisualIDRegistry.getType(3004);
        for (Object child : compartment.getChildren()) {
            View view = (View)child;
            if (!visualType.equals(view.getType()) || type != null && SymbolType.get(view) != type) continue;
            result.add(view);
        }
        return result;
    }

    public Node createSymbol(TransformationUnit unit, View compartment, int index, SymbolType type, int x, int y) {
        Location location = NotationFactory.eINSTANCE.createLocation();
        location.setX(x);
        location.setY(y);
        Node symbol = this.provider.createNode_3004((EObject)unit, compartment, index, this.persisted, this.prefHint);
        type.set((View)symbol);
        symbol.setLayoutConstraint((LayoutConstraint)location);
        return symbol;
    }

    public View getUnitCompartment(View view) {
        String type = HenshinVisualIDRegistry.getType(7003);
        if (type.equals(view.getType())) {
            return view;
        }
        return ViewUtil.getChildBySemanticHint((View)view, (String)type);
    }
}

