/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.external.AbstractFileBasedValidator;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMStateSpaceExporter;
import org.eclipse.emf.henshin.statespace.external.prism.RatesPropertiesManager;

public abstract class AbstractPRISMTool
extends AbstractFileBasedValidator {
    protected Process invokePRISM(StateSpace stateSpace, File formulaFile, String[] args, boolean allowExperiments, IProgressMonitor monitor) throws Exception {
        String arg;
        int n;
        int n2;
        String[] stringArray;
        File smFile = this.generatePRISMFile(stateSpace, monitor);
        String prism = this.getPRISMExecutable();
        File path = RatesPropertiesManager.getPRISMPath(stateSpace);
        String baseArgs = RatesPropertiesManager.getPRISMArgs(stateSpace);
        ArrayList<String> command = new ArrayList<String>();
        command.add(path != null ? new File(String.valueOf(path.getAbsolutePath()) + File.separator + prism).getAbsolutePath() : prism);
        command.add(smFile.getAbsolutePath());
        if (formulaFile != null) {
            command.add(formulaFile.getAbsolutePath());
        }
        if (baseArgs != null) {
            stringArray = baseArgs.split(" ");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                arg = stringArray[n];
                command.add(arg.trim());
                ++n;
            }
        }
        if (args != null) {
            stringArray = args;
            n2 = args.length;
            n = 0;
            while (n < n2) {
                arg = stringArray[n];
                command.add(arg.trim());
                ++n;
            }
        }
        String constants = "";
        for (Rule rule : stateSpace.getRules()) {
            RatesPropertiesManager.Rate rate = RatesPropertiesManager.getRate(stateSpace, rule);
            if (rate == null) {
                throw new StateSpaceException("Rate for rule \"" + rule.getName() + "\" not defined (set property \"" + RatesPropertiesManager.getRateKey(rule) + "\")");
            }
            if (!allowExperiments && !rate.isConstant()) {
                throw new StateSpaceException("Rate for rule \"" + rule.getName() + "\" must be a constant");
            }
            if (constants.length() > 0) {
                constants = String.valueOf(constants) + ",";
            }
            constants = String.valueOf(constants) + RatesPropertiesManager.getRateKey(rule) + "=" + rate;
        }
        if (constants.length() > 0) {
            command.add("-const");
            command.add(constants);
        }
        System.out.println(command);
        return Runtime.getRuntime().exec(command.toArray(new String[0]), null, path);
    }

    protected File generatePRISMFile(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        String filename = stateSpace.eResource() != null ? stateSpace.eResource().getURI().trimFileExtension().lastSegment() : "statespace";
        File tmp = File.createTempFile(filename, ".sm");
        URI uri = URI.createFileURI((String)tmp.getAbsolutePath());
        PRISMStateSpaceExporter exporter = new PRISMStateSpaceExporter();
        exporter.export(stateSpace, uri, monitor);
        return tmp;
    }

    protected String getPRISMExecutable() {
        return this.isWindows() ? "prism.bat" : "prism";
    }
}

