/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.equality;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.statespace.hashcodes.HashCodeMap;

public class GraphTraversalHelper {
    private HashCodeMap hashcodes;
    private Map<EObject, List<EReference>> references;
    private Map<EObjectEReferencePair, List<EObject>> contents;

    public GraphTraversalHelper(HashCodeMap hashcodes) {
        this.hashcodes = hashcodes;
        this.references = new HashMap<EObject, List<EReference>>();
        this.contents = new HashMap<EObjectEReferencePair, List<EObject>>();
    }

    public List<EReference> getReferences(EObject object) {
        List<EReference> refs = this.references.get(object);
        if (refs == null) {
            refs = new ArrayList<EReference>((Collection<EReference>)object.eClass().getEAllReferences());
            final HashMap<EReference, Integer> difficulties = new HashMap<EReference, Integer>();
            for (EReference reference : refs) {
                difficulties.put(reference, this.getListDifficulty(GraphTraversalHelper.referenceAsList(object, reference)));
            }
            Collections.sort(refs, new Comparator<EReference>(){

                @Override
                public int compare(EReference r1, EReference r2) {
                    return (Integer)difficulties.get(r2) - (Integer)difficulties.get(r1);
                }
            });
            this.references.put(object, refs);
        }
        return refs;
    }

    public List<EObject> getContents(EObject object, EReference reference) {
        if (!this.hashcodes.containsKey(object)) {
            return GraphTraversalHelper.referenceAsList(object, reference);
        }
        EObjectEReferencePair key = new EObjectEReferencePair(object, reference);
        List<EObject> con = this.contents.get(key);
        if (con == null) {
            con = new ArrayList<EObject>(GraphTraversalHelper.referenceAsList(object, reference));
            final HashMap<EObject, Integer> difficulties = new HashMap<EObject, Integer>();
            for (EObject current : con) {
                difficulties.put(current, this.getObjectDifficulty(current, con));
            }
            Collections.sort(con, new Comparator<EObject>(){

                @Override
                public int compare(EObject o1, EObject o2) {
                    return (Integer)difficulties.get(o2) - (Integer)difficulties.get(o1);
                }
            });
            this.contents.put(key, con);
        }
        return con;
    }

    private int getObjectDifficulty(EObject object, List<EObject> list) {
        int hash = this.hashcodes.getHashCode(object);
        int difficulty = 0;
        for (EObject current : list) {
            if (current == object || (Integer)this.hashcodes.get(current) != hash) continue;
            ++difficulty;
        }
        return difficulty;
    }

    private int getListDifficulty(List<EObject> list) {
        HashSet<Integer> known = new HashSet<Integer>();
        int difficulty = 0;
        for (EObject obj : list) {
            Integer hash = (Integer)this.hashcodes.get(obj);
            if (known.contains(hash)) {
                ++difficulty;
            }
            known.add(hash);
        }
        return difficulty;
    }

    private static List<EObject> referenceAsList(EObject object, EReference reference) {
        if (reference.isMany()) {
            return (EList)object.eGet((EStructuralFeature)reference);
        }
        EObject target = (EObject)object.eGet((EStructuralFeature)reference);
        ArrayList<EObject> list = new ArrayList<EObject>();
        if (target != null) {
            list.add(target);
        }
        return list;
    }

    private static class EObjectEReferencePair {
        public EObject object;
        public EReference reference;

        public EObjectEReferencePair(EObject object, EReference reference) {
            this.object = object;
            this.reference = reference;
        }

        public int hashCode() {
            return this.object.hashCode() * 31 + this.reference.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof EObjectEReferencePair) {
                return ((EObjectEReferencePair)o).object == this.object && ((EObjectEReferencePair)o).reference == this.reference;
            }
            return false;
        }
    }
}

