/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.emf.henshin.interpreter.ui.InterpreterUIPlugin;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationResult;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class HenshinationPreview {
    protected CompareEditorInput editorInput;
    protected HenshinationResult henshinationResult;

    public HenshinationPreview(CompareEditorInput compareInput, HenshinationResult henshinationResult) {
        this.editorInput = compareInput;
        this.henshinationResult = henshinationResult;
    }

    public void showDialog(Shell shell) {
        this.editorInput.setTitle(InterpreterUIPlugin.LL("_UI_Preview_Title"));
        this.editorInput.getCompareConfiguration().setRightLabel(InterpreterUIPlugin.LL("_UI_Preview_OriginalModel"));
        this.editorInput.getCompareConfiguration().setLeftLabel(InterpreterUIPlugin.LL("_UI_Preview_TransformedModel"));
        this.editorInput.getCompareConfiguration().setLeftEditable(false);
        this.editorInput.getCompareConfiguration().setRightEditable(false);
        this.editorInput.setDirty(true);
        try {
            this.editorInput.run(null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        Dialog dlg = new Dialog(shell){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(InterpreterUIPlugin.LL("_UI_Preview_Title"));
            }

            protected IDialogSettings getDialogBoundsSettings() {
                return InterpreterUIPlugin.getPlugin().getDialogSettings();
            }

            protected Control createDialogArea(Composite parent) {
                Composite container = (Composite)super.createDialogArea(parent);
                HenshinationPreview.this.createTabFolder(container).setLayoutData((Object)new GridData(1808));
                return container;
            }

            protected boolean isResizable() {
                return true;
            }

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            }
        };
        dlg.open();
    }

    public Control createTabFolder(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        TabItem compareTabItem = new TabItem(tabFolder, 0);
        compareTabItem.setText(InterpreterUIPlugin.LL("_UI_Preview_CompareTab"));
        compareTabItem.setControl(this.editorInput.createContents((Composite)tabFolder));
        TabItem parameterTabItem = new TabItem(tabFolder, 0);
        parameterTabItem.setText(InterpreterUIPlugin.LL("_UI_Preview_ParameterTab"));
        parameterTabItem.setControl(this.createParameterTable((Composite)tabFolder));
        return tabFolder;
    }

    protected Control createParameterTable(Composite parent) {
        TableViewer tableViewer = new TableViewer(parent, 65536);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn parameterNameColumn = new TableViewerColumn(tableViewer, 0);
        parameterNameColumn.getColumn().setText(InterpreterUIPlugin.LL("_UI_Preview_ParameterTable_ParameterNameColumn"));
        parameterNameColumn.getColumn().setWidth(200);
        parameterNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Parameter)element).getName();
            }
        });
        TableViewerColumn parameterValueBeforeColumn = new TableViewerColumn(tableViewer, 0);
        parameterValueBeforeColumn.getColumn().setText(InterpreterUIPlugin.LL("_UI_Preview_ParameterTable_ValueBeforeColumn"));
        parameterValueBeforeColumn.getColumn().setWidth(200);
        parameterValueBeforeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Object value = HenshinationPreview.this.henshinationResult.getHenshination().getParameterValue(((Parameter)element).getName());
                if (value == null) {
                    return "-null-";
                }
                return value.toString();
            }
        });
        TableViewerColumn parameterValueAfterColumn = new TableViewerColumn(tableViewer, 0);
        parameterValueAfterColumn.getColumn().setText(InterpreterUIPlugin.LL("_UI_Preview_ParameterTable_ValueAfterColumn"));
        parameterValueAfterColumn.getColumn().setWidth(200);
        parameterValueAfterColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Object value = HenshinationPreview.this.henshinationResult.getUnitApplication().getParameterValues().get((Parameter)element);
                return value == null ? "null" : value.toString();
            }
        });
        tableViewer.setInput(this.henshinationResult.getUnitApplication().getParameterValues().keySet());
        return tableViewer.getTable();
    }
}

