/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.diningphils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResourceSet;
import org.eclipse.emf.henshin.statespace.util.StateSpaceExplorationHelper;

public class DiningPhilsBenchmark {
    public static void main(String[] args) {
        StateSpaceResourceSet resourceSet = new StateSpaceResourceSet("src/org/eclipse/emf/henshin/examples/diningphils/model");
        StateSpace stateSpace = resourceSet.getStateSpace("3-phils.statespace");
        StateSpaceManager manager = StateSpaceFactory.eINSTANCE.createStateSpaceManager(stateSpace, Runtime.getRuntime().availableProcessors());
        Rule createPhilRule = ((Rule)stateSpace.getRules().get(0)).getTransformationSystem().findRuleByName("createPhil");
        try {
            int phils = 3;
            while (true) {
                manager.resetStateSpace();
                long time = System.currentTimeMillis();
                int expectedStates = (int)Math.pow(3.0, phils);
                StateSpaceExplorationHelper.doExploration((StateSpaceManager)manager, (int)expectedStates, (IProgressMonitor)new NullProgressMonitor());
                if (stateSpace.getStateCount() != expectedStates || !stateSpace.getOpenStates().isEmpty()) {
                    throw new StateSpaceException("Unexpected number of states");
                }
                time = (System.currentTimeMillis() - time) / 1000L;
                System.out.println("Philosophers: " + phils);
                System.out.println("States: " + stateSpace.getStateCount());
                System.out.println("Transitions: " + stateSpace.getTransitionCount());
                System.out.println("Time: " + time + "s\n");
                EmfGraph initialStateGraph = manager.getModel((State)stateSpace.getInitialStates().get(0)).getEmfGraph();
                EmfEngine engine = new EmfEngine(initialStateGraph);
                RuleApplication app = new RuleApplication((InterpreterEngine)engine, createPhilRule);
                app.apply();
                ++phils;
            }
        }
        catch (StateSpaceException e) {
            e.printStackTrace();
            return;
        }
    }
}

