/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.oo2rdb;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.henshin.examples.oo2rdb.ATrafo;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.interpreter.util.ModelHelper;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;

public class Oo2Rdb
extends ATrafo {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/oo2rdb/model/";
    public static final String ECORE_RDB = "src/org/eclipse/emf/henshin/examples/oo2rdb/model/rdb.ecore";
    public static final String HENSHIN_OO2RDB = "src/org/eclipse/emf/henshin/examples/oo2rdb/model/oo2rdb.henshin";
    public static final String ECORE_CARRENTAL = "src/org/eclipse/emf/henshin/examples/oo2rdb/model//CarRental.ecore";

    @Override
    public void start() {
        super.start();
        ModelHelper.registerEPackageByEcoreFile((URI)URI.createFileURI((String)ECORE_RDB));
        this.performOo2RdbTransformation();
    }

    private void performOo2RdbTransformation() {
        TransformationSystem ts = (TransformationSystem)this.loadModel(HENSHIN_OO2RDB);
        EObject rootObject = this.loadModel(ECORE_CARRENTAL);
        EmfGraph emfGraph = new EmfGraph();
        emfGraph.addRoot((EObject)EcorePackageImpl.eINSTANCE);
        emfGraph.addRoot(rootObject);
        EmfEngine engine = new EmfEngine(emfGraph);
        TransformationUnit unit = ts.findUnitByName("Start");
        UnitApplication unitApp = new UnitApplication((InterpreterEngine)engine, unit);
        boolean success = unitApp.execute();
        if (success) {
            EObject result = (EObject)unitApp.getParameterValue("schema");
            System.out.println(result);
            this.saveModel("src/org/eclipse/emf/henshin/examples/oo2rdb/model/Result.xmi", result);
        } else {
            System.err.println("Application failed!");
        }
    }

    public static void main(String[] args) {
        Oo2Rdb o = new Oo2Rdb();
        o.start();
    }
}

