/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.Action;
import org.eclipse.emf.henshin.model.actions.internal.AttributeMapEditor;
import org.eclipse.emf.henshin.model.actions.internal.GenericActionHelper;
import org.eclipse.emf.henshin.model.actions.internal.MapEditor;
import org.eclipse.emf.henshin.model.actions.internal.NodeActionHelper;
import org.eclipse.emf.henshin.model.actions.internal.NodeMapEditor;
import org.eclipse.emf.henshin.model.util.HenshinACUtil;

public class AttributeActionHelper
extends GenericActionHelper<Attribute, Node> {
    public static final AttributeActionHelper INSTANCE = new AttributeActionHelper();

    @Override
    public List<Attribute> getActionElements(Node node, Action action) {
        Rule rule = node.getGraph().getContainerRule();
        ArrayList<Attribute> candidates = new ArrayList<Attribute>();
        Node lhsNode = NodeActionHelper.INSTANCE.getLhsNode(node);
        if (lhsNode != null) {
            candidates.addAll((Collection<Attribute>)lhsNode.getAttributes());
            Node rhsNode = new NodeMapEditor(rule.getRhs()).getOpposite(lhsNode);
            if (rhsNode != null) {
                candidates.addAll((Collection<Attribute>)rhsNode.getAttributes());
            }
            for (NestedCondition nc : HenshinACUtil.getAllACs(rule)) {
                Node ncNode = new NodeMapEditor(nc.getConclusion()).getOpposite(lhsNode);
                if (ncNode == null) continue;
                candidates.addAll((Collection<Attribute>)ncNode.getAttributes());
            }
        } else {
            candidates.addAll((Collection<Attribute>)node.getAttributes());
        }
        return this.filterElementsByAction(candidates, action);
    }

    @Override
    protected MapEditor<Attribute> getMapEditor(Graph target) {
        return new AttributeMapEditor(target);
    }

    @Override
    protected MapEditor<Attribute> getMapEditor(Graph source, Graph target, List<Mapping> mappings) {
        return new AttributeMapEditor(source, target, mappings);
    }
}

