/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;
import org.eclipse.emf.henshin.model.util.HenshinRuleAnalysisUtil;

public class HenshinACUtil {
    public static List<NestedCondition> getAllACs(Rule rule) {
        ArrayList<NestedCondition> acs = new ArrayList<NestedCondition>();
        HenshinACUtil.addACs(rule.getLhs().getFormula(), acs, true);
        HenshinACUtil.addACs(rule.getLhs().getFormula(), acs, false);
        return acs;
    }

    public static List<NestedCondition> getAllACs(Rule rule, boolean positive) {
        ArrayList<NestedCondition> acs = new ArrayList<NestedCondition>();
        HenshinACUtil.addACs(rule.getLhs().getFormula(), acs, positive);
        return acs;
    }

    public static NestedCondition getAC(Rule rule, String name, boolean positive) {
        for (NestedCondition ac : HenshinACUtil.getAllACs(rule, positive)) {
            if (!name.equals(ac.getConclusion().getName())) continue;
            return ac;
        }
        return null;
    }

    private static void addACs(Formula formula, List<NestedCondition> acs, boolean positive) {
        if (formula instanceof And) {
            HenshinACUtil.addACs(((And)formula).getLeft(), acs, positive);
            HenshinACUtil.addACs(((And)formula).getRight(), acs, positive);
        } else if (formula instanceof Not) {
            HenshinACUtil.addACs(((Not)formula).getChild(), acs, !positive);
        } else if (formula instanceof NestedCondition && positive) {
            acs.add((NestedCondition)formula);
        }
    }

    public static NestedCondition createAC(Rule rule, String name, boolean positive) {
        Formula acFormula;
        NestedCondition ac = HenshinFactory.eINSTANCE.createNestedCondition();
        Graph graph = HenshinFactory.eINSTANCE.createGraph();
        graph.setName(name);
        ac.setConclusion(graph);
        if (!positive) {
            Not not = HenshinFactory.eINSTANCE.createNot();
            not.setChild(ac);
            acFormula = not;
        } else {
            acFormula = ac;
        }
        if (rule.getLhs().getFormula() == null) {
            rule.getLhs().setFormula(acFormula);
        } else {
            And and = HenshinFactory.eINSTANCE.createAnd();
            and.setLeft(rule.getLhs().getFormula());
            and.setRight(acFormula);
            rule.getLhs().setFormula(and);
        }
        return ac;
    }

    public static void removeAC(Rule rule, NestedCondition ac) {
        EObject container = ac.eContainer();
        EcoreUtil.remove((EObject)ac);
        while (container instanceof UnaryFormula) {
            EObject dummy = container;
            container = container.eContainer();
            EcoreUtil.remove((EObject)dummy);
        }
        if (container instanceof BinaryFormula) {
            BinaryFormula binary = (BinaryFormula)container;
            Formula remainder = binary.getLeft() != null ? binary.getLeft() : binary.getRight();
            EcoreUtil.replace((EObject)binary, (EObject)remainder);
        }
    }

    public static boolean isAC(NestedCondition ac, boolean positive) {
        Rule rule = ac.getConclusion().getContainerRule();
        List<NestedCondition> conditions = HenshinACUtil.getAllACs(rule, positive);
        return conditions.contains(ac);
    }

    public static boolean isTrivialAC(NestedCondition ac) {
        Graph graph = ac.getConclusion();
        EList<Mapping> mappings = ac.getMappings();
        for (Node node : graph.getNodes()) {
            if (HenshinMappingUtil.getNodeOrigin(node, mappings) == null) {
                return false;
            }
            for (Attribute attribute : node.getAttributes()) {
                Attribute origin = HenshinMappingUtil.getAttributeOrigin(attribute, mappings);
                if (origin != null && HenshinRuleAnalysisUtil.valueEquals(attribute.getValue(), origin.getValue())) continue;
                return false;
            }
        }
        for (Edge edge : graph.getEdges()) {
            if (HenshinMappingUtil.getEdgeOrigin(edge, mappings) != null) continue;
            return false;
        }
        return true;
    }

    public static void removeTrivialACs(Rule rule) {
        for (NestedCondition ac : HenshinACUtil.getAllACs(rule, false)) {
            if (!HenshinACUtil.isTrivialAC(ac)) continue;
            HenshinACUtil.removeAC(rule, ac);
        }
    }
}

