/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class HenshinMultiRuleUtil {
    public static Collection<Node> getDependentNodes(Node node) {
        System.out.print("Dependent Nodes for " + node + ": ");
        if (node.getGraph().isLhs() || node.getGraph().isRhs()) {
            ArrayList<Node> result = new ArrayList<Node>();
            Rule rule = node.getGraph().getContainerRule();
            for (Rule mRule : rule.getMultiRules()) {
                Node imgNode = HenshinMultiRuleUtil.getDependentNodeInRule(node, mRule);
                if (imgNode == null) continue;
                result.add(imgNode);
            }
            System.out.println(result);
            return result;
        }
        System.out.println("none");
        return Collections.emptyList();
    }

    public static Node getDependentNodeInRule(Node node, Rule rule) {
        for (Mapping m : rule.getMultiMappings()) {
            if (m.getOrigin() != node) continue;
            return m.getImage();
        }
        return null;
    }

    public static Collection<Graph> getDependentGraphs(Graph graph) {
        ArrayList<Graph> result = new ArrayList<Graph>();
        Rule rule = graph.getContainerRule();
        boolean isLeft = graph.isLhs();
        if (rule == null) {
            return result;
        }
        for (Rule mRule : rule.getMultiRules()) {
            result.add(isLeft ? mRule.getLhs() : mRule.getRhs());
        }
        return result;
    }

    public static Collection<Edge> getDependentEdges(Edge edge) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        if (edge.getGraph() == null || edge.getGraph().getContainerRule() == null) {
            return result;
        }
        Rule rule = edge.getGraph().getContainerRule();
        for (Rule dependentRule : rule.getMultiRules()) {
            Edge dependentEdge = HenshinMultiRuleUtil.getDependentEdgeInRule(edge, dependentRule);
            if (dependentEdge == null) continue;
            result.add(dependentEdge);
        }
        return result;
    }

    public static Edge getDependentEdgeInRule(Edge edge, Rule rule) {
        Node dependentSource = HenshinMultiRuleUtil.getDependentNodeInRule(edge.getSource(), rule);
        Node dependentTarget = HenshinMultiRuleUtil.getDependentNodeInRule(edge.getTarget(), rule);
        for (Edge dependentEdgeCandidate : dependentSource.getOutgoing()) {
            if (dependentEdgeCandidate.getTarget() != dependentTarget || dependentEdgeCandidate.getType() != edge.getType()) continue;
            return dependentEdgeCandidate;
        }
        return null;
    }

    public static boolean isTrivialMultiRule(Rule multi) {
        ArrayList<GraphElement> elements = new ArrayList<GraphElement>();
        elements.addAll((Collection<GraphElement>)multi.getLhs().getNodes());
        elements.addAll((Collection<GraphElement>)multi.getLhs().getEdges());
        elements.addAll((Collection<GraphElement>)multi.getRhs().getNodes());
        elements.addAll((Collection<GraphElement>)multi.getRhs().getEdges());
        for (GraphElement element : elements) {
            if (multi.getOriginInKernelRule(element) != null) continue;
            return false;
        }
        return true;
    }

    public static void removeTrivialMultiRules(Rule kernel) {
        int i = 0;
        while (i < kernel.getMultiRules().size()) {
            Rule multi = (Rule)kernel.getMultiRules().get(i);
            if (HenshinMultiRuleUtil.isTrivialMultiRule(multi)) {
                kernel.getMultiRules().remove(i--);
            }
            ++i;
        }
    }
}

