/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.external.AbstractFileBasedValidator;
import org.eclipse.emf.henshin.statespace.external.prism.MDPStateSpaceExporter;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMExperiment;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMUtil;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;

public class MDPStateSpaceValidator
extends AbstractFileBasedValidator {
    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Checking PCTL property...", 4);
        MDPStateSpaceExporter exporter = new MDPStateSpaceExporter();
        File traFile = this.export(stateSpace, exporter, null, "nm", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        String expanded = PRISMUtil.expandLabels(this.property, this.index, exporter.getTuples(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        File pctlFile = this.createTempFile("property", ".pctl", expanded);
        monitor.subTask("Running PRISM...");
        Map<String, String> constants = PRISMUtil.getAllProbs(stateSpace, true);
        Process process = PRISMUtil.invokePRISM(stateSpace, traFile, pctlFile, null, constants, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return PRISMExperiment.parseValidationResult(stateSpace, process, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    public boolean usesProperty() {
        return true;
    }

    public String getName() {
        return "PRISM MDP";
    }
}

