/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.StateSpacePackage;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceIndexImpl;
import org.eclipse.emf.henshin.statespace.impl.StorageImpl;
import org.eclipse.emf.henshin.statespace.util.StateDistanceMonitor;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSearch;

public abstract class AbstractStateSpaceManager
extends StateSpaceIndexImpl
implements StateSpaceManager {
    private static final EAttribute METADATA_FEATURE = StateSpacePackage.eINSTANCE.getStorage_Data();
    private boolean tainted = false;
    private boolean change = false;
    private final Object stateSpaceLock = new Object();
    private StateDistanceMonitor stateDistanceMonitor;
    private int chachedMaxStateDistance;
    private Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification event) {
            Object feature = event.getFeature();
            if (!AbstractStateSpaceManager.this.change && feature != METADATA_FEATURE) {
                AbstractStateSpaceManager.this.tainted = true;
            }
            if (feature == METADATA_FEATURE && AbstractStateSpaceManager.this.chachedMaxStateDistance != AbstractStateSpaceManager.this.getStateSpace().getMaxStateDistance()) {
                AbstractStateSpaceManager.this.resetStateDistanceMonitor();
            }
        }
    };

    public AbstractStateSpaceManager(StateSpace stateSpace) {
        super(stateSpace);
        stateSpace.eAdapters().add((Object)this.adapter);
        this.resetStateDistanceMonitor();
        stateSpace.updateEqualityHelper();
    }

    private void resetStateDistanceMonitor() {
        this.stateDistanceMonitor = this.getStateSpace().getMaxStateDistance() >= 0 ? new StateDistanceMonitor(this.getStateSpace()) : null;
    }

    @Override
    public final void reload(IProgressMonitor monitor) throws StateSpaceException {
        monitor.beginTask("Reload models", this.getStateSpace().getStates().size() + 3);
        StateSpace stateSpace = this.getStateSpace();
        EqualityHelper equalityHelper = stateSpace.getEqualityHelper();
        stateSpace.updateEqualityHelper();
        this.clearCache();
        monitor.worked(1);
        try {
            try {
                this.resetIndex();
                monitor.worked(1);
                for (State state : stateSpace.getStates()) {
                    if (state.isInitial()) {
                        state.setDerivedFrom(-1);
                        continue;
                    }
                    state.setModel(null);
                }
                monitor.worked(1);
                boolean useObjectKeys = !equalityHelper.getIdentityTypes().isEmpty();
                for (State state : stateSpace.getStates()) {
                    Model model = this.getModel(state);
                    if (useObjectKeys) {
                        model.updateObjectKeys(equalityHelper.getIdentityTypes());
                        state.setObjectKeys(model.getObjectKeys());
                    }
                    state.setObjectCount(model.getEmfGraph().geteObjects().size());
                    int hash = equalityHelper.hashCode(model);
                    if (this.getState(model, hash) != null) {
                        this.markTainted();
                        throw new StateSpaceException("Duplicate state: " + state.getIndex());
                    }
                    state.setHashCode(hash);
                    this.setOpen(state, this.isOpen(state));
                    this.addToIndex(state);
                    monitor.worked(1);
                }
            }
            catch (Throwable t) {
                this.markTainted();
                throw new StateSpaceException(t);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<State> exploreStates(List<State> states, boolean generateLocation) throws StateSpaceException {
        ArrayList<State> result = new ArrayList<State>();
        try {
            for (State state : states) {
                result.addAll(this.exploreState(state, generateLocation));
            }
        }
        catch (Throwable t) {
            if (t instanceof StateSpaceException) {
                throw (StateSpaceException)t;
            }
            throw new StateSpaceException(t);
        }
        return result;
    }

    protected abstract List<State> exploreState(State var1, boolean var2) throws StateSpaceException;

    protected State findState(Model model, int hashCode, Collection<State> states) throws StateSpaceException {
        for (State state : states) {
            if (hashCode != state.getHashCode() || !this.getStateSpace().getEqualityHelper().equals(model, this.getModel(state))) continue;
            return state;
        }
        return null;
    }

    protected boolean isOpen(State state) throws StateSpaceException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOpen(State state, boolean open) {
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            state.setOpen(open);
            if (open) {
                this.getStateSpace().getOpenStates().add(state);
            } else {
                this.getStateSpace().getOpenStates().remove(state);
            }
            this.change = false;
        }
    }

    protected State createOpenState(Model model, int hash, State derivedFrom) {
        return this.createOpenState(model, hash, derivedFrom, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final State createOpenState(Model model, int hash, State derivedFrom, int[] location) {
        State state = StateSpaceFactory.eINSTANCE.createState();
        state.setIndex(this.getStateSpace().getStates().size());
        state.setHashCode(hash);
        state.setDerivedFrom(derivedFrom != null ? derivedFrom.getIndex() : -1);
        state.setModel(model);
        state.setOpen(true);
        if (location != null) {
            state.setLocation(location);
        }
        if (!this.getStateSpace().getEqualityHelper().getIdentityTypes().isEmpty()) {
            int[] objectKeys = model.getObjectKeys();
            state.setObjectKeys(objectKeys);
            state.setObjectCount(objectKeys.length);
        }
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            this.getStateSpace().getStates().add((Object)state);
            this.getStateSpace().getOpenStates().add(state);
            if (this.stateDistanceMonitor != null) {
                this.stateDistanceMonitor.updateDistance(state);
            }
            this.change = false;
        }
        this.addToIndex(state);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final State createInitialState(Model model) throws StateSpaceException {
        int hash;
        State state;
        Resource resource = model.getResource();
        if (resource == null || resource.getURI() == null) {
            throw new IllegalArgumentException("Model is not persisted");
        }
        EcoreUtil.resolveAll((EObject)model);
        if (!this.getStateSpace().getEqualityHelper().getIdentityTypes().isEmpty()) {
            model.updateObjectKeys(this.getStateSpace().getEqualityHelper().getIdentityTypes());
        }
        if ((state = this.getState(model, hash = this.getStateSpace().getEqualityHelper().hashCode(model))) != null) {
            return state;
        }
        State initial = this.createOpenState(model, hash, null);
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            this.getStateSpace().getInitialStates().add((Object)initial);
            if (this.stateDistanceMonitor != null) {
                this.stateDistanceMonitor.updateDistance(state);
            }
            this.change = false;
        }
        return initial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<State> removeState(State state) throws StateSpaceException {
        if (this.tainted) {
            throw new StateSpaceException();
        }
        ArrayList<State> removed = new ArrayList<State>();
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            if (this.getStateSpace().removeState(state)) {
                removed.addAll(StateSpaceSearch.removeUnreachableStates(this.getStateSpace()));
                removed.add(state);
            }
            this.getStateSpace().getOpenStates().removeAll(removed);
            this.getStateSpace().getInitialStates().removeAll(removed);
            HashSet<Transition> transitions = new HashSet<Transition>();
            for (State current : removed) {
                this.removeFromIndex(current);
                transitions.addAll((Collection<Transition>)current.getOutgoing());
                transitions.addAll((Collection<Transition>)current.getIncoming());
            }
            int number = this.getStateSpace().getTransitionCount() - transitions.size();
            this.getStateSpace().setTransitionCount(number);
            this.change = false;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resetStateSpace() throws StateSpaceException {
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            this.getStateSpace().updateEqualityHelper();
            this.getStateSpace().getStates().clear();
            this.getStateSpace().getOpenStates().clear();
            this.getStateSpace().getStates().addAll(this.getStateSpace().getInitialStates());
            for (State initial : this.getStateSpace().getStates()) {
                initial.getOutgoing().clear();
                initial.getIncoming().clear();
            }
            this.getStateSpace().setTransitionCount(0);
            for (State initial : this.getStateSpace().getStates()) {
                Model model = initial.getModel();
                model.setObjectKeys(StorageImpl.EMPTY_DATA);
                if (!this.getStateSpace().getEqualityHelper().getIdentityTypes().isEmpty()) {
                    model.updateObjectKeys(this.getStateSpace().getEqualityHelper().getIdentityTypes());
                }
                initial.setObjectKeys(model.getObjectKeys());
            }
            this.resetStateDistanceMonitor();
            this.change = false;
        }
        try {
            this.reload((IProgressMonitor)new NullProgressMonitor());
            this.tainted = false;
        }
        catch (StateSpaceException e) {
            this.tainted = true;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transition createTransition(State source, State target, Rule rule, int match, int[] paramIDs) {
        Transition transition = StateSpaceFactory.eINSTANCE.createTransition();
        transition.setRule(rule);
        transition.setMatch(match);
        transition.setParameterKeys(paramIDs);
        transition.setParameterCount(paramIDs.length);
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            transition.setSource(source);
            transition.setTarget(target);
            this.getStateSpace().setTransitionCount(this.getStateSpace().getTransitionCount() + 1);
            if (this.stateDistanceMonitor != null) {
                this.stateDistanceMonitor.updateDistance(transition.getTarget());
            }
            this.change = false;
        }
        return transition;
    }

    protected static Transition findTransition(State source, State target, Rule rule, int match, int[] paramIDs) {
        for (Transition transition : source.getOutgoing()) {
            if (target != transition.getTarget() || rule != null && rule != transition.getRule() || paramIDs != null && !Arrays.equals(paramIDs, transition.getParameterKeys()) || match >= 0 && transition.getMatch() != match) continue;
            return transition;
        }
        return null;
    }

    @Override
    public int getStateDistance(State state) {
        if (this.stateDistanceMonitor != null) {
            return this.stateDistanceMonitor.getDistance(state);
        }
        return -1;
    }

    protected boolean isTainted() {
        return this.tainted;
    }

    protected void markTainted() {
        this.tainted = true;
    }
}

