/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Or;

public class ToggleJunctionCommand
extends AbstractCommand {
    protected BinaryFormula junction;
    protected BinaryFormula newJunction;
    protected Collection<?> affectedObjects;

    public ToggleJunctionCommand(BinaryFormula junction) {
        this.junction = junction;
    }

    protected boolean prepare() {
        return this.junction instanceof And || this.junction instanceof Or;
    }

    public void execute() {
        if (this.junction instanceof And) {
            this.newJunction = HenshinFactory.eINSTANCE.createOr();
        }
        if (this.junction instanceof Or) {
            this.newJunction = HenshinFactory.eINSTANCE.createAnd();
        }
        this.redo();
    }

    public void redo() {
        this.newJunction.setLeft(this.junction.getLeft());
        this.newJunction.setRight(this.junction.getRight());
        this.junction.eContainer().eSet(this.junction.eContainingFeature(), (Object)this.newJunction);
        this.affectedObjects = Collections.singleton(this.newJunction);
    }

    public void undo() {
        this.junction.setLeft(this.newJunction.getLeft());
        this.junction.setRight(this.newJunction.getRight());
        this.newJunction.eContainer().eSet(this.newJunction.eContainingFeature(), (Object)this.junction);
        this.affectedObjects = Collections.singleton(this.junction);
    }

    public boolean canUndo() {
        return true;
    }

    public Collection<?> getAffectedObjects() {
        return this.affectedObjects;
    }
}

