/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.menuContributors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.henshin.editor.commands.MenuContributor;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class CreateDynamicMC
extends MenuContributor {
    public static MenuContributor INSTANCE = new CreateDynamicMC();
    Graph graph;
    Map<EClass, Integer> counts = new HashMap<EClass, Integer>();
    protected Action DUMMY_ACTION = new Action("dummy"){};

    @Override
    protected void contributeActions(IMenuManager menuManager, List<?> selection) {
        if (selection.size() != 1) {
            return;
        }
        this.counts.clear();
        if (selection.get(0) instanceof Node) {
            final Node node = (Node)selection.get(0);
            if (node.getType() == null || node.getGraph() == null) {
                return;
            }
            this.graph = node.getGraph();
            menuManager.add((IContributionItem)new DynamicReferenceMenu("Create Path ..", node.getType(), new NodeCommand(){

                @Override
                Node getNode() {
                    return node;
                }
            }));
        } else if (selection.get(0) instanceof Graph) {
            this.graph = (Graph)selection.get(0);
            menuManager.add((IContributionItem)new DynamicPackageSelectionMenu("Create Path .."));
        }
    }

    protected Collection<Node> findNodesForTypes(EClass eClass) {
        HashSet<Node> result = new HashSet<Node>();
        for (Node node : this.graph.getNodes()) {
            if (node.getType() == null || !eClass.isSuperTypeOf(node.getType()) && !eClass.getName().equals("EObject")) continue;
            result.add(node);
        }
        return result;
    }

    protected Collection<EClass> findSubTypes(EClass superClass) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EPackage pack : this.graph.getContainerRule().getTransformationSystem().getImports()) {
            for (EClassifier eClassifier : pack.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || !superClass.isSuperTypeOf(eClass = (EClass)eClassifier)) continue;
                result.add(eClass);
            }
        }
        return result;
    }

    protected String getNewName(EClass eClass) {
        int count = this.counts.containsKey(eClass) ? this.counts.get(eClass) : 0;
        this.counts.put(eClass, count + 1);
        return "node_" + (this.graph.getNodes().size() + 1);
    }

    class AppendEdgeCommand
    extends CompoundCommand {
        EReference reference;
        NodeCommand cmd;
        Edge edge;

        public AppendEdgeCommand(EReference reference, NodeCommand cmd) {
            this.reference = reference;
            this.cmd = cmd;
        }

        protected boolean prepare() {
            return true;
        }

        public Edge getEdge() {
            return this.edge;
        }

        public void execute() {
            this.appendAndExecute((Command)this.cmd);
            this.edge = HenshinFactory.eINSTANCE.createEdge();
            this.edge.setType(this.reference);
            this.appendAndExecute((Command)new AddCommand(CreateDynamicMC.this.domain, (EObject)CreateDynamicMC.this.graph, (EStructuralFeature)HenshinPackage.eINSTANCE.getGraph_Edges(), (Object)this.edge));
            this.appendAndExecute((Command)new SetCommand(CreateDynamicMC.this.domain, (EObject)this.edge, (EStructuralFeature)HenshinPackage.eINSTANCE.getEdge_Source(), (Object)this.cmd.getNode()));
        }
    }

    class AppendEdgeToNode
    extends NodeCommand {
        Node node;
        AppendEdgeCommand cmd;

        public AppendEdgeToNode(Node node, AppendEdgeCommand cmd) {
            this.cmd = cmd;
            this.node = node;
        }

        public void execute() {
            this.appendAndExecute((Command)this.cmd);
            this.appendAndExecute((Command)new SetCommand(CreateDynamicMC.this.domain, (EObject)this.cmd.getEdge(), (EStructuralFeature)HenshinPackage.eINSTANCE.getEdge_Target(), (Object)this.node));
        }

        @Override
        Node getNode() {
            return this.node;
        }
    }

    class AppendNodeCommand
    extends NodeCommand {
        EClass eClass;
        AppendEdgeCommand cmd;
        Node node;

        public AppendNodeCommand(EClass eClass, AppendEdgeCommand cmd) {
            this.eClass = eClass;
            this.cmd = cmd;
        }

        public void execute() {
            this.appendAndExecute((Command)this.cmd);
            this.node = HenshinFactory.eINSTANCE.createNode();
            this.node.setType(this.eClass);
            this.node.setName(CreateDynamicMC.this.getNewName(this.eClass));
            this.appendAndExecute((Command)new AddCommand(CreateDynamicMC.this.domain, (EObject)CreateDynamicMC.this.graph, (EStructuralFeature)HenshinPackage.eINSTANCE.getGraph_Nodes(), (Object)this.node));
            this.appendAndExecute((Command)new SetCommand(CreateDynamicMC.this.domain, (EObject)this.cmd.getEdge(), (EStructuralFeature)HenshinPackage.eINSTANCE.getEdge_Target(), (Object)this.node));
        }

        @Override
        public Node getNode() {
            return this.node;
        }
    }

    class CreateNodeCommand
    extends NodeCommand {
        EClass eClass;
        Node node;

        public CreateNodeCommand(EClass eClass) {
            this.eClass = eClass;
        }

        public void execute() {
            this.node = HenshinFactory.eINSTANCE.createNode();
            this.node.setType(this.eClass);
            this.node.setName(CreateDynamicMC.this.getNewName(this.eClass));
            this.appendAndExecute((Command)new AddCommand(CreateDynamicMC.this.domain, (EObject)CreateDynamicMC.this.graph, (EStructuralFeature)HenshinPackage.eINSTANCE.getGraph_Nodes(), (Object)this.node));
        }

        @Override
        public Node getNode() {
            return this.node;
        }
    }

    protected class DynamicClassConnectionMenu
    extends DynamicEClassBasedMenuManager {
        NodeCommand cmd;

        public DynamicClassConnectionMenu(String text, EClass eClass, NodeCommand cmd) {
            super(text, eClass);
            this.cmd = cmd;
        }

        @Override
        protected void populateMenu(IMenuManager manager, EClass eClass) {
            manager.add(CreateDynamicMC.this.createAction("Create", (Command)this.cmd));
            manager.add((IContributionItem)new DynamicReferenceMenu("Create and Expand ..", eClass, this.cmd));
        }
    }

    protected class DynamicClassSelectionMenu
    extends DynamicMenuManager {
        EPackage ePackage;

        public DynamicClassSelectionMenu(String text, EPackage ePackage) {
            super(text);
            this.ePackage = ePackage;
        }

        @Override
        protected void populateMenu(IMenuManager manager) {
            for (EClassifier classifier : this.ePackage.getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                EClass eClass = (EClass)classifier;
                String label = eClass.getName();
                if (eClass.isAbstract()) {
                    label = String.valueOf(label) + " (abstract)";
                }
                if (eClass.isInterface()) {
                    label = String.valueOf(label) + " (interface)";
                }
                manager.add((IContributionItem)new DynamicClassConnectionMenu(label, eClass, new CreateNodeCommand(eClass)));
            }
        }
    }

    protected abstract class DynamicEClassBasedMenuManager
    extends DynamicMenuManager {
        protected EClass eClass;

        public DynamicEClassBasedMenuManager(String text, EClass eClass) {
            super(text);
            this.eClass = eClass;
        }

        @Override
        protected final void populateMenu(IMenuManager manager) {
            this.populateMenu(manager, this.eClass);
        }

        protected abstract void populateMenu(IMenuManager var1, EClass var2);
    }

    protected abstract class DynamicMenuManager
    extends MenuManager {
        public DynamicMenuManager(String text) {
            super(text);
            this.add((IAction)CreateDynamicMC.this.DUMMY_ACTION);
            this.setRemoveAllWhenShown(true);
            this.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    DynamicMenuManager.this.populateMenu(manager);
                }
            });
        }

        protected abstract void populateMenu(IMenuManager var1);
    }

    protected class DynamicPackageSelectionMenu
    extends DynamicMenuManager {
        public DynamicPackageSelectionMenu(String text) {
            super(text);
        }

        @Override
        protected void populateMenu(IMenuManager manager) {
            for (EPackage importedPackage : CreateDynamicMC.this.graph.getContainerRule().getTransformationSystem().getImports()) {
                manager.add((IContributionItem)new DynamicClassSelectionMenu(importedPackage.getName(), importedPackage));
            }
        }
    }

    protected class DynamicReferenceMenu
    extends DynamicEClassBasedMenuManager {
        NodeCommand cmd;

        public DynamicReferenceMenu(String text, EClass eClass, NodeCommand cmd) {
            super(text, eClass);
            this.cmd = cmd;
        }

        @Override
        protected void populateMenu(IMenuManager manager, EClass eClass) {
            for (EReference reference : eClass.getEAllReferences()) {
                String label = reference.getName();
                if (reference.isDerived()) {
                    label = String.valueOf(label) + " (derived)";
                }
                manager.add((IContributionItem)new DynamicSubClassSelectionMenu(label, reference.getEReferenceType(), new AppendEdgeCommand(reference, this.cmd)));
            }
        }
    }

    protected class DynamicSubClassSelectionMenu
    extends DynamicEClassBasedMenuManager {
        AppendEdgeCommand cmd;

        public DynamicSubClassSelectionMenu(String text, EClass eClass, AppendEdgeCommand cmd) {
            super(text, eClass);
            this.cmd = cmd;
        }

        protected IMenuManager populateConnectMenu(IMenuManager manager, EClass eClass) {
            for (Node node : CreateDynamicMC.this.findNodesForTypes(eClass)) {
                manager.add(CreateDynamicMC.this.createAction(String.valueOf(node.getName()) + ":" + node.getType().getName(), (Command)new AppendEdgeToNode(node, this.cmd)));
            }
            return manager;
        }

        protected IMenuManager populateConnectAndExpandMenu(IMenuManager manager, EClass eClass) {
            for (Node node : CreateDynamicMC.this.findNodesForTypes(eClass)) {
                manager.add((IContributionItem)new DynamicReferenceMenu(String.valueOf(node.getName()) + ":" + node.getType().getName(), node.getType(), new AppendEdgeToNode(node, this.cmd)));
            }
            return manager;
        }

        @Override
        protected void populateMenu(IMenuManager manager, EClass eClass) {
            for (EClass subClass : CreateDynamicMC.this.findSubTypes(eClass)) {
                String label = subClass.getName();
                if (subClass.isAbstract()) {
                    label = String.valueOf(label) + " (abstract)";
                }
                if (subClass.isInterface()) {
                    label = String.valueOf(label) + " (interface)";
                }
                manager.add((IContributionItem)new DynamicClassConnectionMenu(label, subClass, new AppendNodeCommand(subClass, this.cmd)));
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)this.populateConnectMenu((IMenuManager)new MenuManager("Connect"), eClass));
            manager.add((IContributionItem)this.populateConnectAndExpandMenu((IMenuManager)new MenuManager("Connect and Expand .."), eClass));
        }
    }

    abstract class NodeCommand
    extends CompoundCommand {
        NodeCommand() {
        }

        protected boolean prepare() {
            return true;
        }

        abstract Node getNode();
    }
}

