/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard.widgets;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.emf.henshin.interpreter.ui.util.ParameterConfiguration;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ParameterEditTable {
    protected int CONTROL_OFFSET = 5;
    protected Collection<ParameterChangeListener> listeners = new ArrayList<ParameterChangeListener>();
    protected TableViewer tableViewer;
    protected Group container;

    public ParameterEditTable(Composite parent) {
        this.container = new Group(parent, 0);
        this.container.setText(HenshinInterpreterUIPlugin.LL("_UI_SetParameters"));
        this.container.setLayout((Layout)new FormLayout());
        this.tableViewer = new TableViewer((Composite)this.container, 65536);
        FormData data = new FormData();
        data.top = new FormAttachment(0, this.CONTROL_OFFSET);
        data.left = new FormAttachment(0, this.CONTROL_OFFSET);
        data.right = new FormAttachment(100, -this.CONTROL_OFFSET);
        data.bottom = new FormAttachment(100, -this.CONTROL_OFFSET);
        data.height = 80;
        this.tableViewer.getTable().setLayoutData((Object)data);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.buildColumns();
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                Collection paramCfgs = (Collection)inputElement;
                return paramCfgs.toArray();
            }

            public void dispose() {
            }
        });
    }

    public Control getControl() {
        return this.container;
    }

    protected void buildColumns() {
        TableViewerColumn keyColumn = new TableViewerColumn(this.tableViewer, 0);
        keyColumn.getColumn().setText(HenshinInterpreterUIPlugin.LL("_UI_ParameterColumn_Name"));
        keyColumn.getColumn().setWidth(100);
        keyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object entry) {
                return ((ParameterConfiguration)entry).getName();
            }
        });
        TableViewerColumn typeColumn = new TableViewerColumn(this.tableViewer, 0);
        typeColumn.getColumn().setText(HenshinInterpreterUIPlugin.LL("_UI_ParameterColumn_Type"));
        typeColumn.getColumn().setWidth(100);
        typeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ParameterConfiguration paramCfg = (ParameterConfiguration)element;
                return paramCfg.getTypeLabel();
            }
        });
        typeColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                ParameterConfiguration paramCfg = (ParameterConfiguration)element;
                paramCfg.setType((Integer)value);
                for (ParameterChangeListener l : ParameterEditTable.this.listeners) {
                    l.parameterChanged(paramCfg);
                }
                ParameterEditTable.this.tableViewer.refresh();
            }

            protected Object getValue(Object element) {
                ParameterConfiguration paramCfg = (ParameterConfiguration)element;
                return paramCfg.getType();
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)ParameterEditTable.this.tableViewer.getTable(), ParameterConfiguration.getSupportedTypes().values().toArray(new String[0]), 8);
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        TableViewerColumn valueColumn = new TableViewerColumn(this.tableViewer, 0);
        valueColumn.getColumn().setText(HenshinInterpreterUIPlugin.LL("_UI_ParameterColumn_Value"));
        valueColumn.getColumn().setWidth(100);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ParameterConfiguration paramCfg = (ParameterConfiguration)element;
                switch (paramCfg.getType()) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return "null";
                    }
                }
                return paramCfg.getValue().toString();
            }
        });
        valueColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected void setValue(Object element, Object value) {
                ParameterConfiguration paramCfg = (ParameterConfiguration)element;
                try {
                    switch (paramCfg.getType()) {
                        case 2: {
                            paramCfg.setValue(value.toString());
                            break;
                        }
                        case 5: {
                            paramCfg.setValue(Float.valueOf(Float.parseFloat(value.toString())));
                            break;
                        }
                        case 7: {
                            paramCfg.setValue(Double.parseDouble(value.toString()));
                            break;
                        }
                        case 4: {
                            paramCfg.setValue(Integer.parseInt(value.toString()));
                            break;
                        }
                        case 6: {
                            paramCfg.setValue(Long.parseLong(value.toString()));
                            break;
                        }
                        case 3: {
                            paramCfg.setValue((Integer)value > 0);
                            break;
                        }
                        default: {
                            paramCfg.setValue(value);
                        }
                    }
                    for (ParameterChangeListener l : ParameterEditTable.this.listeners) {
                        l.parameterChanged(paramCfg);
                    }
                    ParameterEditTable.this.tableViewer.refresh();
                }
                catch (Exception exception) {}
            }

            protected Object getValue(Object entry) {
                ParameterConfiguration paramCfg = (ParameterConfiguration)entry;
                System.out.println("celleditor getvalue: " + paramCfg.getValue() + "(" + paramCfg.getTypeLabel() + ")");
                switch (paramCfg.getType()) {
                    case 3: {
                        boolean value = (Boolean)paramCfg.getValue();
                        return value ? 1 : 0;
                    }
                }
                return paramCfg.getValue().toString();
            }

            protected CellEditor getCellEditor(Object element) {
                ParameterConfiguration paramCfg = (ParameterConfiguration)element;
                switch (paramCfg.getType()) {
                    case 3: {
                        return new ComboBoxCellEditor((Composite)ParameterEditTable.this.tableViewer.getTable(), new String[]{"false", "true"}, 8);
                    }
                }
                return new TextCellEditor((Composite)ParameterEditTable.this.tableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                ParameterConfiguration paramCfg = (ParameterConfiguration)element;
                return paramCfg.getType() != 1 && paramCfg.getType() != 0;
            }
        });
    }

    public void addParameterChangeListener(ParameterChangeListener listener) {
        this.listeners.add(listener);
    }

    public void setParameters(Collection<ParameterConfiguration> paramCfgs) {
        this.tableViewer.setInput(paramCfgs);
    }

    public static interface ParameterChangeListener {
        public void parameterChanged(ParameterConfiguration var1);
    }
}

