/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;

public class DeduceParametersCommand
extends AbstractCommand {
    protected Rule rule;
    protected Set<String> parameterNames;
    protected List<Parameter> newParameters;

    public DeduceParametersCommand(Rule rule) {
        this.rule = rule;
        this.parameterNames = new HashSet<String>();
        this.newParameters = new ArrayList<Parameter>();
    }

    protected boolean prepare() {
        return this.rule != null && (!this.rule.getLhs().getNodes().isEmpty() || !this.rule.getRhs().getNodes().isEmpty());
    }

    public void execute() {
        this.deduceParametersFromGraph(this.rule.getLhs());
        this.deduceParametersFromGraph(this.rule.getRhs());
        for (Parameter p : this.rule.getParameters()) {
            this.parameterNames.remove(p.getName());
        }
        for (String name : this.parameterNames) {
            HenshinFactory factory = HenshinFactory.eINSTANCE;
            Parameter para = factory.createParameter();
            para.setName(name);
            this.newParameters.add(para);
        }
        this.redo();
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.rule.getParameters().removeAll(this.newParameters);
    }

    public void redo() {
        this.rule.getParameters().addAll(this.newParameters);
    }

    private void deduceParametersFromGraph(Graph graph) {
        for (Node n : graph.getNodes()) {
            if (n.getName() != null && !n.getName().trim().isEmpty()) {
                this.parameterNames.add(n.getName().trim());
            }
            for (Attribute a : n.getAttributes()) {
                String value;
                if (a.getValue() == null || !(value = a.getValue().trim()).matches("^\\w+$") || !value.matches("^.*[^0-9].*$")) continue;
                this.parameterNames.add(value);
            }
        }
    }
}

