/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.henshin.diagram.navigator.HenshinAbstractNavigatorItem;
import org.eclipse.emf.henshin.diagram.navigator.HenshinNavigatorGroup;
import org.eclipse.emf.henshin.diagram.navigator.HenshinNavigatorItem;
import org.eclipse.emf.henshin.diagram.part.HenshinVisualIDRegistry;
import org.eclipse.emf.henshin.diagram.part.Messages;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class HenshinNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public HenshinNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (HenshinNavigatorContentProvider.this.myViewer != null) {
                    HenshinNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                HenshinNavigatorContentProvider.this.unloadAllResources();
                HenshinNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                HenshinNavigatorContentProvider.this.unloadAllResources();
                HenshinNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                HenshinNavigatorContentProvider.this.unloadAllResources();
                HenshinNavigatorContentProvider.this.asyncRefresh();
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        this.myViewer = null;
        this.unloadAllResources();
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    void unloadAllResources() {
        for (Resource nextResource : this.myEditingDomain.getResourceSet().getResources()) {
            nextResource.unload();
        }
    }

    void asyncRefresh() {
        if (this.myViewer != null && !this.myViewer.getControl().isDisposed()) {
            this.myViewer.getControl().getDisplay().asyncExec(this.myViewerRefreshRunnable);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList<HenshinNavigatorItem> result = new ArrayList<HenshinNavigatorItem>();
            ArrayList<View> topViews = new ArrayList<View>(resource.getContents().size());
            for (EObject o : resource.getContents()) {
                if (!(o instanceof View)) continue;
                topViews.add((View)o);
            }
            result.addAll(this.createNavigatorItems(this.selectViewsByType(topViews, "Henshin"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof HenshinNavigatorGroup) {
            HenshinNavigatorGroup group = (HenshinNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof HenshinNavigatorItem) {
            HenshinNavigatorItem navigatorItem = (HenshinNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (HenshinVisualIDRegistry.getVisualID(view)) {
            case 4001: {
                LinkedList<HenshinNavigatorGroup> result = new LinkedList<HenshinNavigatorGroup>();
                Edge sv = (Edge)view;
                HenshinNavigatorGroup target = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Edge_4001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                HenshinNavigatorGroup source = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Edge_4001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(3001));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(3001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 3001: {
                LinkedList<HenshinAbstractNavigatorItem> result = new LinkedList<HenshinAbstractNavigatorItem>();
                Node sv = (Node)view;
                HenshinNavigatorGroup incominglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Node_3001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                HenshinNavigatorGroup outgoinglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Node_3001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(7002));
                connectedViews = this.getChildrenByType(connectedViews, HenshinVisualIDRegistry.getType(3002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3004: {
                LinkedList<HenshinNavigatorGroup> result = new LinkedList<HenshinNavigatorGroup>();
                Node sv = (Node)view;
                HenshinNavigatorGroup incominglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Node_3004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                HenshinNavigatorGroup outgoinglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Node_3004_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 1000: {
                LinkedList<HenshinAbstractNavigatorItem> result = new LinkedList<HenshinAbstractNavigatorItem>();
                Diagram sv = (Diagram)view;
                HenshinNavigatorGroup links = new HenshinNavigatorGroup(Messages.NavigatorGroupName_TransformationSystem_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(2001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(2002));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4001));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 3003: {
                LinkedList<HenshinNavigatorGroup> result = new LinkedList<HenshinNavigatorGroup>();
                Node sv = (Node)view;
                HenshinNavigatorGroup incominglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_TransformationUnit_3003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                HenshinNavigatorGroup outgoinglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_TransformationUnit_3003_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3002: {
                LinkedList<HenshinNavigatorGroup> result = new LinkedList<HenshinNavigatorGroup>();
                Node sv = (Node)view;
                HenshinNavigatorGroup incominglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Attribute_3002_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                HenshinNavigatorGroup outgoinglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Attribute_3002_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2002: {
                LinkedList<HenshinAbstractNavigatorItem> result = new LinkedList<HenshinAbstractNavigatorItem>();
                Node sv = (Node)view;
                HenshinNavigatorGroup incominglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_TransformationUnit_2002_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                HenshinNavigatorGroup outgoinglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_TransformationUnit_2002_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, HenshinVisualIDRegistry.getType(3004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, HenshinVisualIDRegistry.getType(3003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4002: {
                LinkedList<HenshinNavigatorGroup> result = new LinkedList<HenshinNavigatorGroup>();
                Edge sv = (Edge)view;
                HenshinNavigatorGroup target = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Link_4002_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                HenshinNavigatorGroup source = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Link_4002_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(2001));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(2002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(3001));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(3002));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(3004));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(3003));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(2001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(2002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(3001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(3002));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(3004));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(3003));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 2001: {
                LinkedList<HenshinAbstractNavigatorItem> result = new LinkedList<HenshinAbstractNavigatorItem>();
                Node sv = (Node)view;
                HenshinNavigatorGroup incominglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Rule_2001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                HenshinNavigatorGroup outgoinglinks = new HenshinNavigatorGroup(Messages.NavigatorGroupName_Rule_2001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(7001));
                connectedViews = this.getChildrenByType(connectedViews, HenshinVisualIDRegistry.getType(3001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), HenshinVisualIDRegistry.getType(4002));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection<View> getLinksSourceByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection<View> getLinksTargetByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection<View> getOutgoingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getSourceEdges(), type));
        }
        return result;
    }

    private Collection<View> getIncomingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getTargetEdges(), type));
        }
        return result;
    }

    private Collection<View> getChildrenByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getChildren(), type));
        }
        return result;
    }

    private Collection<View> getDiagramLinksByType(Collection<Diagram> diagrams, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection<View>)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection<View> selectViewsByType(Collection<View> views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Henshin".equals(HenshinVisualIDRegistry.getModelID(view));
    }

    private Collection<HenshinNavigatorItem> createNavigatorItems(Collection<View> views, Object parent, boolean isLeafs) {
        ArrayList<HenshinNavigatorItem> result = new ArrayList<HenshinNavigatorItem>(views.size());
        for (View nextView : views) {
            result.add(new HenshinNavigatorItem(nextView, parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof HenshinAbstractNavigatorItem) {
            HenshinAbstractNavigatorItem abstractNavigatorItem = (HenshinAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

