/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.jobs;

import java.io.IOException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractStateSpaceJob
extends Job {
    private StateSpaceManager manager;
    private boolean abort;

    public AbstractStateSpaceJob(String name, StateSpaceManager manager) {
        super(name);
        this.manager = manager;
    }

    protected void saveStateSpace() {
        if (this.manager != null) {
            Resource resource = this.manager.getStateSpace().eResource();
            try {
                resource.save(null);
            }
            catch (IOException e) {
                StateSpaceExplorerPlugin.getInstance().logError("Error saving state space", e);
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Save State Space", (String)"Error saving state space. See the error log for more information.");
            }
        }
    }

    public StateSpaceManager getStateSpaceManager() {
        return this.manager;
    }

    public void setStateSpaceManager(StateSpaceManager manager) {
        this.manager = manager;
    }

    public void abort() {
        this.abort = true;
        this.cancel();
    }

    public boolean isAborted() {
        return this.abort;
    }
}

