/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;

public class OclQueries {
    public static void assertElementsInQueryResult(String contextFreeOclQuery, EGraph graph) throws AssertionError {
        BooleanOCLCondition oclQueryCondition;
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM((Collection)graph);
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        if (result.isEmpty()) {
            throw new AssertionError((Object)"expected: Query returns elements, but no elements in query result.");
        }
    }

    public static void assertObjectInQueryResult(EObject eobj, String contextFreeOclQuery, EGraph graph) throws AssertionError {
        BooleanOCLCondition oclQueryCondition;
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM((Collection)graph);
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        if (!result.contains((Object)eobj)) {
            throw new AssertionError((Object)("expected: Query result contains object <" + eobj + ">, but doesn't."));
        }
    }

    public static void assertObjectNotInQueryResult(EObject eobj, String contextFreeOclQuery, EGraph graph) throws AssertionError {
        BooleanOCLCondition oclQueryCondition;
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM((Collection)graph);
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        if (result.contains((Object)eobj)) {
            throw new AssertionError((Object)"expected: Object not in query result");
        }
    }

    public static void assertGroupInQueryResult(Collection<? extends EObject> group, String contextFreeOclQuery, EGraph graph) throws AssertionError {
        BooleanOCLCondition oclQueryCondition;
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM((Collection)graph);
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        if (!result.containsAll(group)) {
            throw new AssertionError((Object)"expected: Group is in query result");
        }
    }

    public static void assertGroupNotInQueryResult(Collection<? extends EObject> group, String contextFreeOclQuery, EGraph graph) throws AssertionError {
        BooleanOCLCondition oclQueryCondition;
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM((Collection)graph);
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        if (result.containsAll(group)) {
            throw new AssertionError((Object)"expected: Group not in query result (i.e. at least one element from group not in query result)");
        }
    }

    public static void assertNoElementFromGroupInQueryResult(Collection<? extends EObject> group, String contextFreeOclQuery, EGraph graph) throws AssertionError {
        BooleanOCLCondition oclQueryCondition;
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM((Collection)graph);
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        for (EObject eObject : group) {
            if (result.contains((Object)eObject)) {
                throw new AssertionError((Object)("expected: No element from group in query result, but at least one in query result <" + eObject + ">"));
            }
        }
    }

    public static void assertAtLeastOneElementFromGroupInQueryResult(Collection<? extends EObject> group, String contextFreeOclQuery, EGraph graph) throws AssertionError {
        BooleanOCLCondition oclQueryCondition;
        if (group.size() == 0) {
            throw new AssertionError((Object)"group is empty");
        }
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM((Collection)graph);
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        for (EObject eObject : group) {
            if (!result.contains((Object)eObject)) continue;
            return;
        }
        throw new AssertionError((Object)"expected: At least one element from group in query result, but no element from group in query result");
    }
}

