/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.migration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramTransformation {
    public static boolean transformDiagram(Map<EObject, EObject> correspondence, Map<Rule, Rule> amalgamationCorrespondence, ResourceSet resourceSet, URI diagramUri) throws IOException {
        File oldDiagramFileBackup;
        if (diagramUri == null) {
            return false;
        }
        URI diagramBackupUri = diagramUri.appendFileExtension("bak");
        for (Resource resource : resourceSet.getResources()) {
            for (EObject root : resource.getContents()) {
                if (!(root instanceof Diagram)) continue;
                DiagramTransformation.updateDiagramViews((View)((Diagram)root), correspondence, amalgamationCorrespondence);
            }
        }
        File oldDiagramFile = new File(diagramUri.toFileString());
        if (!oldDiagramFile.renameTo(oldDiagramFileBackup = new File(diagramBackupUri.toFileString()))) {
            throw new FileNotFoundException();
        }
        for (Resource resource : resourceSet.getResources()) {
            if (!resource.getURI().equals((Object)diagramUri)) continue;
            resource.save(null);
            System.out.println("diagram saved.");
            return true;
        }
        return false;
    }

    private static void updateDiagramViews(View view, Map<EObject, EObject> correspondence, Map<Rule, Rule> amalgamationCorrespondence) {
        if (view.getElement() != null) {
            EObject newEdge;
            EObject newElem = correspondence.get(view.getElement());
            if (newElem != null) {
                if (newElem instanceof Rule) {
                    System.out.println("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ amalgamationUnit? " + newElem);
                    System.out.println("$$$$$$$$$$$$$$$$$$$$$ k:" + amalgamationCorrespondence.containsKey(newElem) + " v:" + amalgamationCorrespondence.containsValue(newElem));
                    System.out.println("$$$$$$$$$$$$$$$$$$$$$   " + amalgamationCorrespondence.get(newElem));
                    if (amalgamationCorrespondence.get(newElem) != null) {
                        System.out.println("found amalgamation unit correspondence, updating: " + newElem + " -> " + amalgamationCorrespondence.get(newElem));
                        newElem = (EObject)amalgamationCorrespondence.get(newElem);
                    }
                }
                System.out.println("<==" + view.getElement());
                System.out.println("Found " + view.getElement() + " --> Updating ... " + newElem);
                view.setElement(newElem);
                System.out.println("==>" + view.getElement());
            } else {
                System.out.println("Didn't find " + view.getElement() + "\t### " + view.getElement().hashCode());
            }
            System.out.println("\t source edges: (" + view.getSourceEdges().size() + ")");
            int i = 0;
            while (i < view.getSourceEdges().size()) {
                System.out.println("\t" + view.getSourceEdges().get(i));
                Edge se = (Edge)view.getSourceEdges().get(i);
                System.out.println("\t el: " + se.getElement());
                if (se != null && (newEdge = correspondence.get(se.getElement())) != null) {
                    System.out.println("\ts" + se.getElement() + " --> " + newEdge);
                    se.setElement(newEdge);
                }
                ++i;
            }
            System.out.println("\t target edges: (" + view.getTargetEdges().size() + ")");
            i = 0;
            while (i < view.getTargetEdges().size()) {
                Edge te = (Edge)view.getTargetEdges().get(i);
                if (te != null && (newEdge = correspondence.get(te.getElement())) != null) {
                    System.out.println("\tt" + te.getElement() + " --> " + newEdge);
                    te.setElement(newEdge);
                }
                ++i;
            }
            System.out.println("\t annotations (" + view.getEAnnotations().size() + ")");
            for (EAnnotation eAnn : view.getEAnnotations()) {
                int i2 = 0;
                while (i2 < eAnn.getReferences().size()) {
                    EObject eo = (EObject)eAnn.getReferences().get(i2);
                    EObject newAnnoRef = correspondence.get(eo);
                    if (newAnnoRef != null) {
                        System.out.println("\t" + eo + " --> " + newAnnoRef);
                        eAnn.getReferences().remove(i2);
                        eAnn.getReferences().add(i2, (Object)newAnnoRef);
                    } else {
                        System.out.println("\t couldn't update annotation: " + eo);
                    }
                    ++i2;
                }
            }
        }
        for (Object child : view.getChildren()) {
            DiagramTransformation.updateDiagramViews((View)child, correspondence, amalgamationCorrespondence);
        }
    }
}

