/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.probbroadcast.timed;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.external.prism.MDPStateSpaceValidator;
import org.eclipse.emf.henshin.statespace.impl.ModelImpl;
import org.eclipse.emf.henshin.statespace.impl.ParallelStateSpaceManager;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceImpl;
import org.eclipse.emf.henshin.statespace.ocl.OCLStateValidator;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResourceSet;
import org.eclipse.emf.henshin.statespace.util.StateSpaceExplorationHelper;
import org.eclipse.emf.henshin.statespace.util.StateSpaceXYPlot;

public class TimedProbBroadcast {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/probbroadcast/timed";

    static {
        OCLStateValidator.register();
    }

    public static void fixedSendProb(String path, String module, String initModel, int[] nodes, int CF, int LO, int UP, double probSend) {
        StateSpaceResourceSet resourceSet = new StateSpaceResourceSet(path);
        StateSpaceImpl stateSpace = new StateSpaceImpl(resourceSet.getModule(module, false));
        EMap props = stateSpace.getProperties();
        props.put((Object)"identityTypes", (Object)"Node,Message");
        props.put((Object)"clockDeclarations", (Object)"Message.c");
        props.put((Object)"constants", (Object)("int LO=" + LO + ",int UP=" + UP + ",int CF=" + CF));
        props.put((Object)"useClocks", (Object)"true");
        props.put((Object)"probSend1", (Object)String.valueOf(probSend));
        props.put((Object)"probSend2", (Object)"1-probSend1");
        props.put((Object)"guardSend", (Object)"LO<=u.c & u.c<=UP & v.c<=CF");
        props.put((Object)"guardDel1", (Object)"LO<=u.c & u.c<=UP & v.c>CF");
        props.put((Object)"guardDel2", (Object)"LO<=u.c & u.c<=UP & v.c>CF");
        props.put((Object)"resetsSend1", (Object)"w.c'=0");
        props.put((Object)"invariantSend", (Object)"u.c<=UP");
        ParallelStateSpaceManager manager = new ParallelStateSpaceManager((StateSpace)stateSpace);
        MDPStateSpaceValidator validator = new MDPStateSpaceValidator((StateSpaceIndex)manager);
        System.out.println("\n - Rules module: " + module);
        System.out.println(" - Initial model: " + initModel);
        System.out.println(" - Constants: CF=" + CF + ", LO=" + LO + ", UP=" + UP + ", probSend=" + probSend);
        System.out.println(" - Computing reception probabilities...");
        try {
            try {
                manager.createInitialState((Model)new ModelImpl(resourceSet.getResource(initModel)));
                System.out.println("   Node\tStates\tPmin\tPmax\tTime");
                int i = 0;
                while (i < nodes.length) {
                    System.out.print("   " + nodes[i] + "\t");
                    String goalProperty = "OCL: not self.nodes->at(" + nodes[i] + ").active";
                    props.put((Object)"goalProperty", (Object)goalProperty);
                    long time = System.currentTimeMillis();
                    manager.resetStateSpace(false);
                    new StateSpaceExplorationHelper((StateSpaceManager)manager).doExploration(-1, (IProgressMonitor)new NullProgressMonitor());
                    manager.mergeTerminalStates();
                    System.out.print(String.valueOf(stateSpace.getStateCount()) + "\t");
                    validator.setProperty("label \"goal\" = <<<" + goalProperty + ">>>;\n Pmin=?[F \"goal\"]  Pmax=?[F \"goal\"]\n");
                    StateSpaceXYPlot plot = (StateSpaceXYPlot)validator.validate(manager.getStateSpace(), null).getResult();
                    System.out.println(String.valueOf(plot.getY(0, 0)) + "\t" + plot.getY(0, 1) + "\t" + (System.currentTimeMillis() - time) / 1000L + "s");
                    ++i;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                manager.shutdown();
            }
        }
        finally {
            manager.shutdown();
        }
    }

    public static void run(String path) {
        TimedProbBroadcast.fixedSendProb(path, "tpb.henshin", "init-grid2x2.xmi", new int[]{1, 2, 3, 4}, 4, 5, 16, 0.8);
        TimedProbBroadcast.fixedSendProb(path, "tpb.henshin", "init-grid3x3.xmi", new int[]{2, 4, 3, 5, 7, 6, 8, 9}, 4, 5, 16, 0.8);
    }

    public static void main(String[] args) {
        TimedProbBroadcast.run(PATH);
    }
}

