/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.info.RuleInfo;
import org.eclipse.emf.henshin.interpreter.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Constraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ContainmentConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DanglingConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ParameterConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ReferenceConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.UnaryFormula;

public class VariableInfo {
    private Collection<Variable> mainVariables;
    private Map<Node, Variable> node2variable;
    private Map<Variable, Node> variable2node;
    private Map<Graph, List<Variable>> graph2variables;
    private Map<Variable, Variable> variable2mainVariable;
    private Rule rule;
    private EngineImpl engine;
    private static final Integer ONE = new Integer(1);

    public VariableInfo(RuleInfo ruleInfo, EngineImpl engine) {
        this.rule = ruleInfo.getRule();
        this.engine = engine;
        this.node2variable = new HashMap<Node, Variable>();
        this.variable2node = new HashMap<Variable, Node>();
        this.graph2variables = new HashMap<Graph, List<Variable>>();
        this.variable2mainVariable = new HashMap<Variable, Variable>();
        this.createVariables(this.rule.getLhs(), null);
        for (Node node : this.rule.getLhs().getNodes()) {
            if (this.rule.getMappings().getImage(node, this.rule.getRhs()) != null) continue;
            this.createDanglingConstraints(node);
        }
        this.mainVariables = this.variable2mainVariable.values();
    }

    private void createVariables(Graph g, Collection<Mapping> mappings) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Node node : g.getNodes()) {
            EClass type = node.getType();
            Variable var = new Variable(type);
            variables.add(var);
            this.node2variable.put(node, var);
            this.variable2node.put(var, node);
            Variable mainVariable = var;
            if (mappings != null) {
                for (Mapping mapping : mappings) {
                    if (node != mapping.getImage()) continue;
                    mainVariable = this.variable2mainVariable.get(this.node2variable.get(mapping.getOrigin()));
                }
            }
            this.variable2mainVariable.put(var, mainVariable);
        }
        for (Node node : g.getNodes()) {
            this.createConstraints(node);
        }
        this.graph2variables.put(g, variables);
        this.createVariables(g.getFormula());
    }

    private void createVariables(Formula formula) {
        if (formula instanceof BinaryFormula) {
            this.createVariables(((BinaryFormula)formula).getLeft());
            this.createVariables(((BinaryFormula)formula).getRight());
        } else if (formula instanceof UnaryFormula) {
            this.createVariables(((UnaryFormula)formula).getChild());
        } else if (formula instanceof NestedCondition) {
            NestedCondition nc = (NestedCondition)formula;
            this.createVariables(nc.getConclusion(), (Collection<Mapping>)nc.getMappings());
        }
    }

    private void createConstraints(Node node) {
        Constraint constraint;
        Variable targetVariable;
        Variable var = this.node2variable.get(node);
        for (Edge edge : node.getOutgoing()) {
            targetVariable = this.node2variable.get(edge.getTarget());
            constraint = new ReferenceConstraint(targetVariable, edge.getType());
            var.referenceConstraints.add((ReferenceConstraint)constraint);
        }
        for (Edge edge : node.getIncoming()) {
            if (!edge.getType().isContainment()) continue;
            targetVariable = this.node2variable.get(edge.getSource());
            constraint = new ContainmentConstraint(targetVariable);
            var.containmentConstraints.add((ContainmentConstraint)constraint);
        }
        for (Attribute attribute : node.getAttributes()) {
            String val = attribute.getValue();
            if (this.rule.getParameter(val) != null) {
                constraint = new ParameterConstraint(val, attribute.getType());
                var.parameterConstraints.add((ParameterConstraint)constraint);
                continue;
            }
            Object value = this.engine.evalAttributeExpression(attribute);
            AttributeConstraint constraint2 = new AttributeConstraint(attribute.getType(), value);
            var.attributeConstraints.add(constraint2);
        }
    }

    private void createDanglingConstraints(Node node) {
        Variable var = this.node2variable.get(node);
        DanglingConstraint constraint = new DanglingConstraint(this.getEdgeCounts(node, false), this.getEdgeCounts(node, true));
        var.danglingConstraints.add(constraint);
    }

    private Map<EReference, Integer> getEdgeCounts(Node node, boolean incoming) {
        EList oppositeEdges;
        EList edges = incoming ? node.getIncoming() : node.getOutgoing();
        EList eList = oppositeEdges = incoming ? node.getOutgoing() : node.getIncoming();
        if (edges.size() == 0) {
            return null;
        }
        HashMap<EReference, Integer> edgeCount = new HashMap<EReference, Integer>();
        for (Edge edge : edges) {
            EReference type = edge.getType();
            Integer count = (Integer)edgeCount.get(type);
            count = count == null ? ONE : Integer.valueOf(count + 1);
            edgeCount.put(type, count);
        }
        for (Edge edge : oppositeEdges) {
            Integer count;
            Node remoteNode;
            if (edge.getType().getEOpposite() == null) continue;
            EReference oppType = edge.getType().getEOpposite();
            if (incoming) {
                remoteNode = edge.getTarget();
                if (remoteNode.getOutgoing(oppType, node) != null) continue;
                count = (Integer)edgeCount.get(oppType);
                count = count == null ? ONE : Integer.valueOf(count + 1);
                edgeCount.put(oppType, count);
                continue;
            }
            remoteNode = edge.getSource();
            if (node.getOutgoing(oppType, remoteNode) != null) continue;
            count = (Integer)edgeCount.get(oppType);
            count = count == null ? ONE : Integer.valueOf(count + 1);
            edgeCount.put(oppType, count);
        }
        return edgeCount;
    }

    public Node getVariableForNode(Variable variable) {
        return this.variable2node.get(variable);
    }

    public Collection<Variable> getDependendVariables(Variable mainVariable) {
        HashSet<Variable> dependendVariables = new HashSet<Variable>();
        for (Variable var : this.variable2mainVariable.keySet()) {
            if (this.variable2mainVariable.get(var) != mainVariable) continue;
            dependendVariables.add(var);
        }
        return dependendVariables;
    }

    public Collection<Variable> getMainVariables() {
        return this.mainVariables;
    }

    public Map<Graph, List<Variable>> getGraph2variables() {
        return this.graph2variables;
    }

    public Map<Node, Variable> getNode2variable() {
        return this.node2variable;
    }
}

