/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.henshin.interpreter.ui.InterpreterUIPlugin;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class UnitSelector {
    protected int CONTROL_OFFSET = 5;
    protected Collection<UnitSelectionListener> listeners = new ArrayList<UnitSelectionListener>();
    protected Group container;
    protected Combo unitSelector;
    protected List<Unit> units;

    public UnitSelector(Composite parent) {
        this.container = new Group(parent, 0);
        this.container.setText(InterpreterUIPlugin.LL("_UI_SelectTransformationUnit"));
        this.container.setLayout((Layout)new FormLayout());
        this.unitSelector = new Combo((Composite)this.container, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, this.CONTROL_OFFSET);
        data.left = new FormAttachment(0, this.CONTROL_OFFSET);
        data.right = new FormAttachment(100, -this.CONTROL_OFFSET);
        data.bottom = new FormAttachment(100, -this.CONTROL_OFFSET);
        this.unitSelector.setLayoutData((Object)data);
        this.unitSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (UnitSelectionListener l : UnitSelector.this.listeners) {
                    l.unitSelected(UnitSelector.this.unitSelector.getSelectionIndex());
                }
            }
        });
    }

    public Control getControl() {
        return this.container;
    }

    public void setSelection(int idx) {
        this.unitSelector.select(idx);
    }

    public void setSelectableUnits(String[] units) {
        this.unitSelector.setItems(units);
    }

    public void addUnitSelectionListener(UnitSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void setEnabled(boolean enabled) {
        this.unitSelector.setEnabled(enabled);
    }

    public static interface UnitSelectionListener {
        public boolean unitSelected(int var1);
    }
}

