/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.editor.util.EcoreSelectionDialogUtil;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.impl.ModuleImpl;
import org.eclipse.emf.henshin.model.resource.HenshinResource;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.emf.henshin.presentation.HenshinEditorPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ImportPackagesWizardPage
extends WizardPage {
    private ArrayList<URI> packageURIs = new ArrayList();
    private List listWidget;

    public ImportPackagesWizardPage(String pageId) {
        super(pageId);
        this.setTitle(HenshinEditorPlugin.INSTANCE.getString("_UI_HenshinModelWizard_label"));
        this.setDescription(HenshinEditorPlugin.INSTANCE.getString("_UI_Wizard_import_packages_description"));
    }

    public void createControl(Composite parent) {
        GridData fillBoth = new GridData();
        fillBoth.verticalAlignment = 4;
        fillBoth.grabExcessVerticalSpace = true;
        fillBoth.grabExcessHorizontalSpace = true;
        fillBoth.horizontalAlignment = 4;
        GridData fillHorizontal = new GridData();
        fillHorizontal.verticalAlignment = 1;
        fillHorizontal.grabExcessHorizontalSpace = true;
        fillHorizontal.horizontalAlignment = 4;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)fillBoth);
        this.listWidget = new List(composite, 2054);
        this.listWidget.setLayoutData((Object)fillBoth);
        Composite buttons = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 1;
        buttons.setLayout((Layout)layout2);
        buttons.setLayoutData((Object)fillBoth);
        Button addFromRegistryButton = new Button(buttons, 8);
        addFromRegistryButton.setText("Add From Registry");
        addFromRegistryButton.setLayoutData((Object)fillHorizontal);
        addFromRegistryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportPackagesWizardPage.this.addFromRegistry();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportPackagesWizardPage.this.addFromRegistry();
            }
        });
        Button addFromWorkspaceButton = new Button(buttons, 8);
        addFromWorkspaceButton.setText("Add From Workspace");
        addFromWorkspaceButton.setLayoutData((Object)fillHorizontal);
        addFromWorkspaceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportPackagesWizardPage.this.addFromWorkspace();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportPackagesWizardPage.this.addFromWorkspace();
            }
        });
        Button removeButton = new Button(buttons, 8);
        removeButton.setText("Remove");
        removeButton.setLayoutData((Object)fillHorizontal);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportPackagesWizardPage.this.remove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportPackagesWizardPage.this.remove();
            }
        });
        this.setControl((Control)composite);
    }

    private void addFromRegistry() {
        EPackage ePackage = EcoreSelectionDialogUtil.selectRegisteredPackage(this.listWidget.getShell(), (ResourceSet)new ResourceSetImpl());
        this.add(ePackage);
    }

    private void addFromWorkspace() {
        EPackage ePackage = EcoreSelectionDialogUtil.selectEcoreFilePackage(this.listWidget.getShell(), (ResourceSet)new ResourceSetImpl());
        this.add(ePackage);
    }

    private void add(EPackage ePackage) {
        URI uri;
        if (ePackage != null && !this.packageURIs.contains(uri = EcoreUtil.getURI((EObject)ePackage))) {
            this.packageURIs.add(uri);
            this.listWidget.add(ePackage.getNsURI());
        }
    }

    private void remove() {
        int[] selected = this.listWidget.getSelectionIndices();
        Arrays.sort(selected);
        int i = 0;
        while (i < selected.length) {
            this.listWidget.remove(selected[i]);
            this.packageURIs.remove(selected[i]);
            ++i;
        }
        if (selected.length == 1 && this.listWidget.getItemCount() > 0) {
            this.listWidget.select(Math.min(selected[0], this.listWidget.getItemCount() - 1));
        }
    }

    public ArrayList<URI> getPackageURIs() {
        return this.packageURIs;
    }

    public Module createModule() {
        ModuleImpl module = new ModuleImpl(){

            public NotificationChain eSetResource(Resource.Internal resource, NotificationChain notifications) {
                ImportPackagesWizardPage.this.doImportPackages((Module)this, (Resource)resource);
                return super.eSetResource(resource, notifications);
            }
        };
        return module;
    }

    private void doImportPackages(Module module, Resource resource) {
        ResourceSet resourceSet;
        if (resource == null) {
            resource = new HenshinResource();
        }
        if ((resourceSet = resource.getResourceSet()) == null) {
            resourceSet = new HenshinResourceSet();
        }
        for (URI uri : this.packageURIs) {
            EObject object = resourceSet.getEObject(uri, true);
            if (!(object instanceof EPackage)) continue;
            module.getImports().add((Object)((EPackage)object));
        }
    }
}

