/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.menuContributors;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.editor.commands.DiscardInFavorOfChildFormulaCommand;
import org.eclipse.emf.henshin.editor.commands.MenuContributor;
import org.eclipse.emf.henshin.editor.commands.NegateFormulaCommand;
import org.eclipse.emf.henshin.editor.commands.ToggleJunctionCommand;
import org.eclipse.emf.henshin.editor.commands.WrapFormulaInJunctionCommand;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class FormulaCommandMenuContributor
extends MenuContributor {
    public static MenuContributor INSTANCE = new FormulaCommandMenuContributor();
    private static final String COMMAND_LABEL_DISCARD = "DiscardInFavorOfChild";
    private static final String COMMAND_LABEL_DISCARD_LEFT = "DiscardInFavorOfChild_Left";
    private static final String COMMAND_LABEL_DISCARD_RIGHT = "DiscardInFavorOfChild_Right";
    private static final String COMMAND_LABEL_NEGATE_FORMULA = "NegateFormula";
    private static final String COMMAND_LABEL_TOGGLE_JUNCTION = "ToggleJunction";
    private static final String COMMAND_LABEL_WIJ = "WrapInJunction";
    private static final String COMMAND_LABEL_WIJ_AND = "WrapInJunction_And";
    private static final String COMMAND_LABEL_WIJ_OR = "WrapInJunction_Or";

    @Override
    protected void contributeActions(IMenuManager menuManager, List<?> selection) {
        this.buildNegateFormula(menuManager, selection, this.domain);
        this.buildToggleJunction(menuManager, selection, this.domain);
        this.buildWrapInJunction(menuManager, selection);
        this.buildDiscardInFavorOfChild(menuManager, selection);
    }

    private void buildDiscardInFavorOfChild(IMenuManager menuManager, List<?> selection) {
        if (selection.size() == 1 && selection.get(0) instanceof BinaryFormula) {
            MenuManager subMenu = new MenuManager(this.getLabel(COMMAND_LABEL_DISCARD));
            subMenu.add(this.createAction(this.getLabel(COMMAND_LABEL_DISCARD_LEFT), (Command)new DiscardInFavorOfChildFormulaCommand.Left((BinaryFormula)selection.get(0))));
            subMenu.add(this.createAction(this.getLabel(COMMAND_LABEL_DISCARD_RIGHT), (Command)new DiscardInFavorOfChildFormulaCommand.Right((BinaryFormula)selection.get(0))));
            menuManager.add((IContributionItem)subMenu);
        }
    }

    private void buildNegateFormula(IMenuManager menuManager, List<?> selection, EditingDomain domain) {
        if (selection.size() == 1 && selection.get(0) instanceof Formula) {
            menuManager.add(this.createAction(this.getLabel(COMMAND_LABEL_NEGATE_FORMULA), (Command)new NegateFormulaCommand(domain, (Formula)selection.get(0))));
        }
    }

    private void buildToggleJunction(IMenuManager menuManager, List<?> selection, EditingDomain domain) {
        if (selection.size() == 1 && selection.get(0) instanceof BinaryFormula) {
            menuManager.add(this.createAction(this.getLabel(COMMAND_LABEL_TOGGLE_JUNCTION), (Command)new ToggleJunctionCommand((BinaryFormula)selection.get(0))));
        }
    }

    private void buildWrapInJunction(IMenuManager menuManager, List<?> selection) {
        if (selection.size() == 1 && selection.get(0) instanceof Formula) {
            MenuManager subMenu = new MenuManager(this.getLabel(COMMAND_LABEL_WIJ));
            subMenu.add(this.createAction(this.getLabel(COMMAND_LABEL_WIJ_AND), (Command)WrapFormulaInJunctionCommand.createWrapInAndCommand((Formula)selection.get(0))));
            subMenu.add(this.createAction(this.getLabel(COMMAND_LABEL_WIJ_OR), (Command)WrapFormulaInJunctionCommand.createWrapInOrCommand((Formula)selection.get(0))));
            menuManager.add((IContributionItem)subMenu);
        }
    }
}

