/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.mutualexclusion;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class LTSBenchmark {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/mutualexclusion";
    static final int GRAPH_SIZE_MIN = 20;
    static final int GRAPH_SIZE_MAX = 20;
    static final int STEP = 1;
    static final int ITERATIONS = 4;
    static final int ROUNDS = 10000;

    public static void run(String path) {
        System.out.println("***************** Long Transformation Sequence ****************");
        System.out.println("Memory allocated:" + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "M");
        System.out.println("GRAPH_SIZE_MIN:20");
        System.out.println("GRAPH_SIZE_MAX:20");
        System.out.println("Rounds: 10000");
        System.out.println("STEP:1");
        System.out.println("ITERATIONS:4 , first iteration is not included into evaluation");
        System.out.println("***************************************************************");
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("mutualexclusion.henshin", false);
        EObject container = resourceSet.getEObject("initialgraph.xmi");
        Rule newRule = (Rule)module.getUnit("newRule");
        Rule mountAllRule = (Rule)module.getUnit("mountAllRule");
        Unit ltsUnit = module.getUnit("lts2");
        Unit loopStsUnit = module.getUnit("loopLts");
        Unit finalStsUnit = module.getUnit("finalLts");
        int graphSize = 20;
        while (graphSize <= 20) {
            long sum = 0L;
            int j = 0;
            while (j < 4) {
                EObject container2 = EcoreUtil.copy((EObject)container);
                EGraphImpl graph = new EGraphImpl(container2);
                EngineImpl engine = new EngineImpl();
                RuleApplicationImpl ruleAppl = new RuleApplicationImpl((Engine)engine);
                ruleAppl.setEGraph((EGraph)graph);
                UnitApplicationImpl unitAppl = new UnitApplicationImpl((Engine)engine);
                unitAppl.setEGraph((EGraph)graph);
                long startTime = System.currentTimeMillis();
                ruleAppl.setRule(newRule);
                int i = 0;
                while (i < graphSize - 2) {
                    ruleAppl.execute(null);
                    ++i;
                }
                ruleAppl.setRule(mountAllRule);
                ruleAppl.execute(null);
                int k = 0;
                while (k < 10000) {
                    unitAppl.setUnit(ltsUnit);
                    unitAppl.execute(null);
                    int i2 = 0;
                    while (i2 < graphSize - 1) {
                        unitAppl.setUnit(loopStsUnit);
                        unitAppl.execute(null);
                        ++i2;
                    }
                    unitAppl.setUnit(finalStsUnit);
                    unitAppl.execute(null);
                    ++k;
                }
                long finishTime = System.currentTimeMillis();
                System.out.println("Time: " + (finishTime - startTime));
                if (j != 0) {
                    sum = sum + finishTime - startTime;
                }
                ++j;
            }
            System.out.println(" Graph size: " + graphSize + "  average time:" + sum / 3L);
            ++graphSize;
        }
    }

    public static void main(String[] args) {
        LTSBenchmark.run(PATH);
    }
}

