/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.giraph;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.henshin.interpreter.giraph.GiraphRuleTemplate;
import org.eclipse.emf.henshin.interpreter.giraph.GiraphUtil;
import org.eclipse.emf.henshin.interpreter.giraph.HenshinUtilTemplate;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class GenerateGiraphCodeWizard
extends Wizard {
    private Unit mainUnit;
    private GiraphPage page;
    private IContainer targetContainer;

    public GenerateGiraphCodeWizard(Unit unit, IContainer targetContainer) {
        this.mainUnit = unit;
        this.targetContainer = targetContainer;
        this.setWindowTitle("Giraph Code Generator");
    }

    public void addPages() {
        this.page = new GiraphPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            Collection rules;
            String className = this.page.classNameText.getText();
            String packageName = this.page.packageNameText.getText();
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("ruleData", GiraphUtil.generateRuleData((Unit)this.mainUnit));
            args.put("mainUnit", this.mainUnit);
            args.put("className", className);
            args.put("packageName", packageName);
            args.put("masterLogging", new Boolean(this.page.masterLoggingCheckBox.getSelection()));
            args.put("vertexLogging", new Boolean(this.page.vertexLoggingCheckBox.getSelection()));
            args.put("useUUIDs", new Boolean(this.page.uuidsCheckBox.getSelection()));
            args.put("segmentCount", 1);
            GiraphRuleTemplate template = new GiraphRuleTemplate();
            String giraphCode = template.generate(args);
            IFile javaRuleFile = this.targetContainer.getFile((IPath)new Path(String.valueOf(className) + ".java"));
            if (javaRuleFile.exists()) {
                javaRuleFile.setContents((InputStream)new ByteArrayInputStream(giraphCode.getBytes()), 1, null);
            } else {
                javaRuleFile.create((InputStream)new ByteArrayInputStream(giraphCode.getBytes()), 1, null);
            }
            String dataCode = new HenshinUtilTemplate().generate(args);
            IFile javaDataFile = this.targetContainer.getFile((IPath)new Path("HenshinUtil.java"));
            if (javaDataFile.exists()) {
                javaDataFile.setContents((InputStream)new ByteArrayInputStream(dataCode.getBytes()), 1, null);
            } else {
                javaDataFile.create((InputStream)new ByteArrayInputStream(dataCode.getBytes()), 1, null);
            }
            if (this.page.jsonCheckBox.getSelection() && !(rules = GiraphUtil.collectRules((Unit)this.mainUnit)).isEmpty()) {
                String instanceCode = GiraphUtil.getInstanceCode((Rule)((Rule)rules.iterator().next()));
                IFile jsonFile = this.targetContainer.getFile((IPath)new Path(String.valueOf(className) + ".json"));
                if (jsonFile.exists()) {
                    jsonFile.setContents((InputStream)new ByteArrayInputStream(instanceCode.getBytes()), 1, null);
                } else {
                    jsonFile.create((InputStream)new ByteArrayInputStream(instanceCode.getBytes()), 1, null);
                }
            }
            this.targetContainer.refreshLocal(2, null);
            IWorkbench wb = PlatformUI.getWorkbench();
            IEditorDescriptor desc = wb.getEditorRegistry().getDefaultEditor(javaRuleFile.getName());
            wb.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(javaRuleFile), desc.getId());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Error generating Giraph code: " + e.getMessage()));
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private class GiraphPage
    extends WizardPage {
        Text packageNameText;
        Text classNameText;
        Button masterLoggingCheckBox;
        Button vertexLoggingCheckBox;
        Button uuidsCheckBox;
        Button jsonCheckBox;

        public GiraphPage() {
            super("Giraph");
            this.setTitle("Giraph Code Generator");
            this.setDescription("Enter the details for the Giraph code generation.");
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 4);
            comp.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(comp, 0);
            label.setText("Package name:");
            label.setLayoutData((Object)new GridData(128));
            this.packageNameText = new Text(comp, 2048);
            this.packageNameText.setLayoutData((Object)new GridData(768));
            this.packageNameText.setText("org.apache.giraph.examples");
            label = new Label(comp, 0);
            label.setText("Compute class name:");
            label.setLayoutData((Object)new GridData(128));
            this.classNameText = new Text(comp, 2048);
            this.classNameText.setLayoutData((Object)new GridData(768));
            String className = GenerateGiraphCodeWizard.this.mainUnit.getName();
            className = String.valueOf(className.substring(0, 1).toUpperCase()) + className.substring(1);
            this.classNameText.setText(className);
            label = new Label(comp, 0);
            label.setText("Master logging:");
            label.setLayoutData((Object)new GridData(128));
            this.masterLoggingCheckBox = new Button(comp, 32);
            this.masterLoggingCheckBox.setSelection(true);
            label = new Label(comp, 0);
            label.setText("Vertex logging:");
            label.setLayoutData((Object)new GridData(128));
            this.vertexLoggingCheckBox = new Button(comp, 32);
            label = new Label(comp, 0);
            label.setText("Use Java UUIDs:");
            label.setLayoutData((Object)new GridData(128));
            this.uuidsCheckBox = new Button(comp, 32);
            this.uuidsCheckBox.setSelection(true);
            label = new Label(comp, 0);
            label.setText("Example JSON:");
            label.setLayoutData((Object)new GridData(128));
            this.jsonCheckBox = new Button(comp, 32);
            this.setControl((Control)comp);
        }
    }
}

