/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ConditionHandler;
import org.eclipse.emf.henshin.interpreter.matching.conditions.IFormula;
import org.eclipse.emf.henshin.interpreter.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ReferenceConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.SolutionFinder;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;

public class EGraphIsomorphyChecker {
    private static final ConditionHandler ATTRIBUTE_CONDITION_HANDLER;
    private final EGraph source;
    private int linkCount;
    private final List<EAttribute> ignoredAttributes;
    private Map<EObject, Variable> variablesMap;
    private List<Variable> variablesList;

    static {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
        ATTRIBUTE_CONDITION_HANDLER = new ConditionHandler(new HashMap<String, Collection<String>>(), engine);
    }

    public EGraphIsomorphyChecker(EGraph source, List<EAttribute> ignoredAttributes) {
        this.source = source;
        this.ignoredAttributes = ignoredAttributes;
        this.linkCount = InterpreterUtil.countEdges(source);
        this.initVariables();
    }

    private void initVariables() {
        int objectCount = this.source.size();
        this.variablesMap = new HashMap<EObject, Variable>(objectCount);
        this.variablesList = new ArrayList<Variable>(objectCount);
        for (EObject eObject : this.source) {
            Variable variable = new Variable(eObject.eClass(), true);
            this.variablesMap.put(eObject, variable);
            this.variablesList.add(variable);
        }
        for (Map.Entry entry : this.variablesMap.entrySet()) {
            EObject object = (EObject)entry.getKey();
            Variable variable = (Variable)entry.getValue();
            for (EAttribute attr : object.eClass().getEAllAttributes()) {
                if (this.ignoredAttributes != null && this.ignoredAttributes.contains(attr)) continue;
                variable.attributeConstraints.add(new AttributeConstraint(attr, object.eGet((EStructuralFeature)attr), true));
            }
            for (EReference ref : object.eClass().getEAllReferences()) {
                if (ref.isMany()) {
                    EList targets = (EList)object.eGet((EStructuralFeature)ref);
                    for (EObject target : targets) {
                        variable.referenceConstraints.add(new ReferenceConstraint(this.variablesMap.get(target), ref));
                    }
                    continue;
                }
                EObject target = (EObject)object.eGet((EStructuralFeature)ref);
                if (target == null) continue;
                variable.referenceConstraints.add(new ReferenceConstraint(this.variablesMap.get(target), ref));
            }
        }
    }

    public boolean isIsomorphicTo(EGraph graph, Map<EObject, EObject> partialMatch) {
        if (this.source.size() != graph.size()) {
            return false;
        }
        HashMap<Variable, DomainSlot> domainMap = new HashMap<Variable, DomainSlot>();
        for (Map.Entry<EObject, Variable> entry : this.variablesMap.entrySet()) {
            EObject match;
            DomainSlot domainSlot = new DomainSlot(ATTRIBUTE_CONDITION_HANDLER, new HashSet<EObject>(), true, false, true, true);
            if (partialMatch != null && (match = partialMatch.get(entry.getKey())) != null) {
                domainSlot.fixInstantiation(match);
            }
            domainMap.put(entry.getValue(), domainSlot);
        }
        SolutionFinder matchFinder = new SolutionFinder(graph, domainMap, ATTRIBUTE_CONDITION_HANDLER);
        matchFinder.variables = this.variablesList;
        matchFinder.formula = IFormula.TRUE;
        if (!matchFinder.findSolution()) {
            return false;
        }
        return this.linkCount == InterpreterUtil.countEdges(graph);
    }
}

