/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.giraph.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.henshin.giraph.GiraphRuleData;
import org.eclipse.emf.henshin.giraph.GiraphUtil;
import org.eclipse.emf.henshin.interpreter.info.RuleChangeInfo;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.staticanalysis.NodeEquivalence;

public class GiraphRuleTemplate {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import java.io.IOException;" + this.NL + "import java.util.ArrayDeque;" + this.NL + "import java.util.ArrayList;";
    protected final String TEXT_3 = String.valueOf(this.NL) + "import java.util.Collections;";
    protected final String TEXT_4 = String.valueOf(this.NL) + "import java.util.Deque;" + this.NL + "import java.util.HashSet;" + this.NL + "import java.util.List;" + this.NL + "import java.util.Set;" + this.NL + this.NL + "import org.apache.giraph.aggregators.LongSumAggregator;" + this.NL + "import org.apache.giraph.edge.Edge;";
    protected final String TEXT_5 = String.valueOf(this.NL) + "import org.apache.giraph.edge.EdgeFactory;";
    protected final String TEXT_6 = String.valueOf(this.NL) + "import org.apache.giraph.examples.Algorithm;" + this.NL + "import org.apache.giraph.graph.BasicComputation;" + this.NL + "import org.apache.giraph.graph.Vertex;" + this.NL + "import org.apache.giraph.master.DefaultMasterCompute;" + this.NL + "import org.apache.hadoop.io.ByteWritable;" + this.NL + "import org.apache.hadoop.io.LongWritable;";
    protected final String TEXT_7 = String.valueOf(this.NL) + "import org.apache.log4j.Logger;";
    protected final String TEXT_8 = String.valueOf(this.NL) + "import static ";
    protected final String TEXT_9 = ".HenshinUtil.ApplicationStack;" + this.NL + "import static ";
    protected final String TEXT_10 = ".HenshinUtil.ApplicationStackAggregator;" + this.NL + "import static ";
    protected final String TEXT_11 = ".HenshinUtil.Match;" + this.NL + "import static ";
    protected final String TEXT_12 = ".HenshinUtil.VertexId;" + this.NL + this.NL + "/**" + this.NL + " * Generated implementation of the Henshin unit \"";
    protected final String TEXT_13 = "\"." + this.NL + " */" + this.NL + "@Algorithm(name = \"";
    protected final String TEXT_14 = "\")" + this.NL + "public class ";
    protected final String TEXT_15 = " extends BasicComputation<VertexId, ByteWritable, ByteWritable, Match> {" + this.NL + this.NL + "\t/**" + this.NL + "\t * Name of the match count aggregator." + this.NL + "\t */" + this.NL + "\tpublic static final String AGGREGATOR_MATCHES = \"matches\";" + this.NL + this.NL + "\t/**" + this.NL + "\t * Name of the rule application count aggregator." + this.NL + "\t */" + this.NL + "\tpublic static final String AGGREGATOR_RULE_APPLICATIONS = \"ruleApps\";" + this.NL + this.NL + "\t/**" + this.NL + "\t * Name of the node generation aggregator." + this.NL + "\t */" + this.NL + "\tpublic static final String AGGREGATOR_NODE_GENERATION = \"nodeGen\";" + this.NL + this.NL + "\t/**" + this.NL + "\t * Name of the application stack aggregator." + this.NL + "\t */" + this.NL + "\tpublic static final String AGGREGATOR_APPLICATION_STACK = \"appStack\";";
    protected final String TEXT_16 = String.valueOf(this.NL) + this.NL + "\t/**" + this.NL + "\t * Type constant for \"";
    protected final String TEXT_17 = "\"." + this.NL + "\t */" + this.NL + "\tpublic static final byte ";
    protected final String TEXT_18 = " = ";
    protected final String TEXT_19 = ";";
    protected final String TEXT_20 = String.valueOf(this.NL) + this.NL + "\t/**" + this.NL + "\t * ";
    protected final String TEXT_21 = " constant for \"";
    protected final String TEXT_22 = "\"." + this.NL + "\t */" + this.NL + "\tpublic static final int ";
    protected final String TEXT_23 = " = ";
    protected final String TEXT_24 = ";";
    protected final String TEXT_25 = String.valueOf(this.NL) + this.NL + "\t/**" + this.NL + "\t * Logging support." + this.NL + "\t */" + this.NL + "\tprotected static final Logger LOG = Logger.getLogger(";
    protected final String TEXT_26 = ".class);";
    protected final String TEXT_27 = String.valueOf(this.NL) + this.NL + "\t/**" + this.NL + "\t * Default segment count." + this.NL + "\t */" + this.NL + "\tprivate static int SEGMENT_COUNT = ";
    protected final String TEXT_28 = ";" + this.NL + this.NL + "\t/**" + this.NL + "\t * Currently active rule." + this.NL + "\t */" + this.NL + "\tprivate int rule;" + this.NL + this.NL + "\t/**" + this.NL + "\t * Current segment." + this.NL + "\t */" + this.NL + "\tprivate int segment;" + this.NL + this.NL + "\t/**" + this.NL + "\t * Current microstep." + this.NL + "\t */" + this.NL + "\tprivate int microstep;" + this.NL + this.NL + "\t/**" + this.NL + "\t * Finished flag." + this.NL + "\t */" + this.NL + "\tprivate boolean finished;" + this.NL + this.NL + "\t/*" + this.NL + "\t * (non-Javadoc)" + this.NL + "\t * @see org.apache.giraph.graph.Computation#preSuperstep()" + this.NL + "\t */" + this.NL + "\t@Override" + this.NL + "\tpublic void preSuperstep() {" + this.NL + "\t\tApplicationStack stack = getAggregatedValue(AGGREGATOR_APPLICATION_STACK);" + this.NL + "\t\tif (stack.getStackSize() == 0) {" + this.NL + "\t\t\tlong ruleApps = ((LongWritable) getAggregatedValue(AGGREGATOR_RULE_APPLICATIONS)).get();" + this.NL + "\t\t\tfinished = ruleApps == 0;" + this.NL + "\t\t\trule = -1;" + this.NL + "\t\t} else {" + this.NL + "\t\t\tfinished = false;" + this.NL + "\t\t\trule = stack.getLastUnit();" + this.NL + "\t\t\tsegment = stack.getLastSegment();" + this.NL + "\t\t\tmicrostep = stack.getLastMicrostep();" + this.NL + "\t\t}" + this.NL + "\t}" + this.NL + this.NL + "\t/*" + this.NL + "\t * (non-Javadoc)" + this.NL + "\t * @see org.apache.giraph.graph.Computation#compute(org.apache.giraph.graph.Vertex, java.lang.Iterable)" + this.NL + "\t */" + this.NL + "\t@Override" + this.NL + "\tpublic void compute(Vertex<VertexId, ByteWritable, ByteWritable> vertex, Iterable<Match> matches) throws IOException {" + this.NL + "\t\tif (finished) {" + this.NL + "\t\t\tvertex.voteToHalt();" + this.NL + "\t\t\treturn;" + this.NL + "\t\t}" + this.NL + "\t\tswitch (rule) {";
    protected final String TEXT_29 = String.valueOf(this.NL) + "\t\tcase ";
    protected final String TEXT_30 = ":" + this.NL + "\t\t\tmatch";
    protected final String TEXT_31 = "(vertex, matches, segment, microstep);" + this.NL + "\t\t\tbreak;";
    protected final String TEXT_32 = String.valueOf(this.NL) + "\t\tdefault:" + this.NL + "\t\t\tbreak;" + this.NL + "\t\t}" + this.NL + "\t}";
    protected final String TEXT_33 = String.valueOf(this.NL) + this.NL + "\t/**" + this.NL + "\t * Match (and apply) the rule \"";
    protected final String TEXT_34 = "\"." + this.NL + "\t * This takes ";
    protected final String TEXT_35 = " microsteps." + this.NL + "\t * @param vertex The current vertex." + this.NL + "\t * @param matches The current matches." + this.NL + "\t * @param segment The current segment." + this.NL + "\t * @param microstep The current microstep." + this.NL + "\t */" + this.NL + "\tprotected void match";
    protected final String TEXT_36 = "(Vertex<VertexId, ByteWritable, ByteWritable> vertex," + this.NL + "\t\tIterable<Match> matches, int segment, int microstep) throws IOException {" + this.NL;
    protected final String TEXT_37 = String.valueOf(this.NL) + "\t\tLOG.info(\"Vertex \" + vertex.getId() + \" in superstep \" + getSuperstep() +" + this.NL + "\t\t\t\" matching rule ";
    protected final String TEXT_38 = " on segment \" + segment +" + this.NL + "\t\t\t\" in microstep \" + microstep);" + this.NL + "\t\tfor (Match match : matches) {" + this.NL + "\t\t\tLOG.info(\"Vertex \" + vertex.getId() +" + this.NL + "\t\t\t\t\" in superstep \" + getSuperstep() +" + this.NL + "\t\t\t\t\" received (partial) match \" + match);" + this.NL + "\t\t}";
    protected final String TEXT_39 = String.valueOf(this.NL) + "\t\tSet<Match> finalMatches = new HashSet<Match>();" + this.NL + "\t\t";
    protected final String TEXT_40 = "filter";
    protected final String TEXT_41 = "(vertex, matches, segment, microstep, finalMatches);" + this.NL + "\t\tlong matchCount = 0;" + this.NL + "\t\tlong appCount = 0;" + this.NL;
    protected final String TEXT_42 = " if (microstep == ";
    protected final String TEXT_43 = ") {";
    protected final String TEXT_44 = String.valueOf(this.NL) + "\t\t\t// Joining matches at node ";
    protected final String TEXT_45 = ":" + this.NL + "\t\t\tList<Match> matches1 = new ArrayList<Match>();" + this.NL + "\t\t\tList<Match> matches2 = new ArrayList<Match>();" + this.NL + "\t\t\tVertexId id = vertex.getId();" + this.NL + "\t\t\tfor (Match match : matches) {" + this.NL + "\t\t\t\tif (id.equals(match.getVertexId(";
    protected final String TEXT_46 = "))) {" + this.NL + "\t\t\t\t\tmatches1.add(match.copy());" + this.NL + "\t\t\t\t} else {" + this.NL + "\t\t\t\t\tmatches2.add(match.copy());" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}";
    protected final String TEXT_47 = String.valueOf(this.NL) + "\t\t\tLOG.info(\"Vertex \" + id + \" in superstep \" + getSuperstep() +" + this.NL + "\t\t\t\t\" joining \" + matches1.size() + \" x \" + matches2.size() +" + this.NL + "\t\t\t\t\" partial matches of rule ";
    protected final String TEXT_48 = "\");";
    protected final String TEXT_49 = String.valueOf(this.NL) + "\t\t\tfor (Match m1 : matches1) {" + this.NL + "\t\t\t\tfor (Match m2 : matches2) {" + this.NL + "\t\t\t\t\tMatch match = m1.append(m2);";
    protected final String TEXT_50 = String.valueOf(this.NL) + "\t\t\t\t\tif (!match.isInjective()) {" + this.NL + "\t\t\t\t\t\tcontinue;" + this.NL + "\t\t\t\t\t}";
    protected final String TEXT_51 = String.valueOf(this.NL) + "\t\t\t\t\tmatchCount++;";
    protected final String TEXT_52 = String.valueOf(this.NL) + "\t\t\t\t\tLOG.info(\"Vertex \" + vertex.getId() +" + this.NL + "\t\t\t\t\t\t\" sending (partial) match \" + match +" + this.NL + "\t\t\t\t\t\t\" back to vertex \" + match.getVertexId(";
    protected final String TEXT_53 = "));";
    protected final String TEXT_54 = String.valueOf(this.NL) + "\t\t\t\t\tsendMessage(match.getVertexId(";
    protected final String TEXT_55 = "), match);";
    protected final String TEXT_56 = String.valueOf(this.NL) + "\t\t\t\t\tmatch = match.remove(";
    protected final String TEXT_57 = ");" + this.NL + "\t\t ";
    protected final String TEXT_58 = String.valueOf(this.NL) + "\t\t\t\t\tif (!finalMatches.add(match)) {" + this.NL + "\t\t\t\t\t\tcontinue;" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t\tmatchCount++;" + this.NL + "\t\t\t\t\tif (segment == SEGMENT_COUNT - 1) {" + this.NL + "\t\t\t\t\t\tapply";
    protected final String TEXT_59 = "(vertex, match, appCount++);" + this.NL + "\t\t\t\t\t} else {" + this.NL + "\t\t\t\t\t\tsendMessage(vertex.getId(), match);" + this.NL + "\t\t\t\t\t}";
    protected final String TEXT_60 = String.valueOf(this.NL) + "\t\t\t\t}" + this.NL + "\t\t\t}";
    protected final String TEXT_61 = String.valueOf(this.NL) + "\t\t\t// Matching node ";
    protected final String TEXT_62 = ":";
    protected final String TEXT_63 = String.valueOf(this.NL) + "\t\t\t";
    protected final String TEXT_64 = "vertex.getValue().get() == ";
    protected final String TEXT_65 = String.valueOf(this.NL) + "\t\t\tok = ok && vertex.getNumEdges() >= ";
    protected final String TEXT_66 = ";";
    protected final String TEXT_67 = String.valueOf(this.NL) + "\t\t\tok = ok && (SEGMENT_COUNT == 1 || getSegment(vertex.getId()) == segment);";
    protected final String TEXT_68 = String.valueOf(this.NL) + "\t\t\tif (ok) {";
    protected final String TEXT_69 = String.valueOf(this.NL) + "\t\t\t\tMatch match = new Match(segment).append(vertex.getId());";
    protected final String TEXT_70 = this.NL;
    protected final String TEXT_71 = "\t\t\tfor (Match match : matches) {";
    protected final String TEXT_72 = this.NL;
    protected final String TEXT_73 = "\t\t\t\tmatch = match.append(vertex.getId());";
    protected final String TEXT_74 = this.NL;
    protected final String TEXT_75 = "\t\t\t\tif (!match.isInjective()) {";
    protected final String TEXT_76 = this.NL;
    protected final String TEXT_77 = "\t\t\t\t\tcontinue;";
    protected final String TEXT_78 = this.NL;
    protected final String TEXT_79 = "\t\t\t\t}";
    protected final String TEXT_80 = this.NL;
    protected final String TEXT_81 = "\t\t\t\tif (vertex.getId().compareTo(match.getVertexId(";
    protected final String TEXT_82 = ")) < 0) {";
    protected final String TEXT_83 = this.NL;
    protected final String TEXT_84 = "\t\t\t\t\tcontinue;";
    protected final String TEXT_85 = this.NL;
    protected final String TEXT_86 = "\t\t\t\t}";
    protected final String TEXT_87 = this.NL;
    protected final String TEXT_88 = "\t\t// Node ";
    protected final String TEXT_89 = ": check for edge to match of ";
    protected final String TEXT_90 = " of type \"";
    protected final String TEXT_91 = "\":";
    protected final String TEXT_92 = this.NL;
    protected final String TEXT_93 = "\t\tVertexId targetId = match.getVertexId(";
    protected final String TEXT_94 = ");";
    protected final String TEXT_95 = this.NL;
    protected final String TEXT_96 = "\t\tfor (Edge<VertexId, ByteWritable> edge :";
    protected final String TEXT_97 = this.NL;
    protected final String TEXT_98 = "\t\t\tvertex.getEdges()) {";
    protected final String TEXT_99 = this.NL;
    protected final String TEXT_100 = "\t\t\tif (edge.getValue().get() ==";
    protected final String TEXT_101 = this.NL;
    protected final String TEXT_102 = "\t\t\t\t";
    protected final String TEXT_103 = " &&";
    protected final String TEXT_104 = this.NL;
    protected final String TEXT_105 = "\t\t\t\tedge.getTargetVertexId().equals(targetId)) {";
    protected final String TEXT_106 = this.NL;
    protected final String TEXT_107 = "\t\t\t\tmatchCount++;";
    protected final String TEXT_108 = this.NL;
    protected final String TEXT_109 = "\t\t\t\tLOG.info(\"Vertex \" + vertex.getId() +";
    protected final String TEXT_110 = this.NL;
    protected final String TEXT_111 = "\t\t\t\t\t\" sending (partial) match \" + match +";
    protected final String TEXT_112 = this.NL;
    protected final String TEXT_113 = "\t\t\t\t\t\" back to vertex \" + match.getVertexId(";
    protected final String TEXT_114 = "));";
    protected final String TEXT_115 = this.NL;
    protected final String TEXT_116 = "\t\t\t\tsendMessage(match.getVertexId(";
    protected final String TEXT_117 = "), match);";
    protected final String TEXT_118 = this.NL;
    protected final String TEXT_119 = "\t\t\t\tmatch = match.remove(";
    protected final String TEXT_120 = ");";
    protected final String TEXT_121 = this.NL;
    protected final String TEXT_122 = "\t\t\t\tif (finalMatches.add(match)) {";
    protected final String TEXT_123 = this.NL;
    protected final String TEXT_124 = "\t\t\t\t\tmatchCount++;";
    protected final String TEXT_125 = this.NL;
    protected final String TEXT_126 = "\t\t\t\t\tif (segment == SEGMENT_COUNT - 1) {";
    protected final String TEXT_127 = this.NL;
    protected final String TEXT_128 = "\t\t\t\t\t\tapply";
    protected final String TEXT_129 = "(";
    protected final String TEXT_130 = this.NL;
    protected final String TEXT_131 = "\t\t\t\t\t\t\tvertex, match, appCount++);";
    protected final String TEXT_132 = this.NL;
    protected final String TEXT_133 = "\t\t\t\t\t} else {";
    protected final String TEXT_134 = this.NL;
    protected final String TEXT_135 = "\t\t\t\t\t\tsendMessage(vertex.getId(), match);";
    protected final String TEXT_136 = this.NL;
    protected final String TEXT_137 = "\t\t\t\t\t}";
    protected final String TEXT_138 = this.NL;
    protected final String TEXT_139 = "\t\t\t\t}";
    protected final String TEXT_140 = this.NL;
    protected final String TEXT_141 = "\t\t\t\tbreak;";
    protected final String TEXT_142 = this.NL;
    protected final String TEXT_143 = "\t\t\t}";
    protected final String TEXT_144 = this.NL;
    protected final String TEXT_145 = "\t\t}";
    protected final String TEXT_146 = this.NL;
    protected final String TEXT_147 = "\t\t\t\tmatchCount++;";
    protected final String TEXT_148 = this.NL;
    protected final String TEXT_149 = "\t\t\t\tSet<VertexId> targets = new HashSet<VertexId>();";
    protected final String TEXT_150 = this.NL;
    protected final String TEXT_151 = "\t\t\t\tfor (Edge<VertexId, ByteWritable> edge : vertex.getEdges()) {";
    protected final String TEXT_152 = this.NL;
    protected final String TEXT_153 = "\t\t\t\t\tif (edge.getValue().get() ==";
    protected final String TEXT_154 = this.NL;
    protected final String TEXT_155 = "\t\t\t\t\t\t";
    protected final String TEXT_156 = " &&";
    protected final String TEXT_157 = this.NL;
    protected final String TEXT_158 = "\t\t\t\t\t\ttargets.add(edge.getTargetVertexId())) {";
    protected final String TEXT_159 = this.NL;
    protected final String TEXT_160 = "\t\t\t\t\t\tLOG.info(\"Vertex \" + vertex.getId() +";
    protected final String TEXT_161 = this.NL;
    protected final String TEXT_162 = "\t\t\t\t\t\t\t\" sending (partial) match \" + match +";
    protected final String TEXT_163 = this.NL;
    protected final String TEXT_164 = "\t\t\t\t\t\t\t\" forward to vertex \" + edge.getTargetVertexId());";
    protected final String TEXT_165 = this.NL;
    protected final String TEXT_166 = "\t\t\t\t\t\tsendMessage(edge.getTargetVertexId(), match);";
    protected final String TEXT_167 = this.NL;
    protected final String TEXT_168 = "\t\t\t\t\t}";
    protected final String TEXT_169 = this.NL;
    protected final String TEXT_170 = "\t\t\t\t}";
    protected final String TEXT_171 = this.NL;
    protected final String TEXT_172 = "\t\t\t}";
    protected final String TEXT_173 = String.valueOf(this.NL) + "\t\t\t}";
    protected final String TEXT_174 = String.valueOf(this.NL) + "\t\t\tfor (Match match : matches) {" + this.NL + "\t\t\t\tVertexId id = match.getVertexId(";
    protected final String TEXT_175 = ");" + this.NL + "\t\t\t\tif (vertex.getId().equals(id)) {" + this.NL + "\t\t\t\t\tmatchCount++;";
    protected final String TEXT_176 = String.valueOf(this.NL) + "\t\t\t\t\tLOG.info(\"Vertex \" + id + \" in superstep \" + getSuperstep() +" + this.NL + "\t\t\t\t\t\t\" sending (partial) match \" + match + \" to myself\");";
    protected final String TEXT_177 = String.valueOf(this.NL) + "\t\t\t\t\tsendMessage(id, match);" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}";
    protected final String TEXT_178 = String.valueOf(this.NL) + "\t\t}";
    protected final String TEXT_179 = " else {" + this.NL + "\t\t\tthrow new RuntimeException(\"Illegal microstep for rule \" +" + this.NL + "\t\t\t\t\"";
    protected final String TEXT_180 = ": \" + microstep);" + this.NL + "\t\t}" + this.NL + "\t\tif (matchCount > 0) {" + this.NL + "\t\t\taggregate(AGGREGATOR_MATCHES," + this.NL + "\t\t\t\tnew LongWritable(matchCount));" + this.NL + "\t\t}" + this.NL + "\t\tif (appCount > 0) {" + this.NL + "\t\t\taggregate(AGGREGATOR_RULE_APPLICATIONS," + this.NL + "\t\t\t\tnew LongWritable(appCount));" + this.NL + "\t\t}" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Filter matches per segment for the rule \"";
    protected final String TEXT_181 = "\"." + this.NL + "\t * @param vertex The current vertex." + this.NL + "\t * @param matches The current matches." + this.NL + "\t * @param segment The current segment." + this.NL + "\t * @param microstep The current microstep." + this.NL + "\t * @param finalMatches Set of final matches." + this.NL + "\t * @return The filtered matches." + this.NL + "\t */" + this.NL + "\tprotected Iterable<Match> filter";
    protected final String TEXT_182 = "(Vertex<VertexId, ByteWritable, ByteWritable> vertex," + this.NL + "\t\tIterable<Match> matches, int segment, int microstep, Set<Match> finalMatches) throws IOException {" + this.NL + "\t\tif (segment > 0) {" + this.NL + "\t\t\tList<Match> filtered = new ArrayList<Match>();" + this.NL + "\t\t\tlong matchCount = 0;" + this.NL + "\t\t\tlong appCount = 0;" + this.NL + "\t\t\tfor (Match match : matches) {" + this.NL + "\t\t\t\tint matchSegment = match.getSegment();" + this.NL + "\t\t\t\tif (matchSegment < segment) {" + this.NL + "\t\t\t\t\tif (!finalMatches.add(match)) {" + this.NL + "\t\t\t\t\t\tcontinue;" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t\tmatchCount++;" + this.NL + "\t\t\t\t\tif (segment == SEGMENT_COUNT - 1 && microstep == ";
    protected final String TEXT_183 = ") {" + this.NL + "\t\t\t\t\t\tapply";
    protected final String TEXT_184 = "(vertex, match, appCount++);" + this.NL + "\t\t\t\t\t} else {" + this.NL + "\t\t\t\t\t\tsendMessage(vertex.getId(), match);" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t} else if (matchSegment > segment) {" + this.NL + "\t\t\t\t\tthrow new RuntimeException(\"Received match \" + match +" + this.NL + "\t\t\t\t\t\t\" of rule ";
    protected final String TEXT_185 = " of segment \" +" + this.NL + "\t\t\t\t\t\tmatchSegment + \", but current segment is only \" + segment);" + this.NL + "\t\t\t\t} else {" + this.NL + "\t\t\t\t\tfiltered.add(match.copy());" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}" + this.NL + "\t\t\tif (matchCount > 0) {" + this.NL + "\t\t\t\taggregate(AGGREGATOR_MATCHES, new LongWritable(matchCount));" + this.NL + "\t\t\t}" + this.NL + "\t\t\tif (appCount > 0) {" + this.NL + "\t\t\t\taggregate(AGGREGATOR_RULE_APPLICATIONS, new LongWritable(appCount));" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn filtered;" + this.NL + "\t\t}" + this.NL + "\t\treturn matches;" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Apply the rule \"";
    protected final String TEXT_186 = "\" to a given match." + this.NL + "\t * @param vertex The base vertex." + this.NL + "\t * @param match The match object." + this.NL + "\t * @param matchIndex Match index." + this.NL + "\t * @return true if the rule was applied." + this.NL + "\t * @throws IOException On I/O errors." + this.NL + "\t */" + this.NL + "\tprotected boolean apply";
    protected final String TEXT_187 = "(" + this.NL + "\t\tVertex<VertexId, ByteWritable, ByteWritable> vertex," + this.NL + "\t\tMatch match, long matchIndex) throws IOException {";
    protected final String TEXT_188 = String.valueOf(this.NL) + "\t\tVertexId cur";
    protected final String TEXT_189 = " = match.getVertexId(";
    protected final String TEXT_190 = ");";
    protected final String TEXT_191 = String.valueOf(this.NL) + "\t\tLOG.info(\"Vertex \" + vertex.getId() +" + this.NL + "\t\t\t\" applying rule ";
    protected final String TEXT_192 = " with match \" + match);";
    protected final String TEXT_193 = String.valueOf(this.NL) + "\t\tremoveEdgesRequest(cur";
    protected final String TEXT_194 = ", cur";
    protected final String TEXT_195 = ");";
    protected final String TEXT_196 = String.valueOf(this.NL) + "\t\tremoveVertexRequest(cur";
    protected final String TEXT_197 = ");";
    protected final String TEXT_198 = String.valueOf(this.NL) + "\t\tVertexId new";
    protected final String TEXT_199 = " =";
    protected final String TEXT_200 = String.valueOf(this.NL) + "\t\t\tVertexId.randomVertexId();";
    protected final String TEXT_201 = String.valueOf(this.NL) + "\t\t\tderiveVertexId(vertex.getId(), (int) matchIndex, ";
    protected final String TEXT_202 = ");";
    protected final String TEXT_203 = String.valueOf(this.NL) + "\t\taddVertexRequest(new";
    protected final String TEXT_204 = ", new ByteWritable(";
    protected final String TEXT_205 = "));";
    protected final String TEXT_206 = String.valueOf(this.NL) + "\t\tVertexId src";
    protected final String TEXT_207 = " = new";
    protected final String TEXT_208 = ";";
    protected final String TEXT_209 = String.valueOf(this.NL) + "\t\tVertexId src";
    protected final String TEXT_210 = " = cur";
    protected final String TEXT_211 = ";";
    protected final String TEXT_212 = String.valueOf(this.NL) + "\t\tVertexId trg";
    protected final String TEXT_213 = " = new";
    protected final String TEXT_214 = ";";
    protected final String TEXT_215 = String.valueOf(this.NL) + "\t\tVertexId trg";
    protected final String TEXT_216 = " = cur";
    protected final String TEXT_217 = ";";
    protected final String TEXT_218 = String.valueOf(this.NL) + "\t\tEdge<VertexId, ByteWritable> edge";
    protected final String TEXT_219 = " = EdgeFactory.create(trg";
    protected final String TEXT_220 = ", new ByteWritable(";
    protected final String TEXT_221 = "));" + this.NL + "\t\taddEdgeRequest(src";
    protected final String TEXT_222 = ", edge";
    protected final String TEXT_223 = ");";
    protected final String TEXT_224 = String.valueOf(this.NL) + "\t\treturn true;" + this.NL + "\t}";
    protected final String TEXT_225 = this.NL;
    protected final String TEXT_226 = String.valueOf(this.NL) + "\t/**" + this.NL + "\t * Derive a new vertex Id from an exiting one." + this.NL + "\t * @param baseId The base vertex Id." + this.NL + "\t * @param matchIndex The index of the match." + this.NL + "\t * @param vertexIndex The index of the new vertex." + this.NL + "\t * @return The derived vertex Id." + this.NL + "\t */" + this.NL + "\tprivate VertexId deriveVertexId(VertexId baseId, int matchIndex, int vertexIndex) {" + this.NL + "\t\tlong generation = ((LongWritable) getAggregatedValue(AGGREGATOR_NODE_GENERATION)).get();" + this.NL + "\t\treturn baseId.append((byte) generation).append((byte) matchIndex).append((byte) vertexIndex);" + this.NL + "\t}" + this.NL;
    protected final String TEXT_227 = String.valueOf(this.NL) + "\t/**" + this.NL + "\t * Get the segment that a vertex belongs to." + this.NL + "\t * @param vertexId The ID of the vertex." + this.NL + "\t * @return The segment of the vertex." + this.NL + "\t */" + this.NL + "\tprivate int getSegment(VertexId vertexId) {" + this.NL + "\t\treturn Math.abs(vertexId.hashCode()) % SEGMENT_COUNT;" + this.NL + "\t}" + this.NL + this.NL + "\t/**" + this.NL + "\t * Master compute which registers and updates the required aggregators." + this.NL + "\t */" + this.NL + "\tpublic static class MasterCompute extends DefaultMasterCompute {" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Stack for storing unit success flags." + this.NL + "\t\t */" + this.NL + "\t\tprotected final Deque<Boolean> unitSuccesses = new ArrayDeque<Boolean>();" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Stack for storing the execution orders of independent units." + this.NL + "\t\t */" + this.NL + "\t\tprotected final Deque<List<Integer>> unitOrders = new ArrayDeque<List<Integer>>();" + this.NL + this.NL + "\t\t/*" + this.NL + "\t\t * (non-Javadoc)" + this.NL + "\t\t * @see org.apache.giraph.master.DefaultMasterCompute#compute()" + this.NL + "\t\t */" + this.NL + "\t\t@Override" + this.NL + "\t\tpublic void compute() {" + this.NL + "\t\t\tlong ruleApps = ((LongWritable) getAggregatedValue(AGGREGATOR_RULE_APPLICATIONS)).get();";
    protected final String TEXT_228 = String.valueOf(this.NL) + "\t\t\tlong matches = ((LongWritable) getAggregatedValue(AGGREGATOR_MATCHES)).get();" + this.NL + "\t\t\tif (getSuperstep() > 0) {" + this.NL + "\t\t\t\tLOG.info(matches + \" (partial) matches computed and \" +" + this.NL + "\t\t\t\t\truleApps + \" rule applications conducted in superstep \" +" + this.NL + "\t\t\t\t\t(getSuperstep() - 1));" + this.NL + "\t\t\t}";
    protected final String TEXT_229 = String.valueOf(this.NL) + "\t\t\tif (ruleApps > 0) {" + this.NL + "\t\t\t\tlong nodeGen = ((LongWritable) getAggregatedValue(AGGREGATOR_NODE_GENERATION)).get();" + this.NL + "\t\t\t\tsetAggregatedValue(AGGREGATOR_NODE_GENERATION, new LongWritable(nodeGen + 1));" + this.NL + "\t\t\t}" + this.NL + "\t\t\tApplicationStack stack;" + this.NL + "\t\t\tif (getSuperstep() == 0) {" + this.NL + "\t\t\t\tstack = new ApplicationStack();" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_230 = ", 0, 0);";
    protected final String TEXT_231 = String.valueOf(this.NL) + "\t\t\t\tstack = nextRuleStep(stack, ruleApps);";
    protected final String TEXT_232 = String.valueOf(this.NL) + "\t\t\t} else {" + this.NL + "\t\t\t\tstack = getAggregatedValue(AGGREGATOR_APPLICATION_STACK);" + this.NL + "\t\t\t\tstack = nextRuleStep(stack, ruleApps);" + this.NL + "\t\t\t}" + this.NL + "\t\t\tsetAggregatedValue(AGGREGATOR_APPLICATION_STACK, stack);" + this.NL + "\t\t}" + this.NL + this.NL + "\t\t/**" + this.NL + "\t\t * Compute the next rule application stack." + this.NL + "\t\t * @param stack The current application stack." + this.NL + "\t\t * @param ruleApps Number of rule applications in last superstep." + this.NL + "\t\t * @return The new application stack." + this.NL + "\t\t */" + this.NL + "\t\tprivate ApplicationStack nextRuleStep(" + this.NL + "\t\t\tApplicationStack stack, long ruleApps) {" + this.NL + "\t\t\twhile (stack.getStackSize() > 0) {" + this.NL + "\t\t\t\tint unit = stack.getLastUnit();" + this.NL + "\t\t\t\tint segment = stack.getLastSegment();" + this.NL + "\t\t\t\tint microstep = stack.getLastMicrostep();" + this.NL + "\t\t\t\tstack = stack.removeLast();" + this.NL + "\t\t\t\tswitch (unit) {";
    protected final String TEXT_233 = String.valueOf(this.NL) + "\t\t\t\tcase ";
    protected final String TEXT_234 = ":" + this.NL + "\t\t\t\t\tstack = process";
    protected final String TEXT_235 = "(stack";
    protected final String TEXT_236 = ", microstep";
    protected final String TEXT_237 = ");" + this.NL + "\t\t\t\t\tbreak;";
    protected final String TEXT_238 = String.valueOf(this.NL) + "\t\t\t\tdefault:" + this.NL + "\t\t\t\t\tthrow new RuntimeException(\"Unknown unit \" + unit);" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\tif (stack.getStackSize() > 0) {" + this.NL + "\t\t\t\t\tunit = stack.getLastUnit();";
    protected final String TEXT_239 = String.valueOf(this.NL) + "\t\t\t\t\t";
    protected final String TEXT_240 = "unit == ";
    protected final String TEXT_241 = String.valueOf(this.NL) + "\t\t\t\t\t\tbreak;" + this.NL + "\t\t\t\t\t}" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}" + this.NL + "\t\t\treturn stack;" + this.NL + "\t\t}";
    protected final String TEXT_242 = String.valueOf(this.NL) + this.NL + "\t\t/**" + this.NL + "\t\t * Process ";
    protected final String TEXT_243 = " \"";
    protected final String TEXT_244 = "\"." + this.NL + "\t\t * @param stack The current application stack.";
    protected final String TEXT_245 = String.valueOf(this.NL) + "\t\t * @param segment The current segment.";
    protected final String TEXT_246 = String.valueOf(this.NL) + "\t\t * @param microstep The current microstep.";
    protected final String TEXT_247 = String.valueOf(this.NL) + "\t\t * @param ruleApps Number of rule applications in last superstep.";
    protected final String TEXT_248 = String.valueOf(this.NL) + "\t\t * @return The new application stack." + this.NL + "\t\t */" + this.NL + "\t\tprivate ApplicationStack process";
    protected final String TEXT_249 = "(ApplicationStack stack";
    protected final String TEXT_250 = ", int microstep";
    protected final String TEXT_251 = ") {";
    protected final String TEXT_252 = String.valueOf(this.NL) + "\t\t\tif (microstep > 0 && !unitSuccesses.pop()) {" + this.NL + "\t\t\t\tunitSuccesses.push(false);" + this.NL + "\t\t\t} else if (microstep == ";
    protected final String TEXT_253 = ") {" + this.NL + "\t\t\t\tunitSuccesses.push(true);" + this.NL + "\t\t\t} else if (microstep < ";
    protected final String TEXT_254 = ") {" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_255 = ", 0, microstep + 1);" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_256 = ", 0, 0);" + this.NL + "\t\t\t}";
    protected final String TEXT_257 = String.valueOf(this.NL) + "\t\t\tif (microstep > 0 && !unitSuccesses.pop()) {" + this.NL + "\t\t\t\tunitSuccesses.push(false);" + this.NL + "\t\t\t} else if (microstep == ";
    protected final String TEXT_258 = ") {" + this.NL + "\t\t\t\tunitSuccesses.push(true);" + this.NL + "\t\t\t} else {" + this.NL + "\t\t\t\tswitch (microstep) {";
    protected final String TEXT_259 = String.valueOf(this.NL) + "\t\t\t\tcase ";
    protected final String TEXT_260 = ":" + this.NL + "\t\t\t\t\tstack = stack.append(";
    protected final String TEXT_261 = ", 0, ";
    protected final String TEXT_262 = ");" + this.NL + "\t\t\t\t\tstack = stack.append(";
    protected final String TEXT_263 = ", 0, 0);" + this.NL + "\t\t\t\t\tbreak;";
    protected final String TEXT_264 = String.valueOf(this.NL) + "\t\t\t\tdefault:" + this.NL + "\t\t\t\t\tbreak;" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}";
    protected final String TEXT_265 = String.valueOf(this.NL) + "\t\t\tif (microstep == 0) {" + this.NL + "\t\t\t\tList<Integer> order = new ArrayList<Integer>();" + this.NL + "\t\t\t\tfor (int i = 0; i < ";
    protected final String TEXT_266 = "; i++) {" + this.NL + "\t\t\t\t\torder.add(i);" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t\tCollections.shuffle(order);" + this.NL + "\t\t\t\tunitOrders.push(order);" + this.NL + "\t\t\t}" + this.NL + "\t\t\tif (microstep > 0 && unitSuccesses.pop()) {" + this.NL + "\t\t\t\tunitOrders.pop();" + this.NL + "\t\t\t\tunitSuccesses.push(true);" + this.NL + "\t\t\t} else if (microstep == ";
    protected final String TEXT_267 = ") {" + this.NL + "\t\t\t\tunitOrders.pop();" + this.NL + "\t\t\t\tunitSuccesses.push(false);" + this.NL + "\t\t\t} else {" + this.NL + "\t\t\t\tint next = unitOrders.peek().get(microstep);" + this.NL + "\t\t\t\tswitch (next) {";
    protected final String TEXT_268 = String.valueOf(this.NL) + "\t\t\t\tcase ";
    protected final String TEXT_269 = ":" + this.NL + "\t\t\t\t\tstack = stack.append(";
    protected final String TEXT_270 = ", 0, microstep + 1);" + this.NL + "\t\t\t\t\tstack = stack.append(";
    protected final String TEXT_271 = ", 0, 0);" + this.NL + "\t\t\t\t\tbreak;";
    protected final String TEXT_272 = String.valueOf(this.NL) + "\t\t\t\tdefault:" + this.NL + "\t\t\t\t\tbreak;" + this.NL + "\t\t\t\t}" + this.NL + "\t\t\t}";
    protected final String TEXT_273 = String.valueOf(this.NL) + "\t\t\tif (microstep == 0 || unitSuccesses.pop()) {" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_274 = ", 0, 1);" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_275 = ", 0, 0);" + this.NL + "\t\t\t} else {" + this.NL + "\t\t\t\tunitSuccesses.push(true);" + this.NL + "\t\t\t}";
    protected final String TEXT_276 = String.valueOf(this.NL) + "\t\t\tif (microstep < ";
    protected final String TEXT_277 = ") {" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_278 = ", segment, microstep + 1);" + this.NL + "\t\t\t} else if (segment < SEGMENT_COUNT - 1) {" + this.NL + "\t\t\t\tstack = stack.append(";
    protected final String TEXT_279 = ", segment + 1, 0);" + this.NL + "\t\t\t} else {" + this.NL + "\t\t\t\tunitSuccesses.push(ruleApps > 0);" + this.NL + "\t\t\t}";
    protected final String TEXT_280 = String.valueOf(this.NL) + "\t\t\treturn stack;" + this.NL + "\t\t}";
    protected final String TEXT_281 = String.valueOf(this.NL) + this.NL + "\t\t/*" + this.NL + "\t\t * (non-Javadoc)" + this.NL + "\t\t * @see org.apache.giraph.master.DefaultMasterCompute#initialize()" + this.NL + "\t\t */" + this.NL + "\t\t@Override" + this.NL + "\t\tpublic void initialize() throws InstantiationException, IllegalAccessException {" + this.NL + "\t\t\tregisterAggregator(AGGREGATOR_MATCHES, LongSumAggregator.class);" + this.NL + "\t\t\tregisterAggregator(AGGREGATOR_RULE_APPLICATIONS, LongSumAggregator.class);" + this.NL + "\t\t\tregisterPersistentAggregator(AGGREGATOR_NODE_GENERATION, LongSumAggregator.class);" + this.NL + "\t\t\tregisterPersistentAggregator(AGGREGATOR_APPLICATION_STACK, ApplicationStackAggregator.class);" + this.NL + "\t\t}" + this.NL + this.NL + "\t}" + this.NL + "}";
    protected final String TEXT_282 = this.NL;

    public static synchronized GiraphRuleTemplate create(String lineSeparator) {
        nl = lineSeparator;
        GiraphRuleTemplate result = new GiraphRuleTemplate();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        Map args = (Map)argument;
        Map ruleData = (Map)args.get("ruleData");
        Unit mainUnit = (Unit)args.get("mainUnit");
        String className = (String)args.get("className");
        String packageName = (String)args.get("packageName");
        boolean masterLogging = (Boolean)args.get("masterLogging");
        boolean vertexLogging = (Boolean)args.get("vertexLogging");
        boolean useUUIDs = (Boolean)args.get("useUUIDs");
        int segmentCount = (Integer)args.get("segmentCount");
        ArrayList<Unit> allUnits = new ArrayList<Unit>();
        allUnits.add(mainUnit);
        allUnits.addAll((Collection<Unit>)mainUnit.getSubUnits(true));
        ArrayList rules = new ArrayList(ruleData.keySet());
        boolean needsEdgeFactory = false;
        boolean needsVertexIdFactory = false;
        int maxCreatedNodes = 0;
        for (GiraphRuleData data : ruleData.values()) {
            if (!data.changeInfo.getCreatedEdges().isEmpty()) {
                needsEdgeFactory = true;
            }
            if (!data.changeInfo.getCreatedNodes().isEmpty()) {
                needsVertexIdFactory = true;
            }
            maxCreatedNodes = Math.max(maxCreatedNodes, data.changeInfo.getCreatedNodes().size());
        }
        boolean needsCollections = false;
        for (Unit unit : allUnits) {
            if (!(unit instanceof IndependentUnit)) continue;
            needsCollections = true;
            break;
        }
        stringBuffer.append("package ");
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_2);
        if (needsCollections) {
            stringBuffer.append(this.TEXT_3);
        }
        stringBuffer.append(this.TEXT_4);
        if (needsEdgeFactory) {
            stringBuffer.append(this.TEXT_5);
        }
        stringBuffer.append(this.TEXT_6);
        if (masterLogging || vertexLogging) {
            stringBuffer.append(this.TEXT_7);
        }
        stringBuffer.append(this.TEXT_8);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_9);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_10);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_11);
        stringBuffer.append(packageName);
        stringBuffer.append(this.TEXT_12);
        stringBuffer.append(mainUnit.getName());
        stringBuffer.append(this.TEXT_13);
        stringBuffer.append(mainUnit.getName());
        stringBuffer.append(this.TEXT_14);
        stringBuffer.append(className);
        stringBuffer.append(this.TEXT_15);
        Map<ENamedElement, String> typeConstants = GiraphUtil.getTypeConstants(mainUnit.getModule());
        int value = 0;
        for (ENamedElement type : typeConstants.keySet()) {
            stringBuffer.append(this.TEXT_16);
            stringBuffer.append(type.getName());
            stringBuffer.append(this.TEXT_17);
            stringBuffer.append(typeConstants.get(type));
            stringBuffer.append(" = ");
            stringBuffer.append(value++);
            stringBuffer.append(";");
        }
        Map<Unit, String> unitConstants = GiraphUtil.getUnitConstants(mainUnit);
        value = 0;
        for (Unit unit : unitConstants.keySet()) {
            stringBuffer.append(this.TEXT_20);
            stringBuffer.append(unit instanceof Rule ? "Rule" : "Unit");
            stringBuffer.append(" constant for \"");
            stringBuffer.append(unit.getName());
            stringBuffer.append(this.TEXT_22);
            stringBuffer.append(unitConstants.get(unit));
            stringBuffer.append(" = ");
            stringBuffer.append(value++);
            stringBuffer.append(";");
        }
        if (masterLogging || vertexLogging) {
            stringBuffer.append(this.TEXT_25);
            stringBuffer.append(className);
            stringBuffer.append(".class);");
        }
        stringBuffer.append(this.TEXT_27);
        stringBuffer.append(segmentCount);
        stringBuffer.append(this.TEXT_28);
        for (Rule rule : rules) {
            stringBuffer.append(this.TEXT_29);
            stringBuffer.append(unitConstants.get(rule));
            stringBuffer.append(this.TEXT_30);
            stringBuffer.append(((GiraphRuleData)ruleData.get((Object)rule)).rule.getName());
            stringBuffer.append(this.TEXT_31);
        }
        stringBuffer.append(this.TEXT_32);
        for (GiraphRuleData data : ruleData.values()) {
            Rule rule = data.rule;
            RuleChangeInfo changeInfo = data.changeInfo;
            ArrayList<Integer> required = new ArrayList<Integer>();
            for (Node node : data.requiredNodes) {
                required.add(data.orderedLhsNodes.indexOf(node));
            }
            Collections.sort(required);
            Collections.reverse(required);
            stringBuffer.append(this.TEXT_33);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_34);
            stringBuffer.append(data.matchingSteps.size());
            stringBuffer.append(this.TEXT_35);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_36);
            if (vertexLogging) {
                stringBuffer.append(this.TEXT_37);
                stringBuffer.append(rule.getName());
                stringBuffer.append(this.TEXT_38);
            }
            stringBuffer.append(this.TEXT_39);
            stringBuffer.append(data.matchingSteps.size() > 1 ? "matches = " : "");
            stringBuffer.append("filter");
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_41);
            int i = 0;
            while (i < data.matchingSteps.size()) {
                GiraphRuleData.MatchingStep step = data.matchingSteps.get(i);
                stringBuffer.append(i > 0 ? " else" : "\t ");
                stringBuffer.append(" if (microstep == ");
                stringBuffer.append(i);
                stringBuffer.append(") {");
                if (step.isJoin) {
                    stringBuffer.append(this.TEXT_44);
                    stringBuffer.append(GiraphUtil.getNodeName(step.node));
                    stringBuffer.append(this.TEXT_45);
                    stringBuffer.append(data.orderedLhsNodes.indexOf(step.node));
                    stringBuffer.append(this.TEXT_46);
                    if (vertexLogging) {
                        stringBuffer.append(this.TEXT_47);
                        stringBuffer.append(rule.getName());
                        stringBuffer.append("\");");
                    }
                    stringBuffer.append(this.TEXT_49);
                    if (rule.isInjectiveMatching()) {
                        stringBuffer.append(this.TEXT_50);
                    }
                    if (step.sendBackTo != null) {
                        stringBuffer.append(this.TEXT_51);
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_52);
                            stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                            stringBuffer.append("));");
                        }
                        stringBuffer.append(this.TEXT_54);
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                        stringBuffer.append("), match);");
                    } else if (i == data.matchingSteps.size() - 1) {
                        for (Integer req : required) {
                            stringBuffer.append(this.TEXT_56);
                            stringBuffer.append(req);
                            stringBuffer.append(this.TEXT_57);
                        }
                        stringBuffer.append(this.TEXT_58);
                        stringBuffer.append(data.rule.getName());
                        stringBuffer.append(this.TEXT_59);
                    }
                    stringBuffer.append(this.TEXT_60);
                } else {
                    String xx = "";
                    if (step.isMatching) {
                        xx = "\t";
                        List<EClass> validTypes = GiraphUtil.getValidTypes(step.node, mainUnit.getModule());
                        stringBuffer.append(this.TEXT_61);
                        stringBuffer.append(GiraphUtil.getNodeName(step.node));
                        stringBuffer.append(":");
                        int j = 0;
                        while (j < validTypes.size()) {
                            stringBuffer.append(this.TEXT_63);
                            stringBuffer.append(j == 0 ? "boolean ok = " : "\t");
                            stringBuffer.append("vertex.getValue().get() == ");
                            stringBuffer.append(typeConstants.get(validTypes.get(j)));
                            stringBuffer.append(j == validTypes.size() - 1 ? ";" : " ||");
                            ++j;
                        }
                        if (rule.isInjectiveMatching() && !step.node.getOutgoing().isEmpty()) {
                            stringBuffer.append(this.TEXT_65);
                            stringBuffer.append(step.node.getOutgoing().size());
                            stringBuffer.append(";");
                        }
                        if (i == 0) {
                            stringBuffer.append(this.TEXT_67);
                        }
                        stringBuffer.append(this.TEXT_68);
                    }
                    if (step.isStart) {
                        stringBuffer.append(this.TEXT_69);
                    } else {
                        stringBuffer.append(this.TEXT_70);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\tfor (Match match : matches) {");
                        if (step.isMatching) {
                            NodeEquivalence equi;
                            stringBuffer.append(this.TEXT_72);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\tmatch = match.append(vertex.getId());");
                            if (rule.isInjectiveMatching()) {
                                stringBuffer.append(this.TEXT_74);
                                stringBuffer.append(xx);
                                stringBuffer.append("\t\t\t\tif (!match.isInjective()) {");
                                stringBuffer.append(this.TEXT_76);
                                stringBuffer.append(xx);
                                stringBuffer.append("\t\t\t\t\tcontinue;");
                                stringBuffer.append(this.TEXT_78);
                                stringBuffer.append(xx);
                                stringBuffer.append("\t\t\t\t}");
                            }
                            if ((equi = data.requiredNodesEquivalences.get(step.node)) != null && equi.indexOf((Object)step.node) > 0) {
                                Node compareTo = (Node)equi.get(equi.indexOf((Object)step.node) - 1);
                                stringBuffer.append(this.TEXT_80);
                                stringBuffer.append(xx);
                                stringBuffer.append("\t\t\t\tif (vertex.getId().compareTo(match.getVertexId(");
                                stringBuffer.append(data.orderedLhsNodes.indexOf(compareTo));
                                stringBuffer.append(")) < 0) {");
                                stringBuffer.append(this.TEXT_83);
                                stringBuffer.append(xx);
                                stringBuffer.append("\t\t\t\t\tcontinue;");
                                stringBuffer.append(this.TEXT_85);
                                stringBuffer.append(xx);
                                stringBuffer.append("\t\t\t\t}");
                            }
                        }
                    }
                    if (step.edge != null && step.verifyEdgeTo != null) {
                        xx = String.valueOf(xx) + "\t\t";
                        stringBuffer.append(this.TEXT_87);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t// Node ");
                        stringBuffer.append(GiraphUtil.getNodeName(step.edge.getSource()));
                        stringBuffer.append(": check for edge to match of ");
                        stringBuffer.append(GiraphUtil.getNodeName(step.edge.getTarget()));
                        stringBuffer.append(" of type \"");
                        stringBuffer.append(step.edge.getType().getName());
                        stringBuffer.append("\":");
                        stringBuffer.append(this.TEXT_92);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\tVertexId targetId = match.getVertexId(");
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.verifyEdgeTo));
                        stringBuffer.append(");");
                        stringBuffer.append(this.TEXT_95);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\tfor (Edge<VertexId, ByteWritable> edge :");
                        stringBuffer.append(this.TEXT_97);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\tvertex.getEdges()) {");
                        stringBuffer.append(this.TEXT_99);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\tif (edge.getValue().get() ==");
                        stringBuffer.append(this.TEXT_101);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t");
                        stringBuffer.append(typeConstants.get(step.edge.getType()));
                        stringBuffer.append(" &&");
                        stringBuffer.append(this.TEXT_104);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tedge.getTargetVertexId().equals(targetId)) {");
                    }
                    if (step.sendBackTo != null) {
                        stringBuffer.append(this.TEXT_106);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tmatchCount++;");
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_108);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\tLOG.info(\"Vertex \" + vertex.getId() +");
                            stringBuffer.append(this.TEXT_110);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\t\t\" sending (partial) match \" + match +");
                            stringBuffer.append(this.TEXT_112);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\t\t\" back to vertex \" + match.getVertexId(");
                            stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                            stringBuffer.append("));");
                        }
                        stringBuffer.append(this.TEXT_115);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tsendMessage(match.getVertexId(");
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.sendBackTo));
                        stringBuffer.append("), match);");
                    } else if (i == data.matchingSteps.size() - 1) {
                        if (step.isStart) {
                            xx = "";
                        }
                        for (Integer req : required) {
                            stringBuffer.append(this.TEXT_118);
                            stringBuffer.append(xx);
                            stringBuffer.append("\t\t\t\tmatch = match.remove(");
                            stringBuffer.append(req);
                            stringBuffer.append(");");
                        }
                        stringBuffer.append(this.TEXT_121);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tif (finalMatches.add(match)) {");
                        stringBuffer.append(this.TEXT_123);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\tmatchCount++;");
                        stringBuffer.append(this.TEXT_125);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\tif (segment == SEGMENT_COUNT - 1) {");
                        stringBuffer.append(this.TEXT_127);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\t\tapply");
                        stringBuffer.append(data.rule.getName());
                        stringBuffer.append("(");
                        stringBuffer.append(this.TEXT_130);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\t\t\tvertex, match, appCount++);");
                        stringBuffer.append(this.TEXT_132);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\t} else {");
                        stringBuffer.append(this.TEXT_134);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\t\tsendMessage(vertex.getId(), match);");
                        stringBuffer.append(this.TEXT_136);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t\t}");
                        stringBuffer.append(this.TEXT_138);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\t}");
                    }
                    if (step.verifyEdgeTo != null) {
                        stringBuffer.append(this.TEXT_140);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t\tbreak;");
                        stringBuffer.append(this.TEXT_142);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t}");
                        stringBuffer.append(this.TEXT_144);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t}");
                        xx = xx.substring(0, xx.length() - 2);
                    }
                    if (step.edge != null && step.verifyEdgeTo == null) {
                        String yy = !step.isStart && step.isMatching ? "\t" : "";
                        stringBuffer.append(this.TEXT_146);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\tmatchCount++;");
                        stringBuffer.append(this.TEXT_148);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\tSet<VertexId> targets = new HashSet<VertexId>();");
                        stringBuffer.append(this.TEXT_150);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\tfor (Edge<VertexId, ByteWritable> edge : vertex.getEdges()) {");
                        stringBuffer.append(this.TEXT_152);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\tif (edge.getValue().get() ==");
                        stringBuffer.append(this.TEXT_154);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\t\t");
                        stringBuffer.append(typeConstants.get(step.edge.getType()));
                        stringBuffer.append(" &&");
                        stringBuffer.append(this.TEXT_157);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\t\ttargets.add(edge.getTargetVertexId())) {");
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_159);
                            stringBuffer.append(yy);
                            stringBuffer.append("\t\t\t\t\t\tLOG.info(\"Vertex \" + vertex.getId() +");
                            stringBuffer.append(this.TEXT_161);
                            stringBuffer.append(yy);
                            stringBuffer.append("\t\t\t\t\t\t\t\" sending (partial) match \" + match +");
                            stringBuffer.append(this.TEXT_163);
                            stringBuffer.append(yy);
                            stringBuffer.append("\t\t\t\t\t\t\t\" forward to vertex \" + edge.getTargetVertexId());");
                        }
                        stringBuffer.append(this.TEXT_165);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\t\tsendMessage(edge.getTargetVertexId(), match);");
                        stringBuffer.append(this.TEXT_167);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t\t}");
                        stringBuffer.append(this.TEXT_169);
                        stringBuffer.append(yy);
                        stringBuffer.append("\t\t\t\t}");
                    }
                    if (!step.isStart) {
                        stringBuffer.append(this.TEXT_171);
                        stringBuffer.append(xx);
                        stringBuffer.append("\t\t\t}");
                    }
                    if (step.isMatching) {
                        stringBuffer.append(this.TEXT_173);
                    }
                    if (step.keepMatchesOf != null) {
                        stringBuffer.append(this.TEXT_174);
                        stringBuffer.append(data.orderedLhsNodes.indexOf(step.keepMatchesOf));
                        stringBuffer.append(this.TEXT_175);
                        if (vertexLogging) {
                            stringBuffer.append(this.TEXT_176);
                        }
                        stringBuffer.append(this.TEXT_177);
                    }
                }
                stringBuffer.append(this.TEXT_178);
                ++i;
            }
            stringBuffer.append(this.TEXT_179);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_180);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_181);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_182);
            stringBuffer.append(data.matchingSteps.size() - 1);
            stringBuffer.append(this.TEXT_183);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_184);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_185);
            stringBuffer.append(rule.getName());
            stringBuffer.append(this.TEXT_186);
            stringBuffer.append(data.rule.getName());
            stringBuffer.append(this.TEXT_187);
            ArrayList<Node> matchNodes = new ArrayList<Node>();
            matchNodes.addAll(data.orderedLhsNodes);
            matchNodes.removeAll(data.requiredNodes);
            int j = 0;
            while (j < matchNodes.size()) {
                Node lhsNode = (Node)matchNodes.get(j);
                Node rhsNode = data.rule.getMappings().getImage(lhsNode, data.rule.getRhs());
                boolean needed = changeInfo.getDeletedNodes().contains(lhsNode);
                for (Edge edge : lhsNode.getAllEdges()) {
                    boolean bl = needed = needed || changeInfo.getDeletedEdges().contains(edge);
                }
                if (rhsNode != null) {
                    for (Edge edge : rhsNode.getAllEdges()) {
                        boolean bl = needed = needed || changeInfo.getCreatedEdges().contains(edge);
                    }
                }
                if (needed) {
                    stringBuffer.append(this.TEXT_188);
                    stringBuffer.append(j);
                    stringBuffer.append(" = match.getVertexId(");
                    stringBuffer.append(j);
                    stringBuffer.append(");");
                }
                ++j;
            }
            if (vertexLogging) {
                stringBuffer.append(this.TEXT_191);
                stringBuffer.append(data.rule.getName());
                stringBuffer.append(" with match \" + match);");
            }
            for (Edge edge : changeInfo.getDeletedEdges()) {
                stringBuffer.append(this.TEXT_193);
                stringBuffer.append(matchNodes.indexOf(edge.getSource()));
                stringBuffer.append(", cur");
                stringBuffer.append(matchNodes.indexOf(edge.getTarget()));
                stringBuffer.append(");");
            }
            for (Node node : changeInfo.getDeletedNodes()) {
                stringBuffer.append(this.TEXT_196);
                stringBuffer.append(matchNodes.indexOf(node));
                stringBuffer.append(");");
            }
            int n = 0;
            for (Node node : changeInfo.getCreatedNodes()) {
                stringBuffer.append(this.TEXT_198);
                stringBuffer.append(n);
                stringBuffer.append(" =");
                if (useUUIDs) {
                    stringBuffer.append(this.TEXT_200);
                } else {
                    stringBuffer.append(this.TEXT_201);
                    stringBuffer.append(n);
                    stringBuffer.append(");");
                }
                stringBuffer.append(this.TEXT_203);
                stringBuffer.append(n++);
                stringBuffer.append(", new ByteWritable(");
                stringBuffer.append(typeConstants.get(node.getType()));
                stringBuffer.append("));");
            }
            int e = 0;
            for (Edge edge : changeInfo.getCreatedEdges()) {
                if (changeInfo.getCreatedNodes().contains(edge.getSource())) {
                    stringBuffer.append(this.TEXT_206);
                    stringBuffer.append(e);
                    stringBuffer.append(" = new");
                    stringBuffer.append(changeInfo.getCreatedNodes().indexOf(edge.getSource()));
                    stringBuffer.append(";");
                } else {
                    stringBuffer.append(this.TEXT_209);
                    stringBuffer.append(e);
                    stringBuffer.append(" = cur");
                    stringBuffer.append(matchNodes.indexOf(data.rule.getMappings().getOrigin(edge.getSource())));
                    stringBuffer.append(";");
                }
                if (changeInfo.getCreatedNodes().contains(edge.getTarget())) {
                    stringBuffer.append(this.TEXT_212);
                    stringBuffer.append(e);
                    stringBuffer.append(" = new");
                    stringBuffer.append(changeInfo.getCreatedNodes().indexOf(edge.getTarget()));
                    stringBuffer.append(";");
                } else {
                    stringBuffer.append(this.TEXT_215);
                    stringBuffer.append(e);
                    stringBuffer.append(" = cur");
                    stringBuffer.append(matchNodes.indexOf(data.rule.getMappings().getOrigin(edge.getTarget())));
                    stringBuffer.append(";");
                }
                stringBuffer.append(this.TEXT_218);
                stringBuffer.append(e);
                stringBuffer.append(" = EdgeFactory.create(trg");
                stringBuffer.append(e);
                stringBuffer.append(", new ByteWritable(");
                stringBuffer.append(typeConstants.get(edge.getType()));
                stringBuffer.append(this.TEXT_221);
                stringBuffer.append(e);
                stringBuffer.append(", edge");
                stringBuffer.append(e);
                stringBuffer.append(");");
                ++e;
            }
            stringBuffer.append(this.TEXT_224);
        }
        stringBuffer.append(this.TEXT_225);
        if (needsVertexIdFactory && !useUUIDs) {
            stringBuffer.append(this.TEXT_226);
        }
        stringBuffer.append(this.TEXT_227);
        if (masterLogging) {
            stringBuffer.append(this.TEXT_228);
        }
        stringBuffer.append(this.TEXT_229);
        stringBuffer.append(unitConstants.get(mainUnit));
        stringBuffer.append(", 0, 0);");
        if (!(mainUnit instanceof Rule)) {
            stringBuffer.append(this.TEXT_231);
        }
        stringBuffer.append(this.TEXT_232);
        for (Unit unit : allUnits) {
            stringBuffer.append(this.TEXT_233);
            stringBuffer.append(unitConstants.get(unit));
            stringBuffer.append(this.TEXT_234);
            stringBuffer.append(unit.getName());
            stringBuffer.append("(stack");
            stringBuffer.append(unit instanceof Rule ? ", segment" : "");
            stringBuffer.append(", microstep");
            stringBuffer.append(unit instanceof Rule ? ", ruleApps" : "");
            stringBuffer.append(this.TEXT_237);
        }
        stringBuffer.append(this.TEXT_238);
        int i = 0;
        while (i < rules.size()) {
            stringBuffer.append(this.TEXT_239);
            stringBuffer.append(i == 0 ? "if (" : "\t");
            stringBuffer.append("unit == ");
            stringBuffer.append(String.valueOf(unitConstants.get(rules.get(i))) + (i < rules.size() - 1 ? " ||" : ") {"));
            ++i;
        }
        stringBuffer.append(this.TEXT_241);
        for (Unit unit : allUnits) {
            stringBuffer.append(this.TEXT_242);
            stringBuffer.append(unit.eClass().getName());
            stringBuffer.append(" \"");
            stringBuffer.append(unit.getName());
            stringBuffer.append(this.TEXT_244);
            if (unit instanceof Rule) {
                stringBuffer.append(this.TEXT_245);
            }
            stringBuffer.append(this.TEXT_246);
            if (unit instanceof Rule) {
                stringBuffer.append(this.TEXT_247);
            }
            stringBuffer.append(this.TEXT_248);
            stringBuffer.append(unit.getName());
            stringBuffer.append("(ApplicationStack stack");
            stringBuffer.append(unit instanceof Rule ? ", int segment" : "");
            stringBuffer.append(", int microstep");
            stringBuffer.append(unit instanceof Rule ? ", long ruleApps" : "");
            stringBuffer.append(") {");
            if (unit instanceof IteratedUnit) {
                int iters = Integer.parseInt(((IteratedUnit)unit).getIterations());
                stringBuffer.append(this.TEXT_252);
                stringBuffer.append(iters);
                stringBuffer.append(this.TEXT_253);
                stringBuffer.append(iters);
                stringBuffer.append(this.TEXT_254);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_255);
                stringBuffer.append(unitConstants.get(((IteratedUnit)unit).getSubUnit()));
                stringBuffer.append(this.TEXT_256);
            } else if (unit instanceof SequentialUnit) {
                SequentialUnit seq = (SequentialUnit)unit;
                stringBuffer.append(this.TEXT_257);
                stringBuffer.append(seq.getSubUnits().size());
                stringBuffer.append(this.TEXT_258);
                int i2 = 0;
                while (i2 < seq.getSubUnits().size()) {
                    stringBuffer.append(this.TEXT_259);
                    stringBuffer.append(i2);
                    stringBuffer.append(this.TEXT_260);
                    stringBuffer.append(unitConstants.get(unit));
                    stringBuffer.append(", 0, ");
                    stringBuffer.append(i2 + 1);
                    stringBuffer.append(this.TEXT_262);
                    stringBuffer.append(unitConstants.get(seq.getSubUnits().get(i2)));
                    stringBuffer.append(this.TEXT_263);
                    ++i2;
                }
                stringBuffer.append(this.TEXT_264);
            } else if (unit instanceof IndependentUnit) {
                IndependentUnit indi = (IndependentUnit)unit;
                stringBuffer.append(this.TEXT_265);
                stringBuffer.append(indi.getSubUnits().size());
                stringBuffer.append(this.TEXT_266);
                stringBuffer.append(indi.getSubUnits().size());
                stringBuffer.append(this.TEXT_267);
                int i3 = 0;
                while (i3 < indi.getSubUnits().size()) {
                    stringBuffer.append(this.TEXT_268);
                    stringBuffer.append(i3);
                    stringBuffer.append(this.TEXT_269);
                    stringBuffer.append(unitConstants.get(unit));
                    stringBuffer.append(this.TEXT_270);
                    stringBuffer.append(unitConstants.get(indi.getSubUnits().get(i3)));
                    stringBuffer.append(this.TEXT_271);
                    ++i3;
                }
                stringBuffer.append(this.TEXT_272);
            } else if (unit instanceof LoopUnit) {
                stringBuffer.append(this.TEXT_273);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_274);
                stringBuffer.append(unitConstants.get(((LoopUnit)unit).getSubUnit()));
                stringBuffer.append(this.TEXT_275);
            } else if (unit instanceof Rule) {
                stringBuffer.append(this.TEXT_276);
                stringBuffer.append(((GiraphRuleData)ruleData.get((Object)unit)).matchingSteps.size() - 1);
                stringBuffer.append(this.TEXT_277);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_278);
                stringBuffer.append(unitConstants.get(unit));
                stringBuffer.append(this.TEXT_279);
            }
            stringBuffer.append(this.TEXT_280);
        }
        stringBuffer.append(this.TEXT_281);
        stringBuffer.append(this.TEXT_282);
        return stringBuffer.toString();
    }
}

