/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.actions.ImportRulesPage;
import org.eclipse.emf.henshin.statespace.explorer.commands.ResetStateSpaceCommand;
import org.eclipse.emf.henshin.statespace.explorer.commands.SetRulesCommand;
import org.eclipse.emf.henshin.statespace.explorer.parts.StateSpaceExplorer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ImportRulesWizard
extends Wizard {
    private StateSpaceExplorer explorer;
    private ImportRulesPage rulesPage;

    public ImportRulesWizard(StateSpaceExplorer explorer) {
        this.explorer = explorer;
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle("Import Rules");
    }

    public void addPages() {
        StateSpace stateSpace = this.explorer.getStateSpaceManager().getStateSpace();
        this.rulesPage = new ImportRulesPage();
        this.rulesPage.setStateSpaceResource(stateSpace.eResource());
        this.rulesPage.getRules().addAll((Collection<Rule>)stateSpace.getRules());
        this.addPage((IWizardPage)this.rulesPage);
    }

    public boolean performFinish() {
        boolean changed;
        StateSpaceManager manager = this.explorer.getStateSpaceManager();
        List<Rule> newRules = this.rulesPage.getRules();
        EList oldRules = manager.getStateSpace().getRules();
        boolean bl = changed = oldRules.size() != newRules.size() || !oldRules.containsAll(newRules);
        if (changed && (manager.getStateSpace().getTransitionCount() == 0 || MessageDialog.openConfirm((Shell)this.getShell(), (String)"Reset", (String)"State space needs to be reset. Really continue?"))) {
            this.explorer.executeCommand(new SetRulesCommand(manager, newRules));
            this.explorer.executeCommand(new ResetStateSpaceCommand(manager));
        }
        return true;
    }
}

