/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.util.IntComparator;
import agg.util.OrderedSet;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.Type;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class LayerGUI
extends JDialog
implements ActionListener {
    private JPanel rulePanel;
    private JScrollPane ruleScrollPane;
    private JTable ruleTable;
    private JButton closeButton;
    private JButton cancelButton;
    private boolean isCncld;
    private JPanel contentPane;
    private RuleLayer layer;

    public LayerGUI(JFrame parent, RuleLayer layer) {
        super((Frame)new JFrame(), true);
        this.setTitle("Rule Layer Editor");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LayerGUI.this.exitForm(evt);
            }
        });
        this.setBackground(Color.lightGray);
        if (parent != null) {
            this.setLocationRelativeTo(parent);
            this.setLocation(100, 100);
        } else {
            this.setLocation(300, 100);
        }
        this.layer = layer;
        this.initComponents();
    }

    private void initComponents() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        JPanel rcdPanel = new JPanel(new BorderLayout());
        JPanel rcdPanel0 = new JPanel(new GridLayout(0, 1));
        this.rulePanel = new JPanel();
        this.rulePanel.setBackground(Color.orange);
        this.ruleScrollPane = new JScrollPane();
        this.ruleTable = new JTable();
        this.closeButton = new JButton();
        this.cancelButton = new JButton();
        this.rulePanel.setLayout(new BorderLayout());
        this.rulePanel.setBorder(new TitledBorder("Rule Layer"));
        this.ruleTable.setModel(new HashTableModel(this.layer, new String[]{"Rule Name", "Layer Number"}));
        int hght = this.getHeight(this.ruleTable.getRowCount(), this.ruleTable.getRowHeight());
        this.ruleTable.doLayout();
        this.ruleScrollPane.setViewportView(this.ruleTable);
        this.ruleScrollPane.setPreferredSize(new Dimension(200, hght));
        this.rulePanel.add(this.ruleScrollPane);
        rcdPanel0.add(this.rulePanel);
        rcdPanel.add(rcdPanel0);
        JPanel buttonPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(this);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        buttonPanel.add(this.cancelButton);
        this.contentPane.add((Component)buttonPanel, "South");
        this.contentPane.add(rcdPanel);
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    void exitForm(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean result;
        Object source = e.getSource();
        if (source == this.closeButton && (result = true)) {
            HashTableModel htm = (HashTableModel)this.ruleTable.getModel();
            int i = 0;
            while (i < htm.getRowCount()) {
                Object r = htm.getRuleAt(i, 0);
                if (r instanceof Rule) {
                    Integer v = (Integer)htm.getValueAt(i, 1);
                    ((Rule)r).setLayer(v);
                }
                ++i;
            }
        }
        if (source == this.closeButton) {
            this.isCncld = false;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.isCncld = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean isCancelled() {
        return this.isCncld;
    }

    private int getHeight(int rowCount, int rowHeight) {
        int h = (rowCount + 1) * rowHeight;
        if (rowCount > 10) {
            h = 12 * rowHeight;
        }
        return h;
    }

    public class HashTableModel
    extends DefaultTableModel {
        Hashtable<Rule, Integer> table;
        RuleLayer ruleLayer;

        public HashTableModel(Hashtable<Rule, Integer> table, String[] columnNames) {
            int i = 0;
            while (i < columnNames.length) {
                this.addColumn(columnNames[i]);
                ++i;
            }
            this.table = table;
            Enumeration<Rule> keys = table.keys();
            while (keys.hasMoreElements()) {
                Rule key = keys.nextElement();
                Integer value = table.get(key);
                Vector<Object> tmpVector = new Vector<Object>();
                tmpVector.addElement(key);
                tmpVector.addElement(value);
                this.addRow(tmpVector);
            }
        }

        public HashTableModel(RuleLayer layer, String[] columnNames) {
            int i = 0;
            while (i < columnNames.length) {
                this.addColumn(columnNames[i]);
                ++i;
            }
            this.table = layer.getRuleLayer();
            this.ruleLayer = layer;
            Integer startLayer = layer.getStartLayer();
            Hashtable<Integer, HashSet<Rule>> invertedRuleLayer = layer.invertLayer();
            OrderedSet<Integer> ruleLayerSet = new OrderedSet<Integer>(new IntComparator());
            Enumeration<Integer> en = invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                ruleLayerSet.add(en.nextElement());
            }
            int i2 = 0;
            Integer currentLayer = startLayer;
            boolean nextLayerExists = true;
            while (nextLayerExists && currentLayer != null) {
                HashSet<Rule> rulesForLayer = invertedRuleLayer.get(currentLayer);
                for (Rule rule : rulesForLayer) {
                    Vector<Object> tmpVector = new Vector<Object>();
                    tmpVector.addElement(rule);
                    tmpVector.addElement(new Integer(rule.getLayer()));
                    this.addRow(tmpVector);
                }
                if (++i2 < ruleLayerSet.size()) {
                    currentLayer = (Integer)ruleLayerSet.get(i2);
                    continue;
                }
                nextLayerExists = false;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                result = ((Rule)result).getName();
            } else if (result instanceof Type) {
                result = !((Type)result).getStringRepr().equals("") ? ((Type)result).getStringRepr() : ((Type)result).getAdditionalRepr();
            }
            return result;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            Object key = super.getValueAt(row, 0);
            try {
                Integer i = new Integer((String)aValue);
                super.setValueAt(i, row, column);
                if (key instanceof Rule) {
                    this.table.put((Rule)key, i);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public Object getRuleAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Rule) {
                return result;
            }
            return null;
        }
    }
}

