/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.csp.CompletionPropertyBits;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;

public class GraTraOptions {
    public static final String CSP = "CSP";
    public static final String CSP_WO_BJ = "CSP w/o BJ";
    public static final String INJECTIVE = "injective";
    public static final String DANGLING = "dangling";
    public static final String IDENTIFICATION = "identification";
    public static final String NACS = "NACs";
    public static final String PACS = "PACs";
    public static final String GACS = "GACs";
    public static final String RANDOM_CSP_DOMAIN = "randomCSPDomain";
    public static final String DETERMINED_CSP_DOMAIN = "determinedCSPDomain";
    public static final String CONSISTENT_ONLY = "consistency";
    public static final String CONSISTENCY_CHECK_AFTER_GRAPH_TRAFO = "consistencyCheckAfterGraphTrafo";
    public static final String STOP_INCONSISTENT = "stopInconsistency";
    public static final String CHECK_RULE_APPLICABILITY = "checkRuleApplicability";
    public static final String SHOW_GRAPH_AFTER_STEP = "showGraphAfterStep";
    public static final String WAIT_AFTER_STEP = "waitAfterStep";
    public static final String SELECT_NEW_AFTER_STEP = "selectNewAfterStep";
    public static final String NONDETERMINISTICALLY = "nondeterministically";
    public static final String PRIORITY = "priority";
    public static final String RULE_SEQUENCE = "ruleSequence";
    public static final String EACH_RULE_TO_APPLY = "eachRuleToApply";
    public static final String LAYERED = "layered";
    public static final String LOOP_OVER_LAYER = "layeredLoop";
    public static final String RESET_GRAPH = "resetGraph";
    public static final String STOP_LAYER_AND_WAIT = "stopLayerAndWait";
    public static final String BREAK_LAYER = "breakLayer";
    public static final String BREAK_ALL_LAYER = "breakAllLayer";
    public static final String PARALLEL_MATCHING = "parallelMatching";
    public static final String XY_POS_ATTRIBUTE = "xyPosAttribute";
    private final Vector<String> options = new Vector();
    private MorphCompletionStrategy strategy;

    public void addOption(String name) {
        if (!this.options.contains(name)) {
            this.options.addElement(name);
        }
    }

    public void removeOption(String name) {
        if (this.options.contains(name)) {
            this.options.removeElement(name);
        }
    }

    public boolean hasOption(String name) {
        return this.options.contains(name);
    }

    public Vector<String> getOptions() {
        return this.options;
    }

    public MorphCompletionStrategy getCompletionStrategy() {
        this.updateMorphismCompletionStrategy();
        return this.strategy;
    }

    public String toString() {
        int l = this.options.size();
        String result = this.options.elementAt(0);
        result = String.valueOf(result) + " [ ";
        int i = 1;
        while (i < l - 1) {
            result = String.valueOf(result) + this.options.elementAt(i);
            result = String.valueOf(result) + ", ";
            ++i;
        }
        result = String.valueOf(result) + this.options.elementAt(l - 1);
        result = String.valueOf(result) + " ]";
        return result;
    }

    public void updateMorphismCompletionStrategy() {
        String stratName = "";
        if (this.options.contains(CSP)) {
            stratName = CSP;
        } else if (this.options.contains(CSP_WO_BJ)) {
            stratName = CSP_WO_BJ;
        }
        Enumeration<MorphCompletionStrategy> strats = CompletionStrategySelector.getStrategies();
        while (strats.hasMoreElements()) {
            MorphCompletionStrategy mcs = strats.nextElement();
            String name = CompletionStrategySelector.getName(mcs);
            if (!stratName.equals(name)) continue;
            this.strategy = mcs;
        }
        if (this.strategy == null) {
            return;
        }
        this.strategy.getSupportedProperties();
        BitSet activebits = this.strategy.getProperties();
        int j = 0;
        while (j < CompletionPropertyBits.BITNAME.length) {
            String bitName = CompletionPropertyBits.BITNAME[j];
            if (this.options.contains(bitName)) {
                activebits.set(j);
            } else {
                activebits.clear(j);
            }
            ++j;
        }
        if (this.options.contains(DETERMINED_CSP_DOMAIN)) {
            this.strategy.setRandomisedDomain(false);
        }
    }
}

