/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.giraph;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GiraphRunner {
    private static final Pattern REGEX_AGGREGATE_VERTICES = Pattern.compile("\\sINFO\\s*mapred\\.JobClient:\\s*Aggregate\\svertices=(\\d+)");
    private static final Pattern REGEX_AGGREGATE_EDGES = Pattern.compile("\\sINFO\\s*mapred\\.JobClient:\\s*Aggregate\\sedges=(\\d+)");
    private int aggregateVertices;
    private int aggregateEdges;
    private boolean success;

    public synchronized boolean run(IFile launchFile) throws CoreException {
        this.aggregateVertices = 0;
        this.aggregateEdges = 0;
        final PrintStream outStream = System.out;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream bufStream = new PrintStream(buffer){

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                super.write(b, off, len);
                outStream.write(b, off, len);
            }
        };
        try {
            try {
                System.setOut(bufStream);
                AntRunner runner = new AntRunner();
                Object ret = runner.run((Object)new String[]{"-f", launchFile.getLocation().toOSString()});
                this.success = AntRunner.EXIT_OK.equals(ret);
                bufStream.close();
                buffer.flush();
            }
            catch (Exception e) {
                this.success = false;
                throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.henshin.giraph", "Error running Giraph", (Throwable)e));
            }
        }
        finally {
            System.setOut(outStream);
        }
        String log = buffer.toString();
        this.aggregateVertices = GiraphRunner.parseInt(REGEX_AGGREGATE_VERTICES, log);
        this.aggregateEdges = GiraphRunner.parseInt(REGEX_AGGREGATE_EDGES, log);
        return this.success;
    }

    public int getAggregateVertices() {
        return this.aggregateVertices;
    }

    public int getAggregateEdges() {
        return this.aggregateEdges;
    }

    public boolean isSuccess() {
        return this.success;
    }

    private static int parseInt(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return Integer.parseInt(string.substring(matcher.start(1), matcher.end(1)));
        }
        return -1;
    }
}

