/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.interpreter.PartitionedEGraph;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;

public class PartitionedEGraphImpl
extends EGraphImpl
implements PartitionedEGraph {
    private static final long serialVersionUID = 3609576887179687552L;
    private int numPartitions;
    private Map<EClass, List<EClass>> typePartitionMap;
    private Map<EClass, Integer> nextPartitionMap;

    public PartitionedEGraphImpl(int numPartitions) {
        this.initializePartitions(numPartitions);
    }

    public PartitionedEGraphImpl(EObject object, int partitionCount) {
        this.initializePartitions(partitionCount);
        this.initializeContents(Collections.singleton(object));
    }

    public PartitionedEGraphImpl(Collection<? extends EObject> collection, int numPartitions) {
        this.initializePartitions(numPartitions);
        this.initializeContents(collection);
    }

    public PartitionedEGraphImpl(Resource resource, int numPartitions) {
        this.initializePartitions(numPartitions);
        this.initializeContents((Collection<? extends EObject>)resource.getContents());
    }

    protected void initializePartitions(int numPartitions) {
        if (numPartitions < 1) {
            throw new IllegalArgumentException();
        }
        this.numPartitions = numPartitions;
        this.typePartitionMap = new LinkedHashMap<EClass, List<EClass>>();
        this.nextPartitionMap = new LinkedHashMap<EClass, Integer>();
    }

    @Override
    protected void didAdd(EObject object) {
        object.eAdapters().add((Object)this.crossReferenceAdapter);
        EClass type = object.eClass();
        this.getDomain(type, this.getNextPartition(type)).add(object);
        this.addEPackage(type.getEPackage());
    }

    @Override
    protected void didRemove(EObject object) {
        object.eAdapters().remove((Object)this.crossReferenceAdapter);
        for (EClass partitionType : this.getPartitionTypes(object.eClass())) {
            if (((List)this.domainMap.get(partitionType)).remove(object)) break;
        }
    }

    protected int getNextPartition(EClass type) {
        Integer partition = this.nextPartitionMap.get(type);
        if (partition == null) {
            partition = 0;
        }
        this.nextPartitionMap.put(type, (partition + 1) % this.numPartitions);
        return partition;
    }

    @Override
    protected void addChildParentRelation(EClass child, EClass parent) {
        super.addChildParentRelation(child, parent);
        for (EClass childProxy : this.getPartitionTypes(child)) {
            for (EClass parentProxy : this.getPartitionTypes(parent)) {
                super.addChildParentRelation(childProxy, parentProxy);
            }
        }
    }

    @Override
    public int getNumPartitions() {
        return this.numPartitions;
    }

    @Override
    public void clear() {
        super.clear();
        this.typePartitionMap.clear();
        this.nextPartitionMap.clear();
    }

    @Override
    public List<EObject> getDomain(EClass type, boolean strict) {
        ArrayList<EObject> domain = new ArrayList<EObject>();
        int p = 0;
        while (p < this.numPartitions) {
            domain.addAll(this.getDomain(type, strict, p));
            ++p;
        }
        return domain;
    }

    @Override
    public int getDomainSize(EClass type, boolean strict) {
        int size = 0;
        int p = 0;
        while (p < this.numPartitions) {
            size += this.getDomainSize(type, strict, p);
            ++p;
        }
        return size;
    }

    @Override
    public List<EObject> getDomain(EClass type, boolean strict, int partition) {
        if (strict) {
            return new ArrayList<EObject>(this.getDomain(type, partition));
        }
        ArrayList<EObject> domain = new ArrayList<EObject>();
        Set inhMap = (Set)this.inheritanceMap.get(type);
        if (inhMap != null) {
            for (EClass child : inhMap) {
                domain.addAll(this.getDomain(child, partition));
            }
        }
        return domain;
    }

    @Override
    public int getDomainSize(EClass type, boolean strict, int partition) {
        if (strict) {
            return this.getDomain(type, partition).size();
        }
        Set inhMap = (Set)this.inheritanceMap.get(type);
        int size = 0;
        if (inhMap != null) {
            for (EClass child : inhMap) {
                size += this.getDomain(child, partition).size();
            }
        }
        return size;
    }

    protected List<EClass> getPartitionTypes(EClass type) {
        List<EClass> partitionTypes = this.typePartitionMap.get(type);
        if (partitionTypes == null) {
            partitionTypes = new ArrayList<EClass>(this.numPartitions);
            int i = 0;
            while (i < this.numPartitions) {
                partitionTypes.add(EcoreFactory.eINSTANCE.createEClass());
                ++i;
            }
            this.typePartitionMap.put(type, partitionTypes);
        }
        return partitionTypes;
    }

    protected Collection<EObject> getDomain(EClass type, int partition) {
        return this.getDomain(this.getPartitionTypes(type).get(partition));
    }
}

