/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.info.RuleInfo;
import org.eclipse.emf.henshin.interpreter.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Constraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ContainmentConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DanglingConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.PathConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ReferenceConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.UnaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.emf.henshin.model.staticanalysis.PathFinder;

public class VariableInfo {
    private Collection<Variable> mainVariables;
    private Map<Node, Variable> node2variable;
    private Map<Variable, Node> variable2node;
    private Map<Graph, List<Variable>> graph2variables;
    private Map<Variable, Variable> variable2mainVariable;
    private Rule rule;
    private EngineImpl engine;
    private static final Integer ONE = new Integer(1);

    public VariableInfo(RuleInfo ruleInfo, EngineImpl engine) {
        this.rule = ruleInfo.getRule();
        this.engine = engine;
        this.node2variable = new HashMap<Node, Variable>();
        this.variable2node = new HashMap<Variable, Node>();
        this.graph2variables = new HashMap<Graph, List<Variable>>();
        this.variable2mainVariable = new HashMap<Variable, Variable>();
        this.createVariables(this.rule.getLhs(), null);
        for (Node node : this.rule.getLhs().getNodes()) {
            if (this.rule.getMappings().getImage(node, this.rule.getRhs()) != null) continue;
            this.createDanglingConstraints(node);
        }
        this.mainVariables = this.variable2mainVariable.values();
    }

    private void createVariables(Graph g, Collection<Mapping> mappings) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Node node : g.getNodes()) {
            EClass type = node.getType();
            Variable var = new Variable(type);
            variables.add(var);
            this.node2variable.put(node, var);
            this.variable2node.put(var, node);
            Variable mainVariable = var;
            if (mappings != null) {
                for (Mapping mapping : mappings) {
                    if (node != mapping.getImage()) continue;
                    mainVariable = this.variable2mainVariable.get(this.node2variable.get(mapping.getOrigin()));
                }
            }
            this.variable2mainVariable.put(var, mainVariable);
        }
        for (Node node : g.getNodes()) {
            this.createConstraints(node);
        }
        this.graph2variables.put(g, variables);
        this.createVariables(g.getFormula());
    }

    private void createVariables(Formula formula) {
        if (formula instanceof BinaryFormula) {
            this.createVariables(((BinaryFormula)formula).getLeft());
            this.createVariables(((BinaryFormula)formula).getRight());
        } else if (formula instanceof UnaryFormula) {
            this.createVariables(((UnaryFormula)formula).getChild());
        } else if (formula instanceof NestedCondition) {
            NestedCondition nc = (NestedCondition)formula;
            this.createVariables(nc.getConclusion(), (Collection<Mapping>)nc.getMappings());
        }
    }

    private void createConstraints(Node node) {
        Constraint constraint;
        Variable target;
        Variable var = this.node2variable.get(node);
        UnaryConstraint userConstraint = this.engine.createUserConstraints(node);
        if (userConstraint != null) {
            var.userConstraints.add(userConstraint);
        }
        for (Edge edge : node.getOutgoing()) {
            target = this.node2variable.get(edge.getTarget());
            String index = edge.getIndex();
            if (index != null && index.length() > 0) {
                if (this.rule.getParameter(index) != null) {
                    constraint = new ReferenceConstraint(target, edge.getType(), index, false);
                    var.requiresFinalCheck = true;
                } else {
                    try {
                        Number constant = (Number)this.engine.getScriptEngine().eval(index);
                        constraint = new ReferenceConstraint(target, edge.getType(), constant, true);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Error evaluating index expression: " + index);
                    }
                }
            } else {
                constraint = new ReferenceConstraint(target, edge.getType(), null, true);
            }
            var.referenceConstraints.add((ReferenceConstraint)constraint);
            BinaryConstraint binaryUserConstraint = this.engine.createUserConstraints(edge);
            if (binaryUserConstraint == null) continue;
            var.binaryUserConstraints.put((ReferenceConstraint)constraint, binaryUserConstraint);
        }
        for (Edge edge : node.getIncoming()) {
            if (edge.getType().isContainment()) {
                target = this.node2variable.get(edge.getSource());
                constraint = new ContainmentConstraint(target);
                var.containmentConstraints.add((ContainmentConstraint)constraint);
                continue;
            }
            if (edge.getType().getEOpposite() == null) continue;
            target = this.node2variable.get(edge.getSource());
            constraint = new ReferenceConstraint(target, edge.getType().getEOpposite(), null, true);
            var.referenceConstraints.add((ReferenceConstraint)constraint);
        }
        for (Attribute attribute : node.getAttributes()) {
            String value = attribute.getValue();
            if (this.rule.getParameter(value) != null) {
                constraint = new AttributeConstraint(attribute.getType(), value, false);
            } else {
                Object constant = this.engine.evalAttributeExpression(attribute, this.rule);
                constraint = new AttributeConstraint(attribute.getType(), constant, true);
            }
            var.attributeConstraints.add((AttributeConstraint)constraint);
            UnaryConstraint unaryUserConstraint = this.engine.createUserConstraints(attribute);
            if (unaryUserConstraint == null) continue;
            var.attributeUserConstraints.put((AttributeConstraint)constraint, unaryUserConstraint);
        }
        if (node.getGraph() == this.rule.getLhs() && !this.rule.getLhs().getPACs().isEmpty()) {
            for (Node target2 : node.getGraph().getNodes()) {
                if (node == target2) continue;
                for (Map.Entry entry : PathFinder.findReferencePaths((Node)node, (Node)target2, (boolean)true, (boolean)true).entrySet()) {
                    Variable targetVar = this.node2variable.get(target2);
                    PathConstraint constraint2 = new PathConstraint(targetVar, (List)entry.getKey(), (Integer)entry.getValue());
                    var.pathConstraints.add(constraint2);
                }
            }
        }
    }

    private void createDanglingConstraints(Node node) {
        Variable var = this.node2variable.get(node);
        DanglingConstraint constraint = new DanglingConstraint(this.getEdgeCounts(node, false), this.getEdgeCounts(node, true));
        var.danglingConstraints.add(constraint);
    }

    private Map<EReference, Integer> getEdgeCounts(Node node, boolean incoming) {
        EList oppositeEdges;
        EList edges = incoming ? node.getIncoming() : node.getOutgoing();
        EList eList = oppositeEdges = incoming ? node.getOutgoing() : node.getIncoming();
        if (edges.size() == 0) {
            return null;
        }
        HashMap<EReference, Integer> edgeCount = new HashMap<EReference, Integer>();
        for (Edge edge : edges) {
            EReference type = edge.getType();
            Integer count = (Integer)edgeCount.get(type);
            count = count == null ? ONE : Integer.valueOf(count + 1);
            edgeCount.put(type, count);
        }
        for (Edge edge : oppositeEdges) {
            Integer count;
            Node remoteNode;
            if (edge.getType().getEOpposite() == null) continue;
            EReference oppType = edge.getType().getEOpposite();
            if (incoming) {
                remoteNode = edge.getTarget();
                if (remoteNode.getOutgoing(oppType, node) != null) continue;
                count = (Integer)edgeCount.get(oppType);
                count = count == null ? ONE : Integer.valueOf(count + 1);
                edgeCount.put(oppType, count);
                continue;
            }
            remoteNode = edge.getSource();
            if (node.getOutgoing(oppType, remoteNode) != null) continue;
            count = (Integer)edgeCount.get(oppType);
            count = count == null ? ONE : Integer.valueOf(count + 1);
            edgeCount.put(oppType, count);
        }
        return edgeCount;
    }

    public Node getVariableForNode(Variable variable) {
        return this.variable2node.get(variable);
    }

    public Collection<Variable> getDependendVariables(Variable mainVariable) {
        HashSet<Variable> dependendVariables = new HashSet<Variable>();
        for (Variable var : this.variable2mainVariable.keySet()) {
            if (this.variable2mainVariable.get(var) != mainVariable) continue;
            dependendVariables.add(var);
        }
        return dependendVariables;
    }

    public Collection<Variable> getMainVariables() {
        return this.mainVariables;
    }

    public Map<Graph, List<Variable>> getGraph2variables() {
        return this.graph2variables;
    }

    public Map<Node, Variable> getNode2variable() {
        return this.node2variable;
    }
}

