/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.cons.AtomApplConstraint;
import agg.cons.Evaluable;
import java.util.Vector;

public class EvalSet
implements Evaluable {
    private Vector<Object> set;
    private int old_tick;
    private boolean old_val;
    private boolean negation;

    public EvalSet() {
        this(null);
    }

    public EvalSet(Vector<Object> s) {
        this.setSet(s);
        this.old_tick = -1;
        this.old_val = false;
    }

    public void setSet(Vector<Object> s) {
        this.set = s == null ? new Vector() : s;
    }

    public Vector<Object> getSet() {
        return this.set;
    }

    @Override
    public boolean eval(Object o) {
        return this.eval(o, -1);
    }

    @Override
    public boolean eval(Object o, int tick) {
        if (tick != -1 && tick == this.old_tick) {
            return this.old_val;
        }
        this.old_tick = tick;
        this.old_val = false;
        boolean result = true;
        int i = 0;
        while (i < this.set.size()) {
            Evaluable e = (Evaluable)this.set.get(i);
            result = ((AtomApplConstraint)e).eval(o, tick);
            if (!result) {
                return false;
            }
            ++i;
        }
        this.old_val = true;
        return true;
    }

    @Override
    public boolean eval(Object o, boolean negate) {
        return this.eval(o, -1, negate);
    }

    @Override
    public boolean eval(Object o, int tick, boolean negate) {
        if (tick != -1 && tick == this.old_tick) {
            return this.old_val;
        }
        this.old_tick = tick;
        this.old_val = false;
        boolean result = true;
        int i = 0;
        while (i < this.set.size()) {
            Evaluable e = (Evaluable)this.set.get(i);
            result = ((AtomApplConstraint)e).eval(o, tick, negate);
            if (!result) {
                return false;
            }
            ++i;
        }
        this.old_val = true;
        return true;
    }

    public String getAsString() {
        return new String("");
    }

    public void setNegation(boolean b) {
        this.negation = b;
    }

    public boolean getNegation() {
        return this.negation;
    }

    @Override
    public boolean evalForall(Object o, int tick) {
        return false;
    }

    public String getName() {
        return "EvalSet";
    }
}

