/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.gui.AGGAppl;
import agg.gui.editor.EditorConstants;
import agg.gui.editor.GraGraEditor;
import agg.gui.editor.GraphEditor;
import agg.gui.editor.GraphPanel;
import agg.gui.editor.RuleEditor;
import agg.gui.treeview.dialog.TypeCardinalityDialog;
import agg.gui.treeview.nodedata.GraGraTextualComment;
import agg.layout.evolutionary.EvolutionaryGraphLayout;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.Node;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class EditPopupMenu
extends JPopupMenu {
    JFrame applFrame;
    private JMenuItem mi;
    private final JMenuItem miDelete;
    private final JMenuItem miMap;
    private final JMenuItem miUnmap;
    private final JMenuItem miStraighten;
    private final JMenuItem miVisibility;
    private final JMenuItem miAddIdenticToRule;
    private final JMenuItem miAddIdenticToNAC;
    private final JMenuItem miAddIdenticToPAC;
    private final JMenuItem miAddIdenticToGAC;
    private final JMenuItem miMultiplicity;
    private final JMenuItem miSetParent;
    private final JMenuItem miUnsetParent;
    private final JMenuItem miComment;
    private final JMenuItem miObjName;
    private JMenu deleteMenu;
    private JMenu addIdentic;
    private JMenu layout;
    private JCheckBoxMenuItem miAbstract;
    private JCheckBoxMenuItem miFrozen;
    boolean mapping = false;
    GraGraEditor editor;
    RuleEditor ruleEditor;
    GraphEditor graphEditor;
    GraphPanel gp;
    EdGraphObject ego;
    int xPos;
    int yPos;
    private TypeCardinalityDialog multiplicity;
    private boolean useDeleteMenu = false;
    EvolutionaryGraphLayout layouter;
    Point location;

    public EditPopupMenu() {
        super("Operations");
        this.setBorderPainted(true);
        this.deleteMenu = this.createDeleteMenu();
        this.useDeleteMenu = false;
        this.mi = this.add(new JMenuItem("      Operations"));
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Attributes ..."));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                if (EditPopupMenu.this.ruleEditor == null) {
                    EditPopupMenu.this.editor.setAttrEditorOnTopForGraphObject(EditPopupMenu.this.ego);
                } else {
                    EditPopupMenu.this.editor.setAttrEditorOnBottomForGraphObject(EditPopupMenu.this.ego);
                }
                EditPopupMenu.this.ego.setWeakselected(true);
            }
        });
        this.miObjName = new JMenuItem("Object Name");
        this.add(this.miObjName);
        this.miObjName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EditPopupMenu.this.setObjectName(EditPopupMenu.this.ego);
            }
        });
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Copy"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EditPopupMenu.this.gp.setLastEditMode(EditPopupMenu.this.gp.getEditMode());
                EditPopupMenu.this.gp.setLastEditCursor(EditPopupMenu.this.gp.getEditCursor());
                EditPopupMenu.this.gp.getGraph().eraseSelected(EditPopupMenu.this.gp.getCanvas().getGraphics(), true);
                EditPopupMenu.this.gp.getGraph().deselectAll();
                EditPopupMenu.this.gp.getGraph().select(EditPopupMenu.this.xPos, EditPopupMenu.this.yPos);
                EditPopupMenu.this.gp.getGraph().drawSelected(EditPopupMenu.this.gp.getCanvas().getGraphics());
                if (EditPopupMenu.this.ego.isNode()) {
                    EditPopupMenu.this.editor.copyProc();
                } else {
                    EditPopupMenu.this.gp.setEditMode(151);
                    if (EditPopupMenu.this.editor != null) {
                        EditPopupMenu.this.editor.setMsg("To place a copy of an edge click on a source and a target node of the same panel.");
                    }
                }
                AGGAppl.getInstance().setCursor(new Cursor(1));
            }
        });
        this.mi = this.add(new JMenuItem("Select"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getGraph() == null || EditPopupMenu.this.ego == null) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EditPopupMenu.this.ego = EditPopupMenu.this.gp.select(EditPopupMenu.this.xPos, EditPopupMenu.this.yPos);
                if (EditPopupMenu.this.ego.isNode()) {
                    EditPopupMenu.this.gp.getGraph().drawNode(EditPopupMenu.this.gp.getCanvas().getGraphics(), (EdNode)EditPopupMenu.this.ego);
                    EditPopupMenu.this.gp.getCanvas().setPickedPoint(EditPopupMenu.this.xPos, EditPopupMenu.this.yPos);
                } else {
                    EditPopupMenu.this.gp.getGraph().drawArc(EditPopupMenu.this.gp.getCanvas().getGraphics(), (EdArc)EditPopupMenu.this.ego);
                }
                if (EditPopupMenu.this.editor != null && EditPopupMenu.this.editor.getEditMode() != 12) {
                    EditPopupMenu.this.editor.forwardModeCommand(EditorConstants.getModeOfID(12));
                    EditPopupMenu.this.editor.setEditMode(12);
                    EditPopupMenu.this.editor.resetSelectEditMode();
                }
            }
        });
        this.mi = this.add(new JMenuItem("Select All"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getGraph() == null) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EditPopupMenu.this.gp.selectAll();
                if (EditPopupMenu.this.editor != null && EditPopupMenu.this.editor.getEditMode() != 12) {
                    EditPopupMenu.this.editor.resetSelectEditMode();
                }
            }
        });
        this.addSeparator();
        this.miDelete = this.createDeleteItem();
        this.deleteMenu = this.createDeleteMenu();
        this.add(this.miDelete);
        if (this.useDeleteMenu) {
            this.add(this.deleteMenu);
        }
        this.addSeparator();
        this.miStraighten = this.add(new JMenuItem("Straighten"));
        this.miStraighten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EditPopupMenu.this.gp.getGraph().straightArc(EditPopupMenu.this.ego);
                EditPopupMenu.this.gp.updateGraphics();
            }
        });
        this.miVisibility = this.add(new JMenuItem("Hide Objects of Type"));
        this.miVisibility.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                if (((JMenuItem)e.getSource()).getText().indexOf("Hide") == 0) {
                    EditPopupMenu.this.gp.getGraph().setVisibilityOfGraphObjectsOfType(EditPopupMenu.this.ego, false);
                } else if (((JMenuItem)e.getSource()).getText().indexOf("Show") == 0) {
                    EditPopupMenu.this.gp.getGraph().setVisibilityOfGraphObjectsOfType(EditPopupMenu.this.ego, true);
                }
                EditPopupMenu.this.gp.updateGraphics();
            }
        });
        this.layout = new JMenu("Graph Layout");
        this.add(this.layout);
        this.miFrozen = (JCheckBoxMenuItem)this.layout.add(new JCheckBoxMenuItem("Static Position"));
        this.miFrozen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                if (EditPopupMenu.this.ego instanceof EdNode) {
                    if (EditPopupMenu.this.ego.getBasisObject().getContext().isTypeGraph()) {
                        if (EditPopupMenu.this.layouter != null && EditPopupMenu.this.editor != null) {
                            EditPopupMenu.this.editor.getGraGra().createLayoutPattern("Freezing", "node", EditPopupMenu.this.ego.getBasisObject().getType(), ((JCheckBoxMenuItem)e.getSource()).isSelected());
                        }
                    } else if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                        ((EdNode)EditPopupMenu.this.ego).getLNode().setFrozen(true);
                    } else {
                        ((EdNode)EditPopupMenu.this.ego).getLNode().setFrozen(false);
                    }
                }
            }
        });
        this.addSeparator();
        this.addIdentic = new JMenu("Add Identic To");
        this.add(this.addIdentic);
        this.miAddIdenticToRule = this.mi = this.addIdentic.add(new JMenuItem("Rule RHS"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                if (EditPopupMenu.this.ruleEditor != null && EditPopupMenu.this.gp == EditPopupMenu.this.ruleEditor.getLeftPanel()) {
                    EdGraphObject img = null;
                    if (EditPopupMenu.this.ego.isNode()) {
                        img = EditPopupMenu.this.ruleEditor.getRule().addIdentic(EditPopupMenu.this.ego);
                        if (img != null) {
                            EditPopupMenu.this.ruleEditor.getRule().updateRule();
                            EditPopupMenu.this.ruleEditor.updateGraphics();
                        }
                    } else {
                        Node src = (Node)EditPopupMenu.this.ruleEditor.getRule().getBasisRule().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getSource());
                        Node tar = (Node)EditPopupMenu.this.ruleEditor.getRule().getBasisRule().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getTarget());
                        Object[] options = new Object[]{"Yes", "No"};
                        if (src == null && tar != null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The source node is not defined." + System.getProperty("line.separator") + "Should it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdentic(((EdArc)EditPopupMenu.this.ego).getSource());
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdentic(EditPopupMenu.this.ego);
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updateRule();
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else if (src != null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The target node is not defined." + System.getProperty("line.separator") + "Should it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdentic(((EdArc)EditPopupMenu.this.ego).getTarget());
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdentic(EditPopupMenu.this.ego);
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updateRule();
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else if (src == null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The source and target nodes are not defined." + System.getProperty("line.separator") + "Should they be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdentic(((EdArc)EditPopupMenu.this.ego).getSource());
                                if (((EdArc)EditPopupMenu.this.ego).getSource() != ((EdArc)EditPopupMenu.this.ego).getTarget() && img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdentic(((EdArc)EditPopupMenu.this.ego).getTarget());
                                }
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdentic(EditPopupMenu.this.ego);
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updateRule();
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else {
                            img = EditPopupMenu.this.ruleEditor.getRule().addIdentic(EditPopupMenu.this.ego);
                            EditPopupMenu.this.ruleEditor.getRule().updateRule();
                            EditPopupMenu.this.ruleEditor.updateGraphics();
                        }
                    }
                }
            }
        });
        this.miAddIdenticToNAC = this.mi = this.addIdentic.add(new JMenuItem("NAC"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                if (EditPopupMenu.this.ruleEditor != null && EditPopupMenu.this.gp == EditPopupMenu.this.ruleEditor.getLeftPanel()) {
                    if (EditPopupMenu.this.ruleEditor.getNAC() == null) {
                        JOptionPane.showMessageDialog(null, "Cannot create an identic object!" + System.getProperty("line.separator") + "Please create and open an empty NAC graph first.", "Identic Node/Edge", 2);
                        return;
                    }
                    EdGraphObject img = null;
                    if (EditPopupMenu.this.ego.isNode()) {
                        img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getNAC());
                        if (img != null) {
                            EditPopupMenu.this.ruleEditor.getRule().updateNAC(EditPopupMenu.this.ruleEditor.getNAC());
                            EditPopupMenu.this.ruleEditor.updateGraphics();
                        }
                    } else {
                        Node src = (Node)EditPopupMenu.this.ruleEditor.getNAC().getMorphism().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getSource());
                        Node tar = (Node)EditPopupMenu.this.ruleEditor.getNAC().getMorphism().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getTarget());
                        Object[] options = new Object[]{"Yes", "No"};
                        if (src == null && tar != null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The source node is not defined." + System.getProperty("line.separator") + "Should it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(((EdArc)EditPopupMenu.this.ego).getSource(), EditPopupMenu.this.ruleEditor.getNAC());
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getNAC());
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updateNAC(EditPopupMenu.this.ruleEditor.getNAC());
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else if (src != null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The target node is not defined." + System.getProperty("line.separator") + "Should it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(((EdArc)EditPopupMenu.this.ego).getTarget(), EditPopupMenu.this.ruleEditor.getNAC());
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getNAC());
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updateNAC(EditPopupMenu.this.ruleEditor.getNAC());
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else if (src == null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The source and target nodes are not defined." + System.getProperty("line.separator") + "Should they be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(((EdArc)EditPopupMenu.this.ego).getSource(), EditPopupMenu.this.ruleEditor.getNAC());
                                if (((EdArc)EditPopupMenu.this.ego).getSource() != ((EdArc)EditPopupMenu.this.ego).getTarget() && img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(((EdArc)EditPopupMenu.this.ego).getTarget(), EditPopupMenu.this.ruleEditor.getNAC());
                                }
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getNAC());
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updateNAC(EditPopupMenu.this.ruleEditor.getNAC());
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else {
                            img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getNAC());
                            if (img != null) {
                                EditPopupMenu.this.ruleEditor.getRule().updateNAC(EditPopupMenu.this.ruleEditor.getNAC());
                                EditPopupMenu.this.ruleEditor.updateGraphics();
                            }
                        }
                    }
                }
            }
        });
        this.miAddIdenticToPAC = this.mi = this.addIdentic.add(new JMenuItem("PAC"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                if (EditPopupMenu.this.ruleEditor != null && EditPopupMenu.this.gp == EditPopupMenu.this.ruleEditor.getLeftPanel()) {
                    if (EditPopupMenu.this.ruleEditor.getPAC() == null) {
                        JOptionPane.showMessageDialog(null, "Cannot create an identic object!" + System.getProperty("line.separator") + "Please create and open an empty PAC graph first.", "Identic Node/Edge", 2);
                        return;
                    }
                    EdGraphObject img = null;
                    if (EditPopupMenu.this.ego.isNode()) {
                        img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToPAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getPAC());
                        if (img != null) {
                            EditPopupMenu.this.ruleEditor.getRule().updatePAC(EditPopupMenu.this.ruleEditor.getPAC());
                            EditPopupMenu.this.ruleEditor.updateGraphics();
                        }
                    } else {
                        Node src = (Node)EditPopupMenu.this.ruleEditor.getPAC().getMorphism().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getSource());
                        Node tar = (Node)EditPopupMenu.this.ruleEditor.getPAC().getMorphism().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getTarget());
                        Object[] options = new Object[]{"Yes", "No"};
                        if (src == null && tar != null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The source node is not defined." + System.getProperty("line.separator") + "Should it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToPAC(((EdArc)EditPopupMenu.this.ego).getSource(), EditPopupMenu.this.ruleEditor.getPAC());
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToPAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getPAC());
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updatePAC(EditPopupMenu.this.ruleEditor.getPAC());
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else if (src != null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The target node is not defined." + System.getProperty("line.separator") + "Should it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToPAC(((EdArc)EditPopupMenu.this.ego).getTarget(), EditPopupMenu.this.ruleEditor.getPAC());
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToPAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getPAC());
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updatePAC(EditPopupMenu.this.ruleEditor.getPAC());
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else if (src == null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The source and target nodes are not defined." + System.getProperty("line.separator") + "Should they be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToPAC(((EdArc)EditPopupMenu.this.ego).getSource(), EditPopupMenu.this.ruleEditor.getPAC());
                                if (((EdArc)EditPopupMenu.this.ego).getSource() != ((EdArc)EditPopupMenu.this.ego).getTarget() && img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToPAC(((EdArc)EditPopupMenu.this.ego).getTarget(), EditPopupMenu.this.ruleEditor.getPAC());
                                }
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToPAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getPAC());
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updatePAC(EditPopupMenu.this.ruleEditor.getPAC());
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else {
                            img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToPAC(EditPopupMenu.this.ego, EditPopupMenu.this.ruleEditor.getPAC());
                            if (img != null) {
                                EditPopupMenu.this.ruleEditor.getRule().updatePAC(EditPopupMenu.this.ruleEditor.getPAC());
                                EditPopupMenu.this.ruleEditor.updateGraphics();
                            }
                        }
                    }
                }
            }
        });
        this.miAddIdenticToGAC = this.mi = this.addIdentic.add(new JMenuItem("General AC"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                if (EditPopupMenu.this.ruleEditor != null && EditPopupMenu.this.gp == EditPopupMenu.this.ruleEditor.getLeftPanel()) {
                    if (EditPopupMenu.this.ruleEditor.getNestedAC() == null) {
                        JOptionPane.showMessageDialog(null, "Cannot create an identic object!" + System.getProperty("line.separator") + "Please create and open an empty General AC graph first.", "Identic Node/Edge", 2);
                        return;
                    }
                    EdGraphObject img = null;
                    if (EditPopupMenu.this.ego.isNode()) {
                        img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNestedAC(EditPopupMenu.this.ego, (EdPAC)EditPopupMenu.this.ruleEditor.getNestedAC());
                        if (img != null) {
                            EditPopupMenu.this.ruleEditor.getRule().updateNestedAC(EditPopupMenu.this.ruleEditor.getNestedAC());
                            EditPopupMenu.this.ruleEditor.updateGraphics();
                        }
                    } else {
                        Node src = (Node)EditPopupMenu.this.ruleEditor.getNestedAC().getMorphism().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getSource());
                        Node tar = (Node)EditPopupMenu.this.ruleEditor.getNestedAC().getMorphism().getImage(((Arc)EditPopupMenu.this.ego.getBasisObject()).getTarget());
                        Object[] options = new Object[]{"Yes", "No"};
                        if (src == null && tar != null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The source node is not defined." + System.getProperty("line.separator") + "Should it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNestedAC(((EdArc)EditPopupMenu.this.ego).getSource(), (EdPAC)EditPopupMenu.this.ruleEditor.getNestedAC());
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNestedAC(EditPopupMenu.this.ego, (EdPAC)EditPopupMenu.this.ruleEditor.getNestedAC());
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updateNestedAC(EditPopupMenu.this.ruleEditor.getNestedAC());
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else if (src != null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The target node is not defined." + System.getProperty("line.separator") + "Should it be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNestedAC(((EdArc)EditPopupMenu.this.ego).getTarget(), (EdPAC)EditPopupMenu.this.ruleEditor.getNestedAC());
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNestedAC(EditPopupMenu.this.ego, (EdPAC)EditPopupMenu.this.ruleEditor.getNestedAC());
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updateNestedAC(EditPopupMenu.this.ruleEditor.getNestedAC());
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else if (src == null && tar == null) {
                            int answer = JOptionPane.showOptionDialog(null, "Cannot create an identic edge!" + System.getProperty("line.separator") + "The source and target nodes are not defined." + System.getProperty("line.separator") + "Should they be created now?", "Identic Edge", -1, 3, null, options, options[0]);
                            if (answer == 0) {
                                img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNestedAC(((EdArc)EditPopupMenu.this.ego).getSource(), (EdPAC)EditPopupMenu.this.ruleEditor.getNestedAC());
                                if (((EdArc)EditPopupMenu.this.ego).getSource() != ((EdArc)EditPopupMenu.this.ego).getTarget() && img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNestedAC(((EdArc)EditPopupMenu.this.ego).getTarget(), (EdPAC)EditPopupMenu.this.ruleEditor.getNestedAC());
                                }
                                if (img != null) {
                                    img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNestedAC(EditPopupMenu.this.ego, (EdPAC)EditPopupMenu.this.ruleEditor.getNestedAC());
                                }
                                if (img != null) {
                                    EditPopupMenu.this.ruleEditor.getRule().updateNestedAC(EditPopupMenu.this.ruleEditor.getNestedAC());
                                    EditPopupMenu.this.ruleEditor.updateGraphics();
                                }
                            }
                        } else {
                            img = EditPopupMenu.this.ruleEditor.getRule().addIdenticToNestedAC(EditPopupMenu.this.ego, (EdPAC)EditPopupMenu.this.ruleEditor.getNestedAC());
                            if (img != null) {
                                EditPopupMenu.this.ruleEditor.getRule().updateNestedAC(EditPopupMenu.this.ruleEditor.getNestedAC());
                                EditPopupMenu.this.ruleEditor.updateGraphics();
                            }
                        }
                    }
                }
            }
        });
        this.miMap = this.mi = this.add(new JMenuItem("Map"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getGraph() == null || EditPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                EditPopupMenu.this.mapping = true;
                EditPopupMenu.this.setLastEditModeBeforMapping(EditPopupMenu.this.gp);
                if (EditPopupMenu.this.editor != null) {
                    EditPopupMenu.this.editor.getGraphEditor().setEditMode(115);
                    EditPopupMenu.this.editor.getRuleEditor().setEditMode(115);
                    EditPopupMenu.this.editor.getRuleEditor().setObjMapping(true);
                    EditPopupMenu.this.editor.setMsg("Click on a target object you want to map or click on the background to break the mapping.");
                } else if (EditPopupMenu.this.ruleEditor != null) {
                    EditPopupMenu.this.ruleEditor.setEditMode(115);
                    EditPopupMenu.this.ruleEditor.setObjMapping(true);
                    EditPopupMenu.this.ruleEditor.setMsg("Click on a target object you want to map or click on the background to break the mapping");
                }
                EditPopupMenu.this.ego.setWeakselected(true);
                EditPopupMenu.this.gp.updateGraphics();
            }
        });
        this.miUnmap = this.mi = this.add(new JMenuItem("Unmap"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getGraph() == null || EditPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                EditPopupMenu.this.unmapGraphObject(false);
            }
        });
        this.addSeparator();
        this.miMultiplicity = this.mi = this.add(new JMenuItem("Multiplicity"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPopupMenu.this.setMultiplicityOfType();
                if (EditPopupMenu.this.graphEditor != null) {
                    EditPopupMenu.this.graphEditor.getGraph().update();
                    EditPopupMenu.this.graphEditor.getGraphPanel().updateGraphics();
                }
            }
        });
        this.miSetParent = this.mi = this.add(new JMenuItem("Set Parent"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node bNode;
                Graph bGraph;
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditPopupMenu.this.ego instanceof EdNode && (bGraph = (bNode = EditPopupMenu.this.ego.getNode().getBasisNode()).getContext()).isTypeGraph() && EditPopupMenu.this.editor != null) {
                    EditPopupMenu.this.editor.getGraphEditor().setEditMode(1201);
                    EditPopupMenu.this.ego.setWeakselected(true);
                    EditPopupMenu.this.gp.getCanvas().getGraph().drawNode(EditPopupMenu.this.gp.getCanvas().getGraphics(), (EdNode)EditPopupMenu.this.ego);
                    EditPopupMenu.this.editor.setMsg("Click on a node to add inheritance relation.");
                }
            }
        });
        this.miUnsetParent = this.mi = this.add(new JMenuItem("Unset Parent"));
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node bNode;
                Graph bGraph;
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getEditMode() == 9 || !EditPopupMenu.this.gp.getGraph().isEditable()) {
                    return;
                }
                if (EditPopupMenu.this.ego instanceof EdNode && (bGraph = (bNode = EditPopupMenu.this.ego.getNode().getBasisNode()).getContext()).isTypeGraph() && EditPopupMenu.this.editor != null) {
                    if (EditPopupMenu.this.graphEditor.getGraph().getBasisGraph().getTypeSet().getLevelOfTypeGraphCheck() != 0 && EditPopupMenu.this.graphEditor.getGraph().getTypeSet().isTypeUsed(EditPopupMenu.this.ego.getType())) {
                        JOptionPane.showMessageDialog(EditPopupMenu.this.applFrame, "Cannot unset inheritance relation.\nPlease disable the type graph first.", "Unset Parent", 0);
                        return;
                    }
                    if (bNode.getType().getParents().size() == 1) {
                        EditPopupMenu.this.graphEditor.getGraph().addChangedParentToUndo(EditPopupMenu.this.ego);
                        EditPopupMenu.this.gp.getCanvas().updateUndoButton();
                        EditPopupMenu.this.gp.getCanvas().performDeleteInheritanceRel((EdNode)EditPopupMenu.this.ego);
                        EditPopupMenu.this.graphEditor.getGraph().undoManagerEndEdit();
                        EditPopupMenu.this.graphEditor.getGraph().updateGraph();
                        EditPopupMenu.this.graphEditor.getGraphPanel().updateGraphics();
                    } else {
                        EditPopupMenu.this.editor.getGraphEditor().setEditMode(1202);
                        EditPopupMenu.this.editor.setMsg("Click on a parent node to remove inheritance relation.");
                    }
                }
            }
        });
        this.miAbstract = (JCheckBoxMenuItem)this.add(new JCheckBoxMenuItem("Abstract"));
        this.miAbstract.setSelected(false);
        this.miAbstract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditPopupMenu.this.ego instanceof EdNode) {
                    EditPopupMenu.this.gp.getGraph().addChangedTypeToUndo(EditPopupMenu.this.ego);
                    EditPopupMenu.this.gp.getCanvas().updateUndoButton();
                    if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                        EditPopupMenu.this.ego.getBasisObject().getType().setAbstract(true);
                    } else {
                        EditPopupMenu.this.ego.getBasisObject().getType().setAbstract(false);
                    }
                    if (EditPopupMenu.this.editor != null) {
                        EditPopupMenu.this.editor.updateGraphics();
                    } else {
                        EditPopupMenu.this.gp.updateGraphics();
                    }
                    EditPopupMenu.this.gp.getGraph().undoManagerEndEdit();
                }
            }
        });
        this.addSeparator();
        this.miComment = this.mi = this.add(new JMenuItem("Textual Comments"));
        this.mi.setActionCommand("commentType");
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditPopupMenu.this.gp == null || EditPopupMenu.this.gp.getEditMode() == 9) {
                    return;
                }
                if (EditPopupMenu.this.gp.getGraph().isTypeGraph()) {
                    String oldcomment = EditPopupMenu.this.ego.getType().getBasisType().getTextualComment();
                    EditPopupMenu.this.gp.getGraph().addChangedTypeToUndo(EditPopupMenu.this.ego);
                    Point p = EditPopupMenu.this.applFrame.getLocation();
                    GraGraTextualComment comments = new GraGraTextualComment(EditPopupMenu.this.applFrame, p.x + EditPopupMenu.this.location.x, p.y + EditPopupMenu.this.location.y, EditPopupMenu.this.ego.getType().getBasisType());
                    comments.setModal(true);
                    comments.setVisible(true);
                    String newcomment = EditPopupMenu.this.ego.getType().getBasisType().getTextualComment();
                    if (oldcomment.equals(newcomment)) {
                        EditPopupMenu.this.gp.getGraph().undoManagerLastEditDie();
                    } else {
                        EditPopupMenu.this.gp.getGraph().undoManagerEndEdit();
                    }
                    EditPopupMenu.this.gp.getCanvas().updateUndoButton();
                }
            }
        });
        this.pack();
        this.setBorderPainted(true);
        EditPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    public void showMe(Component comp, int x, int y) {
        if (this.editor != null && this.editor.getRuleEditor().getRule() == null) {
            this.setUnmapEnabled(false);
        } else if (this.gp.getGraph() != null && this.gp.getGraph().isTypeGraph()) {
            this.setUnmapEnabled(false);
        }
        if (this.useDeleteMenu) {
            int indx = this.getComponentIndex(this.deleteMenu);
            if (indx == -1 && (indx = this.getComponentIndex(this.miDelete)) != -1) {
                this.add((Component)this.deleteMenu, indx + 1);
            }
        } else {
            int indx = this.getComponentIndex(this.deleteMenu);
            if (indx != -1) {
                this.remove(indx);
            }
        }
        this.show(comp, x, y);
    }

    boolean canDo() {
        return this.gp != null && this.gp.getEditMode() != 9 && this.gp.getGraph() != null && this.ego != null;
    }

    void doUpdateAfterDelete() {
        if (this.gp.isMappedObjDeleted()) {
            this.gp.setMappedObjDeleted(false);
            if (this.editor != null) {
                this.editor.getRuleEditor().getRule().update();
                this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                this.editor.getRuleEditor().getRightPanel().updateGraphics();
                this.editor.getRuleEditor().getLeftCondPanel().updateGraphics();
                this.editor.getGraphEditor().getGraph().update();
                this.editor.getGraphEditor().getGraphPanel().updateGraphics();
            } else if (this.ruleEditor != null) {
                this.ruleEditor.getRule().update();
                this.ruleEditor.getLeftPanel().updateGraphics();
                this.ruleEditor.getRightPanel().updateGraphics();
                this.ruleEditor.getLeftCondPanel().updateGraphics();
                if (this.graphEditor != null) {
                    this.graphEditor.getGraph().update();
                    this.graphEditor.getGraphPanel().updateGraphics();
                }
            } else if (this.graphEditor != null) {
                this.graphEditor.getGraph().update();
                this.graphEditor.getGraphPanel().updateGraphics();
            }
        } else {
            this.gp.getGraph().update();
            this.gp.updateGraphicsAfterDelete();
        }
    }

    void showMessageDialog(List<String> failed, boolean node) {
        if (failed == null) {
            return;
        }
        if (!failed.isEmpty()) {
            String str = "Cannot delete objects of this type from  \n";
            int i = 0;
            while (i < failed.size()) {
                String s = "\t" + failed.get(i) + "\n";
                str = String.valueOf(str) + s;
                ++i;
            }
            JOptionPane.showMessageDialog(this.applFrame, str);
        }
    }

    private JMenuItem createDeleteItem() {
        JMenuItem m = this.add(new JMenuItem("Delete"));
        m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                if (!EditPopupMenu.this.ego.getMorphismMark().equals("")) {
                    EditPopupMenu.this.gp.setMappedObjDeleted(true);
                    EditPopupMenu.this.unmapGraphObject(true);
                }
                EditPopupMenu.this.gp.deleteObj(EditPopupMenu.this.ego);
                EditPopupMenu.this.doUpdateAfterDelete();
                EditPopupMenu.this.ego = null;
            }
        });
        return m;
    }

    private JMenu createDeleteMenu() {
        JMenu m = new JMenu("Delete Objects of Type");
        JMenuItem jmi = m.add(new JMenuItem("Delete All Objects"));
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                boolean ok = false;
                boolean addToUndo = true;
                if (!ok) {
                    List<String> failed = EditPopupMenu.this.gp.getGraph().getGraGra().deleteGraphObjectsOfType(EditPopupMenu.this.ego, false, addToUndo);
                    EditPopupMenu.this.showMessageDialog(failed, EditPopupMenu.this.ego.isNode());
                    EditPopupMenu.this.doUpdateAfterDelete();
                    EditPopupMenu.this.gp.getCanvas().updateUndoButton();
                    EditPopupMenu.this.gp.getGraph().getGraGra().update();
                    if (EditPopupMenu.this.editor != null) {
                        EditPopupMenu.this.editor.getRuleEditor().updateGraphics();
                    }
                }
            }
        });
        jmi = m.add(new JMenuItem("Delete Objects of Host Graph"));
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!EditPopupMenu.this.canDo()) {
                    return;
                }
                EditPopupMenu.this.mapping = false;
                if (!EditPopupMenu.this.gp.getGraph().getGraGra().deleteGraphObjectsOfTypeFromHostGraph(EditPopupMenu.this.ego, true)) {
                    JOptionPane.showMessageDialog(EditPopupMenu.this.applFrame, "Cannot delete objects of this type from host graph.");
                }
                EditPopupMenu.this.doUpdateAfterDelete();
                EditPopupMenu.this.gp.getCanvas().updateUndoButton();
                EditPopupMenu.this.gp.getGraph().getGraGra().getGraph().update();
            }
        });
        return m;
    }

    public void setEditor(GraGraEditor ed) {
        this.editor = ed;
        this.ruleEditor = this.editor.getRuleEditor();
        this.graphEditor = this.editor.getGraphEditor();
    }

    public void setEditor(RuleEditor re) {
        this.ruleEditor = re;
        this.graphEditor = null;
    }

    public void setEditor(GraphEditor ge) {
        this.graphEditor = ge;
        this.ruleEditor = null;
    }

    public void setGraphLayouter(EvolutionaryGraphLayout l) {
        this.layouter = l;
    }

    public EdGraphObject getPickedObj() {
        return this.ego;
    }

    public boolean isMapping() {
        return this.mapping;
    }

    public void setParentFrame(JFrame pf) {
        this.applFrame = pf;
    }

    public void setMapEnabled(boolean b) {
        this.miMap.setEnabled(b);
    }

    public void setUnmapEnabled(boolean b) {
        this.miUnmap.setEnabled(b);
    }

    public boolean invoked(GraphPanel p, int x, int y) {
        this.gp = p;
        if (this.gp.getGraph() != null) {
            if (this.gp.getCanvas().getPickedObject() != null && this.gp.getCanvas().getPickedObject().isWeakselected()) {
                this.gp.getCanvas().getPickedObject().setWeakselected(false);
                this.gp.updateGraphics();
            }
            if (!this.gp.getCanvas().isLeftPressed()) {
                this.ego = this.gp.getGraph().getPicked(x, y);
                if (this.ego == null) {
                    this.ego = this.gp.getGraph().getPickedTextOfArc(x, y, this.gp.getCanvas().getGraphics().getFontMetrics());
                }
                if (this.ego != null && this.ego.isVisible()) {
                    Arc bArc;
                    this.location = new Point(x, y);
                    if (this.ego.isArc() && (bArc = this.ego.getArc().getBasisArc()).isInheritance()) {
                        return false;
                    }
                    this.layout.setEnabled(false);
                    this.miComment.setEnabled(false);
                    if (this.ruleEditor != null) {
                        if (this.ruleEditor.getRule().getLeft() == this.gp.getGraph()) {
                            this.miAddIdenticToRule.setEnabled(true);
                        } else {
                            this.miAddIdenticToRule.setEnabled(false);
                        }
                        if (this.ruleEditor.getNAC() != null) {
                            this.miAddIdenticToNAC.setEnabled(true);
                            this.miAddIdenticToPAC.setEnabled(false);
                            this.miAddIdenticToGAC.setEnabled(false);
                        } else if (this.ruleEditor.getPAC() != null) {
                            this.miAddIdenticToNAC.setEnabled(false);
                            this.miAddIdenticToPAC.setEnabled(true);
                            this.miAddIdenticToGAC.setEnabled(false);
                        } else if (this.ruleEditor.getNestedAC() != null) {
                            this.miAddIdenticToNAC.setEnabled(false);
                            this.miAddIdenticToPAC.setEnabled(false);
                            this.miAddIdenticToGAC.setEnabled(true);
                        } else {
                            this.miAddIdenticToNAC.setEnabled(false);
                            this.miAddIdenticToPAC.setEnabled(false);
                            this.miAddIdenticToGAC.setEnabled(false);
                        }
                    }
                    if (!this.ego.getContext().isTypeGraph()) {
                        this.miVisibility.setEnabled(false);
                        this.miObjName.setEnabled(true);
                    } else {
                        this.miVisibility.setEnabled(true);
                        this.miObjName.setEnabled(false);
                        if (this.ego.isNode()) {
                            if (this.ego.getType().getBasisType().isObjectOfTypeGraphNodeVisible()) {
                                this.miVisibility.setText("Hide Objects of Type");
                            } else {
                                this.miVisibility.setText("Show Objects of Type");
                            }
                        } else if (this.ego.getType().getBasisType().isObjectOfTypeGraphArcVisible(((EdArc)this.ego).getSource().getType().getBasisType(), ((EdArc)this.ego).getTarget().getType().getBasisType())) {
                            this.miVisibility.setText("Hide Objects of Type");
                        } else {
                            this.miVisibility.setText("Show Objects of Type");
                        }
                    }
                    if (this.ego.isNode()) {
                        this.miStraighten.setEnabled(false);
                        if (this.ego.isElementOfTypeGraph()) {
                            this.miComment.setEnabled(true);
                            this.useDeleteMenu = true;
                            this.addIdentic.setEnabled(false);
                            this.miUnmap.setEnabled(false);
                            this.miMultiplicity.setEnabled(true);
                            this.miAbstract.setEnabled(true);
                            if (this.ego.getBasisObject().getType().isAbstract()) {
                                this.miAbstract.setSelected(true);
                            } else {
                                this.miAbstract.setSelected(false);
                            }
                            this.miSetParent.setEnabled(true);
                            if (!this.ego.getNode().getBasisNode().getType().getParents().isEmpty()) {
                                this.miUnsetParent.setEnabled(true);
                            } else {
                                this.miUnsetParent.setEnabled(false);
                            }
                            this.layout.setEnabled(true);
                            if (this.layouter != null) {
                                if (this.layouter.getLayoutPatternForType(this.ego.getBasisObject().getType(), "Freezing") != null) {
                                    this.miFrozen.setSelected(true);
                                } else {
                                    this.miFrozen.setSelected(false);
                                }
                            }
                        } else {
                            if (this.graphEditor != null && this.graphEditor.getGraphPanel() == this.gp) {
                                this.layout.setEnabled(true);
                            }
                            this.miFrozen.setSelected(((EdNode)this.ego).getLNode().isFrozen());
                            this.useDeleteMenu = false;
                            this.addIdentic.setEnabled(false);
                            this.miMultiplicity.setEnabled(false);
                            this.miAbstract.setEnabled(false);
                            this.miAbstract.setSelected(false);
                            this.miSetParent.setEnabled(false);
                            this.miUnsetParent.setEnabled(false);
                        }
                        if (this.ruleEditor != null && this.gp == this.ruleEditor.getLeftPanel()) {
                            this.addIdentic.setEnabled(true);
                        }
                    } else {
                        this.miStraighten.setEnabled(true);
                        this.miSetParent.setEnabled(false);
                        this.miUnsetParent.setEnabled(false);
                        this.miAbstract.setEnabled(false);
                        this.miAbstract.setSelected(false);
                        if (this.ego.isElementOfTypeGraph()) {
                            this.miComment.setEnabled(true);
                            this.useDeleteMenu = true;
                            this.addIdentic.setEnabled(false);
                            this.miUnmap.setEnabled(false);
                            this.miMultiplicity.setEnabled(true);
                        } else {
                            this.useDeleteMenu = false;
                            this.addIdentic.setEnabled(false);
                            this.miMultiplicity.setEnabled(false);
                        }
                        if (this.ruleEditor != null && this.gp == this.ruleEditor.getLeftPanel()) {
                            this.addIdentic.setEnabled(true);
                        }
                    }
                    if (!this.ego.isSelected()) {
                        this.xPos = x;
                        this.yPos = y;
                        this.requestFocusInWindow();
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    void setLastEditModeBeforMapping(GraphPanel gp) {
        if (gp.getEditMode() == 11 || gp.getEditMode() == 113 || gp.getEditMode() == 12 || gp.getEditMode() == 13 || gp.getEditMode() == 114 || gp.getEditMode() == 115 || gp.getEditMode() == 116 || gp.getEditMode() == 1201 || gp.getEditMode() == 1202 || gp.getEditMode() == 31 || gp.getEditMode() == 81 || gp.getEditMode() == 801 || gp.getEditMode() == 8010 || gp.getEditMode() == 42) {
            gp.setLastEditMode(gp.getEditMode());
            gp.setLastEditCursor(gp.getEditCursor());
        }
    }

    void setMultiplicityOfType() {
        if (this.ego != null) {
            this.gp.getGraph().addChangedMultiplicityToUndo(this.ego);
            this.multiplicity = !this.ego.isNode() ? new TypeCardinalityDialog(null, this.ego.getType().getBasisType(), ((EdArc)this.ego).getSource().getType().getBasisType(), ((EdArc)this.ego).getTarget().getType().getBasisType()) : new TypeCardinalityDialog(null, this.ego.getType().getBasisType());
            this.multiplicity.showGUI();
            if (this.editor != null) {
                if (!this.multiplicity.isChanged()) {
                    this.gp.getGraph().undoManagerLastEditDie();
                } else if (this.ego.isNode()) {
                    String errors = this.gp.getGraph().getGraGra().checkNodeTypeMultiplicity((EdNode)this.ego);
                    if (errors != null) {
                        errors = errors.replaceAll(",", ",\n");
                        JOptionPane.showMessageDialog(null, "<html><body>Please check the graph(s): \n" + errors + ".\n" + "\nMultiplicity constraint of the node type:\n" + "\"" + this.ego.getType().getBasisType().getName() + "\"  \n" + "is not satisfied.", "Checking Node Type Multiplicity", 2);
                    }
                } else {
                    String errors = this.gp.getGraph().getGraGra().checkEdgeTypeMultiplicity((EdArc)this.ego);
                    if (errors != null) {
                        errors = errors.replaceAll(",", ",\n");
                        JOptionPane.showMessageDialog(null, "<html><body>Please check the graph(s): \n" + errors + ".\n" + "\nMultiplicity constraint of the edge type:\n" + "\"" + this.ego.getType().getBasisType().getName() + "\"  \n" + "is not satisfied.", "Checking Edge Type Multiplicity", 2);
                    }
                }
            }
            this.gp.getCanvas().updateUndoButton();
            this.gp.getGraph().undoManagerEndEdit();
        }
    }

    protected void unmapGraphObject(boolean wantDeleteGraphObject) {
        boolean unmapdone = false;
        if (this.editor != null && this.editor.getRuleEditor().getRule() != null) {
            boolean isLeftRuleObj;
            EdRule rule = this.editor.getRuleEditor().getRule();
            boolean bl = isLeftRuleObj = this.ego.getContext() == rule.getLeft();
            if (this.editor.getActivePanel() == this.editor.getRuleEditor().getLeftPanel()) {
                unmapdone = this.leftPanelUnmap(this.editor.getRuleEditor(), rule, wantDeleteGraphObject);
                if (unmapdone && isLeftRuleObj && rule.getMatch() != null) {
                    this.editor.getGraphEditor().updateGraphics();
                }
            } else if (this.editor.getActivePanel() == this.editor.getRuleEditor().getRightPanel()) {
                unmapdone = this.rightPanelUnmap(this.editor.getRuleEditor(), rule, wantDeleteGraphObject);
            } else if (this.editor.getActivePanel() == this.editor.getRuleEditor().getLeftCondPanel()) {
                unmapdone = this.leftCondPanelUnmap(this.editor.getRuleEditor(), rule);
            } else if (this.editor.getActivePanel() == this.editor.getGraphEditor().getGraphPanel() && rule.getMatch() != null) {
                if (this.editor.getRuleEditor().removeMatchMapping(this.ego, false)) {
                    unmapdone = true;
                }
                if (unmapdone) {
                    this.editor.getRuleEditor().getLeftPanel().updateGraphics();
                    this.editor.getGraphEditor().getGraphPanel().updateGraphics();
                }
            }
        } else if (this.ruleEditor != null && this.ruleEditor.getRule() != null) {
            EdRule rule = this.ruleEditor.getRule();
            if (this.gp == this.ruleEditor.getLeftPanel()) {
                unmapdone = this.leftPanelUnmap(this.ruleEditor, rule, wantDeleteGraphObject);
                if (unmapdone && this.graphEditor != null) {
                    this.graphEditor.getGraphPanel().updateGraphics();
                }
            } else if (this.gp == this.ruleEditor.getRightPanel()) {
                unmapdone = this.rightPanelUnmap(this.editor.getRuleEditor(), rule, wantDeleteGraphObject);
            } else if (this.gp == this.ruleEditor.getLeftCondPanel()) {
                unmapdone = this.leftCondPanelUnmap(this.editor.getRuleEditor(), rule);
            }
        } else if (this.graphEditor != null && this.gp == this.graphEditor.getGraphPanel() && this.ruleEditor != null) {
            this.ruleEditor.getRule().removeMapping(this.ego, this.ruleEditor.getRule().getMatch());
            if (this.ruleEditor.getLeftPanel().getGraph() == this.ruleEditor.getRule().getLeft()) {
                this.ruleEditor.getLeftPanel().updateGraphics();
            }
            this.graphEditor.getGraphPanel().updateGraphics();
        }
    }

    private boolean leftPanelUnmap(RuleEditor rEditor, EdRule rule, boolean wantDelete) {
        boolean isLeftRuleObj;
        boolean unmapdone = false;
        boolean bl = isLeftRuleObj = this.ego.getContext() == rule.getLeft();
        if (wantDelete) {
            if (isLeftRuleObj) {
                if (!(rule instanceof EdAtomic) && (rEditor.removeNacMapping(this.ego) || rEditor.removePacMapping(this.ego) || rEditor.removeNestedACMapping(this.ego))) {
                    unmapdone = true;
                }
                if (rEditor.removeRuleMapping(this.ego, true)) {
                    unmapdone = true;
                }
            } else if (rEditor.getNestedAC() != null) {
                if (rEditor.getNestedAC().getParent() == null) {
                    if (rEditor.removeNestedACMapping(this.ego, true)) {
                        unmapdone = true;
                    }
                } else {
                    if (rEditor.getNestedAC().getParent().removeNestedACMapping(this.ego, rEditor.getNestedAC())) {
                        // empty if block
                    }
                    unmapdone = true;
                    if (rEditor.removeNestedACMapping(this.ego, rEditor.getNestedAC().getParent(), rEditor.getNestedAC().getParent().getNestedACs())) {
                        unmapdone = true;
                    }
                }
            }
            if (unmapdone) {
                rule.update();
                if (rEditor.getNestedAC() != null) {
                    rEditor.updateNestedAC(rEditor.getNestedAC());
                }
                rEditor.updateGraphics();
            }
        } else {
            if (isLeftRuleObj) {
                if (!(rule instanceof EdAtomic) && (rEditor.removeNacMapping(this.ego, true) || rEditor.removePacMapping(this.ego, true) || rEditor.removeNestedACMapping(this.ego, true))) {
                    unmapdone = true;
                }
                if (rEditor.removeRuleMapping(this.ego, true)) {
                    unmapdone = true;
                }
            } else if (rEditor.getNestedAC() != null) {
                if (rEditor.getNestedAC().getParent() == null) {
                    if (rEditor.removeNestedACMapping(this.ego, true)) {
                        unmapdone = true;
                    }
                } else {
                    if (rEditor.getNestedAC().getParent().removeNestedACMapping(this.ego, rEditor.getNestedAC())) {
                        // empty if block
                    }
                    unmapdone = true;
                    if (rEditor.removeNestedACMapping(this.ego, true)) {
                        unmapdone = true;
                    }
                }
            }
            if (unmapdone) {
                if (rEditor.getNestedAC() == null) {
                    rule.update();
                    rEditor.updateGraphics();
                } else {
                    rEditor.updateNestedAC(rEditor.getNestedAC());
                    rEditor.updateGraphics();
                }
            }
        }
        if (rule.getMatch() != null && isLeftRuleObj) {
            if (rEditor.removeMatchMapping(this.ego, true)) {
                unmapdone = true;
            }
            if (wantDelete) {
                rule.getMatch().getCompletionStrategy().removeFromObjectVarMap(this.ego.getBasisObject());
            }
        }
        return unmapdone;
    }

    private boolean rightPanelUnmap(RuleEditor rEditor, EdRule rule, boolean wantDelete) {
        boolean isLeftRuleObj;
        boolean unmapdone = false;
        boolean bl = isLeftRuleObj = this.ego.getContext() == rule.getLeft();
        if (!wantDelete) {
            if (isLeftRuleObj) {
                if (!(rule instanceof EdAtomic)) {
                    if (rEditor.removeNacMapping(this.ego)) {
                        unmapdone = true;
                    }
                    if (rEditor.removePacMapping(this.ego)) {
                        unmapdone = true;
                    }
                    if (rEditor.removeNestedACMapping(this.ego)) {
                        unmapdone = true;
                    }
                }
                if (rEditor.removeRuleMapping(this.ego, true)) {
                    unmapdone = true;
                }
            } else if (this.ego.getContext() == rule.getRight() && rEditor.removeRuleMapping(this.ego, false)) {
                unmapdone = true;
            }
        }
        if (unmapdone) {
            if (rEditor.getNestedAC() == null) {
                rule.update();
            } else {
                rule.updateRule();
                rEditor.updateNestedAC(rEditor.getNestedAC());
            }
            rEditor.updateGraphics();
        }
        return unmapdone;
    }

    private boolean leftCondPanelUnmap(RuleEditor rEditor, EdRule rule) {
        boolean unmapdone = false;
        if (rEditor.removeNacMapping(this.ego, false)) {
            unmapdone = true;
        } else if (rEditor.removePacMapping(this.ego, false)) {
            unmapdone = true;
        } else if (rEditor.removeNestedACMapping(this.ego, false)) {
            unmapdone = true;
        }
        if (unmapdone) {
            if (rEditor.getNestedAC() == null) {
                rule.update();
            } else {
                rule.updateRule();
                rEditor.updateNestedAC(rEditor.getNestedAC());
            }
            rEditor.getLeftPanel().updateGraphics();
            rEditor.getLeftCondPanel().updateGraphics();
        }
        return unmapdone;
    }

    public void activateObjectNameMenuItem(boolean b) {
        if (b && this.getComponent(3) != this.miObjName) {
            this.insert(this.miObjName, 3);
        } else {
            this.remove(this.miObjName);
        }
    }

    protected void setObjectName(EdGraphObject go) {
        go.setWeakselected(true);
        this.gp.updateGraphics();
        String objname = JOptionPane.showInputDialog(this.applFrame, " Please set the object name: ", go.getBasisObject().getObjectName());
        if (objname != null) {
            go.getBasisObject().setObjectName(objname);
        }
        go.setWeakselected(false);
        this.gp.updateGraphics();
    }
}

