/*
 * Decompiled with CFR 0.152.
 */
package agg.termination;

import agg.termination.TerminationLGTSInterface;
import agg.termination.TypeLayerOfTypeGraph;
import agg.util.IntComparator;
import agg.util.OrderedSet;
import agg.util.Pair;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.RulePriority;
import agg.xt_basis.Type;
import agg.xt_basis.TypeGraph;
import agg.xt_basis.csp.Completion_InheritCSP;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TerminationLGTSTypedByTypeGraph
implements TerminationLGTSInterface {
    private GraGra grammar;
    private TypeGraph typeGraph;
    private List<Rule> listOfRules;
    private boolean layered;
    private boolean priority;
    private Vector<Rule> deletionRule;
    private Vector<Rule> nondeletionRule;
    private Vector<Rule> creationRule;
    private Hashtable<Rule, Integer> ruleLayer;
    private Hashtable<GraphObject, Integer> creationLayer;
    private Hashtable<GraphObject, Integer> deletionLayer;
    private boolean generateRuleLayer;
    private Hashtable<Rule, Integer> oldRuleLayer;
    private int maxl;
    private Hashtable<Integer, HashSet<Rule>> invertedRuleLayer;
    private OrderedSet<Integer> orderedRuleLayerSet;
    private Hashtable<Integer, HashSet<Object>> invertedTypeDeletionLayer;
    private OrderedSet<Integer> orderedTypeDeletionLayerSet;
    private Hashtable<Integer, HashSet<Object>> invertedTypeCreationLayer;
    private OrderedSet<Integer> orderedTypeCreationLayerSet;
    private Integer startLayer;
    private Integer startRuleLayer;
    private Vector<Integer> orderedRuleLayer;
    private Hashtable<Integer, Pair<Boolean, Vector<Rule>>> resultTypeDeletion;
    private Hashtable<Integer, Pair<Boolean, Vector<Rule>>> resultDeletion;
    private Hashtable<Integer, Pair<Boolean, Vector<Rule>>> resultNonDeletion;
    private Hashtable<Integer, List<String>> errorMsg;
    private Hashtable<Integer, List<String>> errorMsgDeletion1;
    private Hashtable<Integer, List<String>> errorMsgDeletion2;
    private Hashtable<Integer, List<String>> errorMsgNonDeletion;
    private Hashtable<Integer, Vector<GraphObject>> deletionType;
    private boolean needCorrection = false;
    private String errMsg;
    private boolean valid;

    public void dispose() {
        if (this.grammar != null) {
            this.unsetLayer();
        }
        this.grammar = null;
    }

    private void setKind() {
        this.priority = this.grammar.trafoByPriority();
        this.layered = this.grammar.isLayered() || !this.priority;
        this.oldRuleLayer.clear();
        this.saveRuleLayerInto(this.oldRuleLayer);
    }

    @Override
    public void setGrammar(GraGra gra) {
        if (gra == null) {
            this.unsetLayer();
            this.grammar = null;
        } else {
            this.grammar = gra;
            this.typeGraph = (TypeGraph)gra.getTypeGraph();
            this.listOfRules = this.getListOfEnabledRules();
            this.errMsg = "";
            this.valid = false;
            this.oldRuleLayer = new Hashtable();
            this.setKind();
            this.initRuleLayer(this.grammar);
            this.initCreationLayer(this.grammar);
            this.initDeletionLayer(this.grammar);
            this.initOrderedRuleLayer(this.grammar);
            this.deletionType = new Hashtable();
            this.initResults();
        }
    }

    @Override
    public void resetGrammar() {
        if (this.grammar != null) {
            this.typeGraph = (TypeGraph)this.grammar.getTypeGraph();
            this.listOfRules = this.getListOfEnabledRules();
            this.errMsg = "";
            this.valid = false;
            this.setKind();
            this.reinitRuleLayer();
            this.reinitCreationLayer();
            this.reinitDeletionLayer();
            this.reinitOrderedRuleLayer();
            this.deletionType.clear();
            this.reinitResults();
        }
    }

    @Override
    public GraGra getGrammar() {
        return this.grammar;
    }

    @Override
    public List<Rule> getListOfEnabledRules() {
        Vector<Rule> list = new Vector<Rule>();
        int i = 0;
        while (i < this.grammar.getListOfRules().size()) {
            Rule r = this.grammar.getListOfRules().get(i);
            if (r.isEnabled()) {
                list.add(r);
            }
            ++i;
        }
        return list;
    }

    @Override
    public boolean hasGrammarChanged() {
        if (this.grammar != null) {
            boolean changed = false;
            if (this.grammar.hasRuleChangedEvailability() || this.layered && this.grammar.trafoByPriority() || this.priority && this.grammar.isLayered() || this.layered && this.grammar.hasRuleChangedLayer() || this.priority && this.grammar.hasRuleChangedPriority() || this.layered && !this.grammar.isLayered()) {
                changed = true;
                this.setGrammar(this.grammar);
            }
            return changed;
        }
        return false;
    }

    @Override
    public List<Rule> getListOfRules() {
        return this.listOfRules;
    }

    @Override
    public Hashtable<Integer, HashSet<Rule>> getInvertedRuleLayer() {
        return this.invertedRuleLayer;
    }

    @Override
    public Vector<Integer> getOrderedRuleLayer() {
        return this.orderedRuleLayer;
    }

    @Override
    public Hashtable<Integer, HashSet<Object>> getInvertedTypeDeletionLayer() {
        return this.invertedTypeDeletionLayer;
    }

    @Override
    public Hashtable<Integer, HashSet<Object>> getInvertedTypeCreationLayer() {
        return this.invertedTypeCreationLayer;
    }

    @Override
    public Hashtable<Integer, Vector<Type>> getDeletionType() {
        Hashtable<Integer, Vector<Type>> delLayerType = new Hashtable<Integer, Vector<Type>>();
        Enumeration<Integer> keys = this.deletionType.keys();
        while (keys.hasMoreElements()) {
            Integer key = keys.nextElement();
            Vector<GraphObject> typeGOs = this.deletionType.get(key);
            Vector<Type> typeObjs = new Vector<Type>();
            int i = 0;
            while (i < typeGOs.size()) {
                typeObjs.add(typeGOs.get(i).getType());
                ++i;
            }
            delLayerType.put(key, typeObjs);
        }
        return delLayerType;
    }

    @Override
    public Hashtable<Integer, Vector<GraphObject>> getDeletionTypeObject() {
        return this.deletionType;
    }

    @Override
    public Hashtable<Integer, Pair<Boolean, Vector<Rule>>> getResultTypeDeletion() {
        return this.resultTypeDeletion;
    }

    @Override
    public Hashtable<Integer, Pair<Boolean, Vector<Rule>>> getResultDeletion() {
        return this.resultDeletion;
    }

    @Override
    public Hashtable<Integer, Pair<Boolean, Vector<Rule>>> getResultNondeletion() {
        return this.resultNonDeletion;
    }

    @Override
    public void resetLayer() {
        this.maxl = 0;
        this.setKind();
        this.initRuleLayer(this.oldRuleLayer);
        this.initCreationLayer(this.grammar);
        this.initDeletionLayer(this.grammar);
        this.initOrderedRuleLayer(this.grammar);
        this.deletionType = new Hashtable();
        this.initResults();
    }

    private void unsetLayer() {
        this.creationLayer.clear();
        this.deletionLayer.clear();
        this.deletionType.clear();
        this.deletionRule.clear();
        this.creationRule.clear();
        this.nondeletionRule.clear();
        this.invertedRuleLayer.clear();
        this.ruleLayer.clear();
        this.oldRuleLayer.clear();
        this.orderedRuleLayerSet.clear();
        this.resultDeletion.clear();
        this.resultDeletion.clear();
        this.resultNonDeletion.clear();
        this.clearErrors();
    }

    private void initRuleLayer(GraGra gragra) {
        this.ruleLayer = new Hashtable();
        this.deletionRule = new Vector();
        this.nondeletionRule = new Vector();
        this.creationRule = new Vector();
        for (Rule rule : this.listOfRules) {
            if (this.priority) {
                this.ruleLayer.put(rule, rule.getPriority());
            } else {
                this.ruleLayer.put(rule, rule.getLayer());
            }
            if (this.isDeleting(rule)) {
                this.deletionRule.add(rule);
                continue;
            }
            if (this.isCreating(rule)) {
                this.creationRule.add(rule);
            }
            this.nondeletionRule.add(rule);
        }
    }

    private void reinitRuleLayer() {
        this.ruleLayer.clear();
        this.deletionRule.clear();
        this.nondeletionRule.clear();
        this.creationRule.clear();
        for (Rule rule : this.listOfRules) {
            if (this.priority) {
                this.ruleLayer.put(rule, rule.getPriority());
            } else if (this.layered) {
                this.ruleLayer.put(rule, rule.getLayer());
            }
            if (this.isDeleting(rule)) {
                this.deletionRule.add(rule);
                continue;
            }
            if (this.isCreating(rule)) {
                this.creationRule.add(rule);
            }
            this.nondeletionRule.add(rule);
        }
    }

    @Override
    public void initRuleLayer(Hashtable<?, Integer> init) {
        Enumeration<?> keys = init.keys();
        while (keys.hasMoreElements()) {
            Rule rule = (Rule)keys.nextElement();
            if (!rule.isEnabled()) continue;
            Integer rl = init.get(rule);
            this.ruleLayer.put(rule, (int)rl);
        }
    }

    private void initCreationLayer(GraGra gragra) {
        this.creationLayer = new Hashtable();
        for (Node t : this.typeGraph.getNodesSet()) {
            if (this.startLayer != null) {
                this.creationLayer.put(t, (int)this.startLayer);
                continue;
            }
            this.creationLayer.put(t, 0);
        }
        for (Arc t : this.typeGraph.getArcsSet()) {
            if (this.startLayer != null) {
                this.creationLayer.put(t, (int)this.startLayer);
                continue;
            }
            this.creationLayer.put(t, 0);
        }
    }

    private void reinitCreationLayer() {
        this.creationLayer.clear();
        for (Node t : this.typeGraph.getNodesSet()) {
            this.creationLayer.put(t, 0);
        }
        for (Arc t : this.typeGraph.getArcsSet()) {
            this.creationLayer.put(t, 0);
        }
    }

    private void initCreationLayer(int init) {
        Enumeration<GraphObject> keys = this.creationLayer.keys();
        while (keys.hasMoreElements()) {
            GraphObject t = keys.nextElement();
            this.creationLayer.put(t, init);
        }
    }

    private void initDeletionLayer(GraGra gragra) {
        this.deletionLayer = new Hashtable();
        for (Node t : this.typeGraph.getNodesSet()) {
            this.deletionLayer.put(t, 0);
        }
        for (Arc t : this.typeGraph.getArcsSet()) {
            this.deletionLayer.put(t, 0);
        }
    }

    private void reinitDeletionLayer() {
        this.deletionLayer.clear();
        for (Node t : this.typeGraph.getNodesSet()) {
            this.deletionLayer.put(t, 0);
        }
        for (Arc t : this.typeGraph.getArcsSet()) {
            this.deletionLayer.put(t, 0);
        }
    }

    private void initDeletionLayer(int init) {
        Enumeration<GraphObject> keys = this.deletionLayer.keys();
        while (keys.hasMoreElements()) {
            GraphObject t = keys.nextElement();
            this.deletionLayer.put(t, init);
        }
    }

    private void initOrderedRuleLayer(GraGra gragra) {
        if (this.priority) {
            RulePriority layer = new RulePriority(this.listOfRules);
            this.invertedRuleLayer = layer.invertPriority();
            this.startRuleLayer = layer.getStartPriority();
            this.orderedRuleLayerSet = new OrderedSet(new IntComparator());
            Enumeration<Integer> en = this.invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                this.orderedRuleLayerSet.add(en.nextElement());
            }
        } else {
            RuleLayer layer = new RuleLayer(this.listOfRules);
            this.invertedRuleLayer = layer.invertLayer();
            this.startRuleLayer = layer.getStartLayer();
            this.orderedRuleLayerSet = new OrderedSet(new IntComparator());
            Enumeration<Integer> en = this.invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                this.orderedRuleLayerSet.add(en.nextElement());
            }
        }
    }

    private void reinitOrderedRuleLayer() {
        if (this.priority) {
            RulePriority layer = new RulePriority(this.listOfRules);
            this.invertedRuleLayer = layer.invertPriority();
            this.startRuleLayer = layer.getStartPriority();
            this.orderedRuleLayerSet = new OrderedSet(new IntComparator());
            Enumeration<Integer> en = this.invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                this.orderedRuleLayerSet.add(en.nextElement());
            }
        } else {
            RuleLayer layer = new RuleLayer(this.listOfRules);
            this.invertedRuleLayer = layer.invertLayer();
            this.startRuleLayer = layer.getStartLayer();
            this.orderedRuleLayerSet.clear();
            Enumeration<Integer> en = this.invertedRuleLayer.keys();
            while (en.hasMoreElements()) {
                this.orderedRuleLayerSet.add(en.nextElement());
            }
        }
    }

    private void initOrderedTypeDeletionLayer() {
        TypeLayerOfTypeGraph layer = new TypeLayerOfTypeGraph(this.deletionLayer);
        this.invertedTypeDeletionLayer = layer.invertLayer();
        this.startLayer = layer.getStartLayer();
        this.invertedTypeDeletionLayer = layer.invertLayer();
        this.orderedTypeDeletionLayerSet = new OrderedSet(new IntComparator());
        Enumeration<Integer> en = this.invertedTypeDeletionLayer.keys();
        while (en.hasMoreElements()) {
            this.orderedTypeDeletionLayerSet.add(en.nextElement());
        }
    }

    private void initOrderedTypeCreationLayer() {
        TypeLayerOfTypeGraph layer = new TypeLayerOfTypeGraph(this.creationLayer);
        this.invertedTypeCreationLayer = layer.invertLayer();
        this.startLayer = layer.getStartLayer();
        this.invertedTypeCreationLayer = layer.invertLayer();
        this.orderedTypeCreationLayerSet = new OrderedSet(new IntComparator());
        Enumeration<Integer> en = this.invertedTypeCreationLayer.keys();
        while (en.hasMoreElements()) {
            this.orderedTypeCreationLayerSet.add(en.nextElement());
        }
    }

    private void initResults() {
        this.orderedRuleLayer = new Vector();
        this.resultTypeDeletion = new Hashtable();
        this.resultDeletion = new Hashtable();
        this.resultNonDeletion = new Hashtable();
        this.errorMsg = new Hashtable();
        this.errorMsgDeletion1 = new Hashtable();
        this.errorMsgDeletion2 = new Hashtable();
        this.errorMsgNonDeletion = new Hashtable();
    }

    private void reinitResults() {
        this.orderedRuleLayer.clear();
        this.resultTypeDeletion.clear();
        this.resultDeletion.clear();
        this.resultNonDeletion.clear();
        this.clearErrors();
    }

    @Override
    public void initAll(boolean generate) {
        if (generate) {
            this.initRuleLayer(this.oldRuleLayer);
            if (this.startLayer != null) {
                this.initCreationLayer(this.startLayer);
            } else {
                this.initCreationLayer(0);
            }
            this.initDeletionLayer(0);
            this.initResults();
            this.maxl = 0;
        } else {
            this.resetLayer();
        }
    }

    private boolean isDeleting(Rule r) {
        return r.isDeleting();
    }

    private boolean isCreating(Rule r) {
        return r.isCreating();
    }

    private GraphObject getTypeGraphObject(GraphObject go) {
        GraphObject t = null;
        t = go.isNode() ? this.typeGraph.getTypeSet().getTypeGraphNode(go.getType()) : this.typeGraph.getTypeSet().getTypeGraphArc(go.getType(), ((Arc)go).getSourceType(), ((Arc)go).getTargetType());
        return t;
    }

    @Override
    public Vector<Object> getCreatedTypesOnDeletionLayer(Integer layer) {
        Vector<Object> types = new Vector<Object>();
        Enumeration<Rule> en = this.deletionRule.elements();
        while (en.hasMoreElements()) {
            Rule r = en.nextElement();
            Enumeration<GraphObject> elems = r.getRight().getElements();
            while (elems.hasMoreElements()) {
                GraphObject t;
                Integer tLayer;
                GraphObject go = elems.nextElement();
                if (r.getInverseImage(go).hasMoreElements() || (tLayer = this.creationLayer.get(t = this.getTypeGraphObject(go))).intValue() != layer.intValue() || types.contains(t)) continue;
                types.add(t);
            }
        }
        return types;
    }

    private void generateCreationLayer() {
        Enumeration<Rule> en = this.nondeletionRule.elements();
        while (en.hasMoreElements()) {
            Rule r = en.nextElement();
            Enumeration<GraphObject> types = this.creationLayer.keys();
            while (types.hasMoreElements()) {
                GraphObject t = types.nextElement();
                this.setCreationLayer(r, t);
            }
        }
    }

    private boolean ofSameNodeType(GraphObject t, GraphObject go) {
        if (go.isNode() && t.isNode()) {
            return t.getType().isParentOf(go.getType());
        }
        return false;
    }

    private boolean ofSameArcType(GraphObject t, GraphObject go) {
        if (go.isArc() && t.isArc()) {
            return t.getType().compareTo(go.getType()) && ((Arc)t).getSourceType().isRelatedTo(((Arc)go).getSourceType()) && ((Arc)t).getTargetType().isRelatedTo(((Arc)go).getTargetType());
        }
        return false;
    }

    private void setCreationLayer(Rule r, GraphObject t) {
        Integer cl;
        Integer rl;
        GraphObject go;
        Enumeration<GraphObject> en = r.getRight().getElements();
        while (en.hasMoreElements()) {
            go = en.nextElement();
            if (r.getInverseImage(go).hasMoreElements() || !this.ofSameNodeType(t, go) && !this.ofSameArcType(t, go)) continue;
            rl = this.ruleLayer.get(r);
            cl = this.creationLayer.get(t);
            if (cl > rl) continue;
            int l = rl + 1;
            this.creationLayer.put(t, l);
            if (l <= this.maxl) continue;
            this.maxl = l;
        }
        en = r.getLeft().getElements();
        while (en.hasMoreElements()) {
            go = en.nextElement();
            if (r.getImage(go) == null || !this.ofSameNodeType(t, go) && !this.ofSameArcType(t, go)) continue;
            rl = this.ruleLayer.get(r);
            cl = this.creationLayer.get(t);
            if (cl <= rl) continue;
            if (this.generateRuleLayer) {
                this.ruleLayer.put(r, (int)cl);
                rl = this.ruleLayer.get(r);
                this.needCorrection = true;
                continue;
            }
            this.creationLayer.put(t, (int)rl);
        }
    }

    private void generateDeletionLayer() {
        Rule r;
        Enumeration<Object> en;
        if (this.generateRuleLayer) {
            en = this.deletionRule.elements();
            while (en.hasMoreElements()) {
                r = en.nextElement();
                Integer rl = this.getRuleLayer().get(r);
                if (rl >= this.maxl) continue;
                this.ruleLayer.put(r, this.maxl);
            }
        }
        en = this.deletionRule.elements();
        while (en.hasMoreElements()) {
            r = en.nextElement();
            Enumeration<GraphObject> types = this.deletionLayer.keys();
            while (types.hasMoreElements()) {
                GraphObject t = types.nextElement();
                this.setDeletionLayer(r, t);
            }
        }
        en = this.getDeletionLayer().keys();
        while (en.hasMoreElements()) {
            GraphObject key = (GraphObject)en.nextElement();
            Integer dl = this.getDeletionLayer().get(key);
            Integer cl = this.creationLayer.get(key);
            if (dl >= cl) continue;
            this.deletionLayer.put(key, (int)cl);
        }
    }

    private void setDeletionLayer(Rule r, GraphObject t) {
        Integer cl;
        Integer rl;
        GraphObject go;
        Enumeration<GraphObject> en = r.getLeft().getElements();
        while (en.hasMoreElements()) {
            go = en.nextElement();
            if (r.getImage(go) != null || !this.ofSameNodeType(t, go) && !this.ofSameArcType(t, go)) continue;
            rl = this.ruleLayer.get(r);
            cl = this.creationLayer.get(t);
            Integer dl = this.deletionLayer.get(t);
            int l = cl;
            if (l > this.maxl) {
                this.maxl = l;
            }
            if (this.generateRuleLayer && rl < this.maxl) {
                this.ruleLayer.put(r, this.maxl);
                rl = this.ruleLayer.get(r);
            }
            if (dl < cl) {
                this.deletionLayer.put(t, this.maxl);
                dl = this.deletionLayer.get(t);
            }
            if (dl > rl && this.generateRuleLayer) {
                this.ruleLayer.put(r, (int)dl);
                rl = this.ruleLayer.get(r);
            }
            if (dl != 0) continue;
            this.deletionLayer.put(t, (int)rl);
            dl = this.deletionLayer.get(t);
        }
        en = r.getRight().getElements();
        while (en.hasMoreElements()) {
            go = en.nextElement();
            if (r.getInverseImage(go).hasMoreElements() || !this.ofSameNodeType(t, go) && !this.ofSameArcType(t, go)) continue;
            rl = this.ruleLayer.get(r);
            cl = this.creationLayer.get(t);
            if (cl > rl) continue;
            this.creationLayer.put(t, rl + 1);
            cl = this.creationLayer.get(t);
        }
    }

    private void clearErrors() {
        this.errorMsg.clear();
        this.errorMsgDeletion1.clear();
        this.errorMsgDeletion2.clear();
        this.errorMsgNonDeletion.clear();
    }

    @Override
    public boolean checkTermination() {
        this.clearErrors();
        if (this.generateRuleLayer) {
            this.initAll(this.generateRuleLayer);
        }
        this.generateCreationLayer();
        this.generateDeletionLayer();
        int n = this.listOfRules.size();
        while (this.needCorrection && n >= 0) {
            this.needCorrection = false;
            this.generateCreationLayer();
            this.generateDeletionLayer();
            --n;
        }
        this.valid = false;
        for (Rule r : this.listOfRules) {
            Integer rl = this.ruleLayer.get(r);
            if (rl != null) continue;
            this.errMsg = "Rule <" + r.getName() + "> " + "does not satisfy totality of rule layer function.";
            this.addErrorMessage(this.errorMsg, rl, this.errMsg);
            return false;
        }
        Enumeration<GraphObject> en = this.grammar.getTypeGraph().getElements();
        while (en.hasMoreElements()) {
            GraphObject t = (GraphObject)en.nextElement();
            Integer dl = this.deletionLayer.get(t);
            Integer cl = this.creationLayer.get(t);
            if (cl == null) {
                this.errMsg = "Type <" + t.getType().getStringRepr() + "> " + "does not satisfy totality of creation layer function.";
                this.addErrorMessage(this.errorMsg, dl, this.errMsg);
                return false;
            }
            if (dl != null) continue;
            this.errMsg = "Type <" + t.getType().getStringRepr() + "> " + "does not satisfy totality of deletion layer function.";
            this.addErrorMessage(this.errorMsg, cl, this.errMsg);
            return false;
        }
        boolean result = this.checkTerminationConditions();
        this.initOrderedTypeDeletionLayer();
        this.initOrderedTypeCreationLayer();
        this.valid = this.setValidResult();
        return result;
    }

    private void addErrorMessage(Hashtable<Integer, List<String>> msgContainer, Integer key, String msg) {
        List<String> errList = msgContainer.get(key);
        if (errList == null) {
            errList = new Vector<String>();
            msgContainer.put(key, errList);
        }
        errList.add(this.errMsg);
    }

    private boolean checkTerminationConditions() {
        Integer currentLayer = this.startRuleLayer;
        int i = 0;
        boolean nextLayerExists = true;
        while (nextLayerExists && currentLayer != null) {
            HashSet<Rule> rulesForLayer = this.invertedRuleLayer.get(currentLayer);
            if (rulesForLayer != null) {
                this.orderedRuleLayer.addElement(currentLayer);
                Vector<Rule> currentRules = new Vector<Rule>();
                for (Rule rule : rulesForLayer) {
                    if (!rule.isEnabled()) continue;
                    currentRules.addElement(rule);
                }
                boolean checkOK = this.checkTypeDeletion(currentLayer, currentRules);
                Pair<Boolean, Vector<Rule>> value1 = new Pair<Boolean, Vector<Rule>>(checkOK, currentRules);
                this.resultTypeDeletion.put(currentLayer, value1);
                checkOK = this.checkNonDeletionLayer(currentRules);
                Pair<Boolean, Vector<Rule>> value2 = new Pair<Boolean, Vector<Rule>>(checkOK, currentRules);
                this.resultNonDeletion.put(currentLayer, value2);
                checkOK = this.checkDeletionLayer(currentRules);
                Pair<Boolean, Vector<Rule>> value3 = new Pair<Boolean, Vector<Rule>>(checkOK, currentRules);
                this.resultDeletion.put(currentLayer, value3);
            }
            if (++i < this.orderedRuleLayerSet.size()) {
                currentLayer = (Integer)this.orderedRuleLayerSet.get(i);
                continue;
            }
            nextLayerExists = false;
        }
        return true;
    }

    private boolean checkTypeDeletion(Integer layer, Vector<Rule> rules) {
        boolean checkOK = true;
        int j = 0;
        while (j < rules.size()) {
            Rule r = rules.elementAt(j);
            if (this.deletionRule.contains(r)) {
                if (r.getLeft().getSize() < r.getRight().getSize()) {
                    checkOK = false;
                    String test = "Rule <" + r.getName() + "> does not decrease";
                    if (this.errMsg.indexOf(test) >= 0) break;
                    this.errMsg = "Rule <" + r.getName() + "> does not decrease the number of graph items of one special type.";
                    this.addErrorMessage(this.errorMsgDeletion1, layer, this.errMsg);
                    break;
                }
            } else if (!r.isTriggerOfLayer()) {
                this.errMsg = "Rule <" + r.getName() + "> does not decrease the number of graph items.";
                this.addErrorMessage(this.errorMsgDeletion1, layer, this.errMsg);
                return false;
            }
            ++j;
        }
        if (checkOK) {
            return true;
        }
        Hashtable deletedType = new Hashtable();
        int j2 = 0;
        while (j2 < rules.size()) {
            Rule r = rules.elementAt(j2);
            Enumeration<GraphObject> en = r.getLeft().getElements();
            while (en.hasMoreElements()) {
                GraphObject o = en.nextElement();
                if (r.getImage(o) != null) continue;
                boolean containsKey = false;
                GraphObject t = null;
                t = o.isNode() ? r.getTypeSet().getTypeGraphNode(o.getType()) : r.getTypeSet().getTypeGraphArc(o.getType(), ((Arc)o).getSourceType(), ((Arc)o).getTargetType());
                Pair<Node, Object> delt = new Pair<Node, Object>((Node)t, null);
                if (o.isArc()) {
                    delt.second = new Pair<Node, Node>(r.getTypeSet().getTypeGraphNode(((Arc)o).getSource().getType()), r.getTypeSet().getTypeGraphNode(((Arc)o).getTarget().getType()));
                }
                Pair t1 = null;
                Enumeration e = deletedType.keys();
                while (e.hasMoreElements()) {
                    t1 = (Pair)e.nextElement();
                    if (!t.getType().isRelatedTo(((GraphObject)t1.first).getType())) continue;
                    if (t1.second == null && delt.second == null) {
                        containsKey = true;
                        break;
                    }
                    if (t1.second == null || delt.second == null) continue;
                    Pair t1sec = (Pair)t1.second;
                    Pair deltsec = (Pair)delt.second;
                    if (!((GraphObject)deltsec.first).getType().isRelatedTo(((GraphObject)t1sec.first).getType()) || !((GraphObject)deltsec.second).getType().isRelatedTo(((GraphObject)t1sec.second).getType())) continue;
                    containsKey = true;
                    break;
                }
                if (containsKey) {
                    if (((Vector)deletedType.get(t1)).contains(r)) continue;
                    ((Vector)deletedType.get(t1)).add(r);
                    continue;
                }
                Vector<Rule> v = new Vector<Rule>(rules.size());
                v.add(r);
                deletedType.put(delt, v);
            }
            ++j2;
        }
        Vector<GraphObject> ltypes = new Vector<GraphObject>();
        Enumeration en = deletedType.keys();
        while (en.hasMoreElements()) {
            Pair key = (Pair)en.nextElement();
            GraphObject t = (GraphObject)key.first;
            Vector v = (Vector)deletedType.get(key);
            if (v.size() != rules.size()) continue;
            int j3 = 0;
            while (j3 < rules.size()) {
                String test;
                Rule r = rules.elementAt(j3);
                if (key.second == null) {
                    if (r.getLeft().getElementsOfTypeAsVector(t.getType()).size() <= r.getRight().getElementsOfTypeAsVector(t.getType()).size()) {
                        test = "Rule <" + r.getName() + "> does not decrease";
                        if (this.errMsg.indexOf(test) < 0) {
                            this.errMsg = "Rule <" + r.getName() + "> does not decrease the number of graph items of one special node type <" + t.getType().getName() + ">";
                            this.addErrorMessage(this.errorMsgDeletion1, layer, this.errMsg);
                        }
                        return false;
                    }
                } else if (r.getLeft().getElementsOfTypeAsVector(t.getType(), ((GraphObject)((Pair)key.second).first).getType(), ((GraphObject)((Pair)key.second).second).getType()).size() <= r.getRight().getElementsOfTypeAsVector(t.getType(), ((GraphObject)((Pair)key.second).first).getType(), ((GraphObject)((Pair)key.second).second).getType()).size()) {
                    test = "Rule <" + r.getName() + "> does not decrease";
                    if (this.errMsg.indexOf(test) < 0) {
                        this.errMsg = "Rule <" + r.getName() + "> does not decrease the number of graph items of one special edge type <" + t.getType().getName() + ">";
                        this.addErrorMessage(this.errorMsgDeletion1, layer, this.errMsg);
                    }
                    return false;
                }
                ++j3;
            }
            ltypes.add(t);
        }
        if (ltypes.size() != 0) {
            this.deletionType.put(layer, ltypes);
            return true;
        }
        this.errMsg = "Rules do not decrease the number of graph items.";
        this.addErrorMessage(this.errorMsgDeletion1, layer, this.errMsg);
        return false;
    }

    private boolean checkDeletionLayer(Vector<Rule> rules) {
        boolean result = true;
        HashSet<GraphObject> deletionSet = new HashSet<GraphObject>();
        HashSet<GraphObject> creationSet = new HashSet<GraphObject>();
        int j = 0;
        while (j < rules.size()) {
            deletionSet.clear();
            creationSet.clear();
            Rule rule = rules.elementAt(j);
            if (this.deletionRule.contains(rule)) {
                GraphObject t;
                Integer cl;
                GraphObject go;
                Integer rl = this.ruleLayer.get(rule);
                Graph leftGraph = rule.getLeft();
                Graph rightGraph = rule.getRight();
                Object en = leftGraph.getElements();
                while (en.hasMoreElements()) {
                    go = en.nextElement();
                    if (rule.getImage(go) != null) continue;
                    deletionSet.add(go);
                }
                if (deletionSet.isEmpty()) {
                    result = false;
                    this.errMsg = "Rule <" + rule.getName() + ">" + "  does not delete at least one graph item.";
                    this.addErrorMessage(this.errorMsgDeletion2, rl, this.errMsg);
                    break;
                }
                en = this.getDeletionLayer().keys();
                while (en.hasMoreElements() && result) {
                    GraphObject key = (GraphObject)en.nextElement();
                    Integer dl = this.getDeletionLayer().get(key);
                    cl = this.getCreationLayer().get(key);
                    if (cl >= 0 && cl <= dl) continue;
                    result = false;
                    this.errMsg = "Type  <" + key.getType().getStringRepr() + ">" + ", rl = " + rl + ", cl = " + cl + ", dl = " + dl + "  do not satisfy condition:" + " 0 <= cl <= dl <= rl";
                    this.addErrorMessage(this.errorMsgDeletion2, dl, this.errMsg);
                    break;
                }
                en = deletionSet.iterator();
                while (en.hasNext() && result) {
                    go = (GraphObject)en.next();
                    t = this.getTypeGraphObject(go);
                    Integer dl = this.getDeletionLayer().get(t);
                    if (dl <= rl) continue;
                    result = false;
                    this.errMsg = "Rule <" + rule.getName() + ">, " + "Type <" + t.getType().getStringRepr() + ">" + ", dl = " + dl + ", rl = " + rl + " do not satisfy condition" + " dl <= rl.";
                    this.addErrorMessage(this.errorMsgDeletion2, rl, this.errMsg);
                    break;
                }
                if (!result) break;
                en = rightGraph.getElements();
                while (en.hasMoreElements()) {
                    go = en.nextElement();
                    if (rule.getInverseImage(go).hasMoreElements()) continue;
                    creationSet.add(go);
                }
                en = creationSet.iterator();
                while (en.hasNext() && result) {
                    go = (GraphObject)en.next();
                    t = this.getTypeGraphObject(go);
                    cl = this.getCreationLayer().get(t);
                    if (cl > rl) continue;
                    result = false;
                    this.errMsg = "Rule <" + rule.getName() + ">, " + "Type <" + t.getType().getStringRepr() + ">" + ", cl = " + cl + ", rl = " + rl + " do not satisfy condition" + " cl > rl.";
                    this.addErrorMessage(this.errorMsgDeletion2, rl, this.errMsg);
                    break;
                }
            } else {
                result = false;
                break;
            }
            ++j;
        }
        return result;
    }

    private boolean checkNonDeletionLayer(Vector<Rule> rules) {
        boolean result = true;
        HashSet<GraphObject> preservedSet = new HashSet<GraphObject>();
        HashSet<GraphObject> creationSet = new HashSet<GraphObject>();
        int j = 0;
        while (j < rules.size()) {
            Integer cl;
            GraphObject t;
            GraphObject grob;
            Rule rule = rules.elementAt(j);
            int errKey = rule.getLayer();
            if (this.priority) {
                errKey = rule.getPriority();
            }
            if (!this.nondeletionRule.contains(rule)) {
                result = false;
                break;
            }
            if (!rule.isTotal()) {
                this.errMsg = "Rule <" + rule.getName() + "> is not total.";
                this.addErrorMessage(this.errorMsgNonDeletion, new Integer(errKey), this.errMsg);
                return false;
            }
            if (!rule.isInjective()) {
                this.errMsg = "Rule <" + rule.getName() + "> is not injective.";
                this.addErrorMessage(this.errorMsgNonDeletion, new Integer(errKey), this.errMsg);
                return false;
            }
            if (rule.isCreating() && rule.getNACsList().isEmpty()) {
                this.errMsg = "Rule <" + rule.getName() + "> does not have any NAC.";
                this.addErrorMessage(this.errorMsgNonDeletion, new Integer(errKey), this.errMsg);
                return false;
            }
            if (!this.ruleWithRightInjNAC(errKey, rule)) {
                return false;
            }
            Integer rl = this.ruleLayer.get(rule);
            creationSet.clear();
            preservedSet.clear();
            Graph leftGraph = rule.getLeft();
            Graph rightGraph = rule.getRight();
            Iterator en = leftGraph.getElements();
            while (en.hasMoreElements()) {
                grob = en.nextElement();
                if (rule.getImage(grob) == null) continue;
                preservedSet.add(grob);
            }
            en = rightGraph.getElements();
            while (en.hasMoreElements()) {
                grob = en.nextElement();
                if (rule.getInverseImage(grob).hasMoreElements()) continue;
                creationSet.add(grob);
            }
            en = preservedSet.iterator();
            while (en.hasNext() && result) {
                grob = (GraphObject)en.next();
                t = this.getTypeGraphObject(grob);
                cl = this.getCreationLayer().get(t);
                if (cl <= rl) continue;
                result = false;
                this.errMsg = "Rule <" + rule.getName() + ">, " + "Type <" + t.getType().getStringRepr() + ">, " + " rl = " + rl + ", cl = " + cl + " does not preserve graph items " + " such that cl <= rl.";
                this.addErrorMessage(this.errorMsgNonDeletion, rl, this.errMsg);
                break;
            }
            en = creationSet.iterator();
            while (en.hasNext() && result) {
                grob = (GraphObject)en.next();
                t = this.getTypeGraphObject(grob);
                cl = this.getCreationLayer().get(t);
                if (cl > rl) continue;
                result = false;
                this.errMsg = "Rule <" + rule.getName() + ">, " + "Type <" + t.getType().getStringRepr() + ">, " + "rl = " + rl + ", cl = " + cl + " does not create graph items" + " such that cl > rl.";
                this.addErrorMessage(this.errorMsgNonDeletion, rl, this.errMsg);
                break;
            }
            ++j;
        }
        return result;
    }

    private boolean ruleWithRightInjNAC(int errKey, Rule rule) {
        List<OrdinaryMorphism> nacs = rule.getNACsList();
        if (nacs.isEmpty()) {
            return false;
        }
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> childNacs = null;
        boolean result = false;
        int l = 0;
        while (l < nacs.size() && !result) {
            OrdinaryMorphism nac = nacs.get(l);
            if (nac.isEnabled()) {
                boolean isChildNac = false;
                boolean failed = false;
                OrdinaryMorphism nprime = BaseFactory.theFactory().createMorphism(nac.getTarget(), rule.getRight());
                nprime.setCompletionStrategy(new Completion_InjCSP());
                Enumeration<GraphObject> dom = rule.getDomain();
                while (dom.hasMoreElements()) {
                    GraphObject grob = dom.nextElement();
                    GraphObject nacob = nac.getImage(grob);
                    if (nacob == null) continue;
                    try {
                        if (nacob.getType().isChildOf(rule.getImage(grob).getType())) {
                            isChildNac = true;
                            if (childNacs == null) {
                                childNacs = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>(1);
                            }
                            childNacs.add(new Pair<OrdinaryMorphism, OrdinaryMorphism>(nac, nprime));
                            break;
                        }
                        nprime.addMapping(nacob, rule.getImage(grob));
                    }
                    catch (BadMappingException ex) {
                        failed = true;
                        break;
                    }
                }
                if (isChildNac) {
                    result = false;
                } else if (!failed) {
                    result = nprime.nextCompletionWithConstantsChecking();
                }
            }
            ++l;
        }
        if (!result && childNacs != null && !childNacs.isEmpty()) {
            int i = 0;
            while (i < childNacs.size() && !result) {
                result = this.ruleWithRightInjChildNAC(rule, (Pair)childNacs.get(i));
                ++i;
            }
        }
        if (!result) {
            this.errMsg = "Rule <" + rule.getName() + "> " + "does not have any right injective NACs.";
            this.addErrorMessage(this.errorMsgNonDeletion, new Integer(errKey), this.errMsg);
        }
        return result;
    }

    private boolean ruleWithRightInjChildNAC(Rule rule, Pair<OrdinaryMorphism, OrdinaryMorphism> p) {
        boolean result = false;
        boolean oneChildOnly = false;
        boolean failed = false;
        OrdinaryMorphism nac = (OrdinaryMorphism)p.first;
        OrdinaryMorphism nprime = (OrdinaryMorphism)p.second;
        nprime.setCompletionStrategy(new Completion_InheritCSP());
        Enumeration<GraphObject> dom = rule.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject grob = dom.nextElement();
            GraphObject nacob = nac.getImage(grob);
            if (nacob == null) continue;
            try {
                if (nacob.getType().isChildOf(rule.getImage(grob).getType())) {
                    nprime.addChild2ParentMapping(nacob, rule.getImage(grob));
                    if (grob.getType().getChildren().size() != 1) continue;
                    oneChildOnly = true;
                    continue;
                }
                nprime.addMapping(nacob, rule.getImage(grob));
            }
            catch (BadMappingException ex) {
                failed = true;
                break;
            }
        }
        if (!failed && oneChildOnly) {
            result = nprime.nextCompletionWithConstantsChecking();
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private boolean setValidResult() {
        boolean result = true;
        int i = 0;
        while (i < this.orderedRuleLayer.size()) {
            Integer currentLayer = this.orderedRuleLayer.elementAt(i);
            boolean localresult = true;
            Pair<Boolean, Vector<Rule>> p = this.resultTypeDeletion.get(currentLayer);
            if (p != null && !((Vector)p.second).isEmpty()) {
                localresult = (Boolean)p.first;
            }
            if (!localresult) {
                p = this.resultNonDeletion.get(currentLayer);
                localresult = (Boolean)p.first;
                if (!localresult) {
                    p = this.resultDeletion.get(currentLayer);
                    localresult = (Boolean)p.first;
                    if (localresult) {
                        this.errorMsgDeletion1.remove(currentLayer);
                        this.errorMsgDeletion2.remove(currentLayer);
                        this.errorMsgNonDeletion.remove(currentLayer);
                    }
                } else {
                    this.errorMsgDeletion1.remove(currentLayer);
                    this.errorMsgDeletion2.remove(currentLayer);
                    this.errorMsgNonDeletion.remove(currentLayer);
                }
            } else {
                this.errorMsgDeletion1.remove(currentLayer);
                this.errorMsgDeletion2.remove(currentLayer);
                this.errorMsgNonDeletion.remove(currentLayer);
            }
            result = result && localresult;
            ++i;
        }
        return result;
    }

    @Override
    public String getErrorMessage() {
        String str = this.getErrorOfTypeDeletion(10);
        String str1 = this.getErrorOfDeletion(10);
        String str2 = this.getErrorOfNonDeletion(10);
        if (!str1.equals("")) {
            str = str.concat("\n\n");
            str = str.concat(str1);
        }
        if (!str2.equals("")) {
            str = str.concat("\n\n");
            str = str.concat(str2);
        }
        return str;
    }

    private String getErrorOfTypeDeletion(int maxErrors) {
        int n = 0;
        String str0 = "*** (Type) Deletion Layer Condition ( Deletion_1 ) ***";
        String str = "";
        Enumeration<Integer> keys = this.errorMsgDeletion1.keys();
        block0: while (keys.hasMoreElements() && n <= maxErrors) {
            List<String> list = this.errorMsgDeletion1.get(keys.nextElement());
            int i = 0;
            while (i < list.size()) {
                str = str.concat("\n");
                str = str.concat(list.get(i));
                if (++n > maxErrors) {
                    str = str.concat("\n ... ");
                    continue block0;
                }
                ++i;
            }
        }
        if (!str.equals("")) {
            str = str0.concat(str);
        }
        return str;
    }

    private String getErrorOfDeletion(int maxErrors) {
        int n = 0;
        String str0 = "*** Deletion Layer Condition ( Deletion_2 ) ***";
        String str = "";
        Enumeration<Integer> keys = this.errorMsgDeletion2.keys();
        block0: while (keys.hasMoreElements() && n <= maxErrors) {
            List<String> list = this.errorMsgDeletion2.get(keys.nextElement());
            int i = 0;
            while (i < list.size()) {
                str = str.concat("\n");
                str = str.concat(list.get(i));
                if (++n > maxErrors) {
                    str = str.concat("\n ... ");
                    continue block0;
                }
                ++i;
            }
        }
        if (!str.equals("")) {
            str = str0.concat(str);
        }
        return str;
    }

    private String getErrorOfNonDeletion(int maxErrors) {
        int n = 0;
        String str0 = "*** Nondeletion Layer Condition ( Nondeletion ) ***";
        String str = "";
        Enumeration<Integer> keys = this.errorMsgNonDeletion.keys();
        block0: while (keys.hasMoreElements() && n <= maxErrors) {
            List<String> list = this.errorMsgNonDeletion.get(keys.nextElement());
            int i = 0;
            while (i < list.size()) {
                str = str.concat("\n");
                str = str.concat(list.get(i));
                if (n > maxErrors) {
                    str = str.concat("\n ... ");
                    continue block0;
                }
                ++i;
            }
        }
        if (!str.equals("")) {
            str = str0.concat(str);
        }
        return str;
    }

    @Override
    public Hashtable<Rule, Integer> getRuleLayer() {
        int size = this.listOfRules.size();
        if (size != this.ruleLayer.size()) {
            this.initRuleLayer(this.grammar);
            return this.ruleLayer;
        }
        for (Rule key : this.listOfRules) {
            if (this.ruleLayer.containsKey(key)) continue;
            this.initRuleLayer(this.grammar);
            return this.ruleLayer;
        }
        return this.ruleLayer;
    }

    @Override
    public int getRuleLayer(Rule r) {
        if (this.ruleLayer.containsKey(r)) {
            return this.ruleLayer.get(r);
        }
        return 0;
    }

    @Override
    public Hashtable<Object, Integer> getCreationLayer() {
        int size = this.typeGraph.getSize();
        if (size != this.creationLayer.size()) {
            this.initCreationLayer(this.grammar);
            return new Hashtable<Object, Integer>(this.creationLayer);
        }
        Enumeration<GraphObject> en = this.typeGraph.getElements();
        while (en.hasMoreElements()) {
            GraphObject key = en.nextElement();
            if (this.creationLayer.containsKey(key)) continue;
            this.initCreationLayer(this.grammar);
            return new Hashtable<Object, Integer>(this.creationLayer);
        }
        return new Hashtable<Object, Integer>(this.creationLayer);
    }

    @Override
    public int getCreationLayer(GraphObject t) {
        if (this.creationLayer.containsKey(t)) {
            return this.creationLayer.get(t);
        }
        return 0;
    }

    @Override
    public Hashtable<Object, Integer> getDeletionLayer() {
        int size = this.typeGraph.getSize();
        if (size != this.deletionLayer.size()) {
            this.initDeletionLayer(this.grammar);
            return new Hashtable<Object, Integer>(this.deletionLayer);
        }
        Enumeration<GraphObject> en = this.typeGraph.getElements();
        while (en.hasMoreElements()) {
            GraphObject key = en.nextElement();
            if (this.deletionLayer.containsKey(key)) continue;
            this.initDeletionLayer(this.grammar);
            return new Hashtable<Object, Integer>(this.deletionLayer);
        }
        return new Hashtable<Object, Integer>(this.deletionLayer);
    }

    @Override
    public int getDeletionLayer(GraphObject t) {
        if (this.deletionLayer.containsKey(t)) {
            return this.deletionLayer.get(t);
        }
        return 0;
    }

    @Override
    public Integer getStartLayer() {
        int startL = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration<Rule> keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            Integer layer = this.ruleLayer.get(key);
            if (layer >= startL) continue;
            startL = layer;
            result = layer;
        }
        return result;
    }

    @Override
    public Hashtable<Integer, HashSet<Rule>> invertLayer(Hashtable<Rule, Integer> layer) {
        Hashtable<Integer, HashSet<Rule>> inverted = new Hashtable<Integer, HashSet<Rule>>();
        Enumeration<Rule> keys = layer.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            Integer value = layer.get(key);
            HashSet<Rule> invertedValue = inverted.get(value);
            if (invertedValue == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(value, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    @Override
    public void saveRuleLayer() {
        Enumeration<Rule> keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Rule r = keys.nextElement();
            Integer layer = this.ruleLayer.get(r);
            if (this.layered) {
                r.setLayer(layer);
                continue;
            }
            if (this.priority) {
                r.setPriority(layer);
                continue;
            }
            r.setLayer(layer);
        }
        this.saveRuleLayerInto(this.oldRuleLayer);
    }

    private void saveRuleLayerInto(Hashtable<Rule, Integer> table) {
        for (Rule r : this.listOfRules) {
            if (this.layered) {
                table.put(r, r.getLayer());
                continue;
            }
            if (this.priority) {
                table.put(r, r.getPriority());
                continue;
            }
            table.put(r, r.getLayer());
        }
    }

    @Override
    public void setGenerateRuleLayer(boolean b) {
        this.generateRuleLayer = b;
    }

    @Override
    public void showLayer() {
        GraphObject t;
        Integer layer;
        System.out.println(" RULE LAYER");
        Enumeration<XMLObject> keys = this.ruleLayer.keys();
        while (keys.hasMoreElements()) {
            Rule r = keys.nextElement();
            layer = this.ruleLayer.get(r);
            System.out.println(String.valueOf(layer) + " " + r.getName());
        }
        System.out.println(" CREATION LAYER");
        keys = this.creationLayer.keys();
        while (keys.hasMoreElements()) {
            t = (GraphObject)keys.nextElement();
            layer = this.creationLayer.get(t);
            System.out.println(String.valueOf(layer) + " " + t.getType().getStringRepr());
        }
        System.out.println(" DELETION LAYER");
        keys = this.deletionLayer.keys();
        while (keys.hasMoreElements()) {
            t = (GraphObject)keys.nextElement();
            layer = this.deletionLayer.get(t);
            System.out.println(String.valueOf(layer) + " " + t.getType().getStringRepr());
        }
    }

    @Override
    public String toString() {
        String resultString = String.valueOf(super.toString()) + " LayerFunction:\n";
        resultString = String.valueOf(resultString) + "\tRuleLayer:\n";
        resultString = String.valueOf(resultString) + this.getRuleLayer().toString() + "\n";
        resultString = String.valueOf(resultString) + "\tCreationLayer:\n";
        resultString = String.valueOf(resultString) + this.getCreationLayer().toString() + "\n";
        resultString = String.valueOf(resultString) + "\tDeletionLayer:\n";
        resultString = String.valueOf(resultString) + this.getDeletionLayer().toString() + "\n";
        return resultString;
    }

    @Override
    public int getCreationLayer(Type t) {
        return 0;
    }

    @Override
    public int getDeletionLayer(Type t) {
        return 0;
    }
}

