/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.colim;

import agg.xt_basis.colim.COLIM_DEFS;
import agg.xt_basis.colim.COLIM_GRAPH;
import agg.xt_basis.colim.COLIM_VECTOR;
import agg.xt_basis.colim.INT_VECTOR;
import agg.xt_basis.colim.SET_DIAGRAM;

public class GRAPH_DIAGRAM
implements COLIM_DEFS {
    private SET_DIAGRAM f_node_diagram = new SET_DIAGRAM();
    private SET_DIAGRAM f_edge_diagram = new SET_DIAGRAM();
    private INT_VECTOR f_coprod_source = new INT_VECTOR();
    private INT_VECTOR f_coprod_target = new INT_VECTOR();
    private COLIM_GRAPH f_colim_graph;
    private boolean f_colimit_valid;

    public GRAPH_DIAGRAM() {
        this.f_coprod_source.push_back(0);
        this.f_coprod_target.push_back(0);
        this.f_colimit_valid = false;
    }

    public int insert_object(COLIM_GRAPH graph, String name) {
        int lower = this.f_node_diagram.coproduct_size();
        int nodes = this.f_node_diagram.insert_object(graph.f_node, name);
        int edges = this.f_edge_diagram.insert_object(graph.f_edge, name);
        int edge = 0;
        while (edge < graph.f_edge.size()) {
            this.f_coprod_source.push_back(graph.f_source.item(edge) + lower);
            this.f_coprod_target.push_back(graph.f_target.item(edge) + lower);
            ++edge;
        }
        this.f_colimit_valid = false;
        return nodes;
    }

    public int insert_morphism(INT_VECTOR node_morphism, INT_VECTOR edge_morphism, int v, int w) {
        int nodes = this.f_node_diagram.insert_morphism(node_morphism, v, w);
        int edges = this.f_edge_diagram.insert_morphism(edge_morphism, v, w);
        this.f_colimit_valid = false;
        return nodes;
    }

    public COLIM_GRAPH get_colimit_graph() {
        if (!this.f_colimit_valid) {
            this.compute_colimit();
        }
        return this.f_colim_graph;
    }

    public COLIM_VECTOR get_colimit_nodes() {
        return this.f_node_diagram.get_colimit_set();
    }

    public COLIM_VECTOR get_colimit_edges() {
        return this.f_edge_diagram.get_colimit_set();
    }

    public Object get_source(int edge) {
        return this.f_node_diagram.get_element(this.f_coprod_source.item(edge));
    }

    public Object get_target(int edge) {
        return this.f_node_diagram.get_element(this.f_coprod_target.item(edge));
    }

    public SET_DIAGRAM get_node_diagram() {
        return this.f_node_diagram;
    }

    public SET_DIAGRAM get_edge_diagram() {
        return this.f_edge_diagram;
    }

    public String toString() {
        StringBuffer Result2 = new StringBuffer("\nsort diagram:\n");
        Result2.append(this.f_node_diagram.toString());
        Result2.append("\nedge_diagram:\n");
        Result2.append(this.f_edge_diagram.toString());
        COLIM_GRAPH coprod = new COLIM_GRAPH(this.f_node_diagram.get_coproduct_set(), this.f_edge_diagram.get_coproduct_set(), this.f_coprod_source, this.f_coprod_target);
        Result2.append("\ncoproduct:\n");
        Result2.append(coprod.toString());
        Result2.append("\n");
        return new String(Result2);
    }

    private void compute_colimit() {
        int f;
        this.f_colim_graph = new COLIM_GRAPH();
        INT_VECTOR colimit_nodes = this.f_node_diagram.get_colimit_indices();
        int node = 0;
        while (node < colimit_nodes.size()) {
            COLIM_VECTOR node_attrs = new COLIM_VECTOR();
            int n = this.f_colim_graph.insert_node(node_attrs);
            ++node;
        }
        INT_VECTOR colimit_edges = this.f_edge_diagram.get_colimit_indices();
        int edge = 0;
        while (edge < colimit_edges.size()) {
            COLIM_VECTOR edge_attrs = new COLIM_VECTOR();
            int s = this.f_node_diagram.get_colimit_pos(this.f_coprod_source.item(colimit_edges.item(edge)));
            int t = this.f_node_diagram.get_colimit_pos(this.f_coprod_target.item(colimit_edges.item(edge)));
            if (s != -1 && t != -1) {
                f = this.f_colim_graph.insert_edge(edge_attrs, s, t);
            } else {
                this.f_edge_diagram.delete_element(colimit_edges.item(edge));
            }
            ++edge;
        }
        int node2 = 1;
        while (node2 < this.f_node_diagram.coproduct_size()) {
            int m = this.f_node_diagram.get_colimit_pos(node2);
            if (m != -1) {
                COLIM_VECTOR node_attrs = (COLIM_VECTOR)this.f_colim_graph.node_attr(m);
                node_attrs.push_back(this.f_node_diagram.get_element(node2));
            }
            ++node2;
        }
        edge = 1;
        while (edge < this.f_edge_diagram.coproduct_size()) {
            f = this.f_edge_diagram.get_colimit_pos(edge);
            if (f != -1) {
                COLIM_VECTOR edge_attrs = (COLIM_VECTOR)this.f_colim_graph.edge_attr(f);
                edge_attrs.push_back(this.f_edge_diagram.get_element(edge));
            }
            ++edge;
        }
        this.f_colimit_valid = true;
    }
}

