/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.sierpinski;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.PartitionedEGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class SierpinskiBenchmark {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/sierpinski";

    public static void run(String path, int iterations) {
        int threads = Math.max(Runtime.getRuntime().availableProcessors() / 2, 1);
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("sierpinski.henshin", false);
        Rule rule = (Rule)module.getUnit("AddTriangle");
        Resource resource = resourceSet.getResource("sierpinski-start.xmi");
        PartitionedEGraphImpl graph = new PartitionedEGraphImpl(resource, threads);
        EObject container = (EObject)resource.getContents().get(0);
        graph.remove((Object)container);
        EngineImpl engine = new EngineImpl(new String[0]);
        engine.getOptions().put("WORKER_THREADS", threads);
        engine.getOptions().put("DESTROY_MATCHES", true);
        try {
            RuleApplicationImpl application = new RuleApplicationImpl((Engine)engine);
            application.setRule(rule);
            application.setEGraph((EGraph)graph);
            System.out.println("Starting Sierpinski benchmark...");
            System.out.println(String.valueOf(Runtime.getRuntime().maxMemory() / 0x100000L) + "MB available memory");
            System.out.println("Using " + threads + " worker threads\n");
            System.out.println("Level\tMatches\tNodes\tMatTime\tAppTime\tTotTime");
            int expectedNodes = 3;
            int expectedMatches = 1;
            int i = 0;
            while (i < iterations) {
                System.gc();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                long startTime = System.currentTimeMillis();
                Match match = (Match)engine.findMatches(rule, (EGraph)graph, null).iterator().next();
                long matchingTime = System.currentTimeMillis() - startTime;
                int matchCount = match.getMultiMatches((Rule)rule.getMultiRules().get(0)).size();
                startTime = System.currentTimeMillis();
                application.setCompleteMatch(match);
                if (!application.execute(null)) {
                    throw new RuntimeException("Error transforming Sierpinski model");
                }
                long runtime = System.currentTimeMillis() - startTime;
                System.out.println(String.valueOf(i + 1) + "\t" + matchCount + "\t" + graph.size() + "\t" + matchingTime + "\t" + runtime + "\t" + (matchingTime + runtime));
                if (matchCount != expectedMatches) {
                    throw new RuntimeException("Expected " + expectedMatches + " matches instead of " + matchCount);
                }
                if (graph.size() != (expectedNodes += (expectedMatches *= 3))) {
                    throw new RuntimeException("Expected " + expectedNodes + " nodes instead of " + graph.size());
                }
                ++i;
            }
        }
        finally {
            engine.shutdown();
        }
    }

    public static void main(String[] args) {
        int iterations = args.length > 0 ? Integer.parseInt(args[0]) : 12;
        SierpinskiBenchmark.run(PATH, iterations);
    }
}

