/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.interpreter.ui.debug.LaunchRuleControl;
import org.eclipse.emf.henshin.interpreter.ui.debug.ParamUtil;
import org.eclipse.emf.henshin.interpreter.ui.util.ParameterConfig;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RuleLaunchTab
extends AbstractLaunchConfigurationTab {
    LaunchRuleControl ruleControl;

    public void createControl(Composite parent) {
        this.ruleControl = new LaunchRuleControl();
        this.setControl((Control)this.ruleControl.createControl(parent, this));
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String modulePath = configuration.getAttribute("MODULE_PATH", "");
            String inputUri = configuration.getAttribute("INPUT_URI", "");
            String outputUri = configuration.getAttribute("OUTPUT_URI", "");
            String unitName = configuration.getAttribute("UNIT_NAME", "");
            int unitIndex = configuration.getAttribute("UNIT_INDEX", -1);
            boolean openCompare = configuration.getAttribute("OPEN_COMPARE", true);
            Map paramTypes = configuration.getAttribute("PARAMETER_TYPES", new HashMap());
            Map paramValues = configuration.getAttribute("PARAMETER_VALUES", new HashMap());
            List unsetParams = configuration.getAttribute("UNSET_PARAMETERS", new ArrayList());
            this.ruleControl.moduleSelector.setModelURI(modulePath);
            this.ruleControl.inputSelector.setModelURI(inputUri);
            this.ruleControl.outputSelector.setModelURI(outputUri);
            this.ruleControl.unitSelector.setSelection(unitIndex);
            this.ruleControl.openCompare.setSelection(openCompare);
            if (!(modulePath.isEmpty() || unitName.isEmpty() || paramTypes.isEmpty() || paramValues.isEmpty())) {
                HenshinResourceSet resourceSet = new HenshinResourceSet();
                URI uri = URI.createURI((String)modulePath);
                Module module = resourceSet.getModule(uri, false);
                Unit unit = module.getUnit(unitName);
                List<ParameterConfig> paramConfigs = ParamUtil.getParameterPreferences(unit);
                this.ruleControl.transformOperation.setUnit(unit, paramConfigs);
                ParamUtil.fillParamConfigs(this.ruleControl.transformOperation.getParameterConfigurations(), paramTypes, paramValues, unsetParams);
                this.ruleControl.parameterEditor.setParameters(this.ruleControl.transformOperation.getParameterConfigurations());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("MODULE_PATH", this.ruleControl.moduleSelector.getModelURI());
        configuration.setAttribute("INPUT_URI", this.ruleControl.inputSelector.getModelURI());
        configuration.setAttribute("OUTPUT_URI", this.ruleControl.outputSelector.getModelURI());
        if (this.ruleControl.transformOperation.getUnit() != null) {
            configuration.setAttribute("UNIT_NAME", this.ruleControl.transformOperation.getUnit().getName());
            configuration.setAttribute("UNIT_INDEX", this.ruleControl.unitSelector.getUnitSelector().getSelectionIndex());
        }
        configuration.setAttribute("OPEN_COMPARE", this.ruleControl.openCompare.getSelection());
        if (this.ruleControl.transformOperation.getParameterConfigurations() == null) {
            return;
        }
        HashMap<String, String> paramTypes = new HashMap<String, String>();
        HashMap<String, String> paramValues = new HashMap<String, String>();
        ArrayList<String> unsetParams = new ArrayList<String>();
        for (ParameterConfig paramCfg : this.ruleControl.transformOperation.getParameterConfigurations()) {
            paramTypes.put(paramCfg.getName(), String.valueOf(paramCfg.getType()));
            paramValues.put(paramCfg.getName(), String.valueOf(paramCfg.getValue()));
            if (!paramCfg.isUnset()) continue;
            unsetParams.add(paramCfg.getName());
        }
        configuration.setAttribute("PARAMETER_TYPES", paramTypes);
        configuration.setAttribute("PARAMETER_VALUES", paramValues);
        configuration.setAttribute("UNSET_PARAMETERS", unsetParams);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        String modulePath = this.ruleControl.moduleSelector.getModelURI();
        if (modulePath.isEmpty()) {
            this.setErrorMessage("You must choose a module");
            return false;
        }
        if (this.ruleControl.unitSelector.getUnitSelector().getSelectionIndex() == -1 || this.ruleControl.transformOperation.getUnit() == null) {
            this.setErrorMessage("You must choose a unit");
            return false;
        }
        if (!(this.ruleControl.transformOperation.getUnit() instanceof Rule)) {
            this.setErrorMessage("Selected unit must be a rule");
        }
        if (this.ruleControl.inputSelector.getModelURI().isEmpty()) {
            this.setErrorMessage("You must choose an input URI");
            return false;
        }
        if (this.ruleControl.outputSelector.getModelURI().isEmpty()) {
            this.setErrorMessage("You must choose an output URI");
            return false;
        }
        return true;
    }

    public String getName() {
        return "Henshin rule launch tab";
    }
}

