/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.concurrent.ThreadFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.PartitionedEGraph;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.UnaryConstraint;

public class TypeConstraint
implements UnaryConstraint {
    public static final int NO_PARTITION = -1;
    public final EClass type;
    public final boolean strictTyping;

    public TypeConstraint(EClass type, boolean strictTyping) {
        this.type = type;
        this.strictTyping = strictTyping;
    }

    @Override
    public boolean check(DomainSlot slot) {
        return !slot.locked || this.isValid(slot.value);
    }

    protected boolean isValid(EObject object) {
        return this.strictTyping ? this.type == object.eClass() : this.type.isSuperTypeOf(object.eClass());
    }

    public boolean initDomain(DomainSlot slot, EGraph graph) {
        if (slot.domain == null) {
            int partition = this.getPartition(slot);
            slot.domain = partition != -1 ? ((PartitionedEGraph)graph).getDomain(this.type, this.strictTyping, partition) : graph.getDomain(this.type, this.strictTyping);
            return !slot.domain.isEmpty();
        }
        if (slot.domain.isEmpty()) {
            return false;
        }
        int size = slot.domain.size();
        int i = size - 1;
        while (i >= 0) {
            EObject object = slot.domain.get(i);
            if (object == null || !this.isValid(object)) {
                slot.domain.remove(i);
            }
            --i;
        }
        return !slot.domain.isEmpty();
    }

    public boolean instantiationPossible(DomainSlot slot, EGraph graph) {
        if (slot.locked) {
            return this.isValid(slot.value);
        }
        int partition = this.getPartition(slot);
        if (partition != -1) {
            return ((PartitionedEGraph)graph).getDomainSize(this.type, this.strictTyping, partition) > 0;
        }
        return graph.getDomainSize(this.type, this.strictTyping) > 0;
    }

    private int getPartition(DomainSlot slot) {
        if (Thread.currentThread() instanceof PartitionThread) {
            PartitionThread thread = (PartitionThread)Thread.currentThread();
            if (thread.firstDomainSlot == null) {
                throw new NullPointerException();
            }
            if (thread.firstDomainSlot == slot) {
                return thread.partition;
            }
        }
        return -1;
    }

    public static class PartitionThread
    extends Thread {
        public int partition = -1;
        public DomainSlot firstDomainSlot = null;

        public PartitionThread(Runnable runnable) {
            super(runnable);
        }

        public static class Factory
        implements ThreadFactory {
            public static final Factory INSTANCE = new Factory();

            @Override
            public Thread newThread(Runnable runnable) {
                return new PartitionThread(runnable);
            }
        }
    }
}

