/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class MapOfLSetEnumerator {
    public static <K, V> void combinations(Map<K, Set<V>> map, List<Map<K, V>> list) {
        MapOfLSetEnumerator.recurse(map, new LinkedList<K>(map.keySet()).listIterator(), new HashMap(), list);
    }

    private static <K, V> void recurse(Map<K, Set<V>> map, ListIterator<K> iter, Map<K, V> cur, List<Map<K, V>> list) {
        if (!iter.hasNext()) {
            HashMap<K, V> entry = new HashMap<K, V>();
            for (K key : cur.keySet()) {
                entry.put(key, cur.get(key));
            }
            list.add(entry);
        } else {
            K key = iter.next();
            Set<V> set = map.get(key);
            for (V value : set) {
                cur.put(key, value);
                MapOfLSetEnumerator.recurse(map, iter, cur, list);
                cur.remove(key);
            }
            iter.previous();
        }
    }

    public static void main(String[] args) {
        HashMap<Integer, Set<Integer>> map = new HashMap<Integer, Set<Integer>>(){
            {
                this.put(1, new HashSet<Integer>(){
                    {
                        this.add(11);
                        this.add(12);
                    }
                });
                this.put(2, new HashSet<Integer>(){
                    {
                        this.add(21);
                        this.add(22);
                        this.add(23);
                    }
                });
                this.put(3, new HashSet<Integer>(){
                    {
                        this.add(31);
                    }
                });
            }
        };
        LinkedList list = new LinkedList();
        MapOfLSetEnumerator.combinations(map, list);
        for (Map map2 : list) {
            System.out.println(map2);
        }
    }
}

