/*
 * Decompiled with CFR 0.152.
 */
package configuration.impl;

import configuration.Configuration;
import configuration.ConfigurationFactory;
import configuration.ConfigurationPackage;
import configuration.Favorite;
import configuration.Feature;
import configuration.FeatureBinding;
import configuration.impl.ConfigurationImpl;
import configuration.impl.FavoriteImpl;
import configuration.impl.FeatureImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.henshin.model.Rule;

public class ConfigurationFactoryImpl
extends EFactoryImpl
implements ConfigurationFactory {
    public static ConfigurationFactory init() {
        try {
            ConfigurationFactory theConfigurationFactory = (ConfigurationFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/2011/Henshin/configuration");
            if (theConfigurationFactory != null) {
                return theConfigurationFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ConfigurationFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createFeature();
            }
            case 1: {
                return this.createConfiguration();
            }
            case 2: {
                return this.createFavorite();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.createFeatureBindingFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.convertFeatureBindingToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Feature createFeature() {
        FeatureImpl feature = new FeatureImpl();
        return feature;
    }

    @Override
    public Configuration createConfiguration() {
        ConfigurationImpl configuration = new ConfigurationImpl();
        return configuration;
    }

    @Override
    public Configuration createConfiguration(Configuration configuration) {
        ConfigurationImpl result = new ConfigurationImpl();
        result.setRule((Rule)configuration.getRule());
        EList<Feature> features = result.getFeatures();
        for (Feature vp : configuration.getFeatures()) {
            Feature feature = this.createFeature();
            feature.setName(new String(vp.getName()));
            feature.setBinding(vp.getBinding());
            features.add((Object)feature);
        }
        return result;
    }

    @Override
    public Favorite createFavorite() {
        FavoriteImpl favorite = new FavoriteImpl();
        return favorite;
    }

    public FeatureBinding createFeatureBindingFromString(EDataType eDataType, String initialValue) {
        FeatureBinding result = FeatureBinding.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFeatureBindingToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public Favorite createFavorite(Configuration configuration) {
        FavoriteImpl result = new FavoriteImpl();
        result.setRule((Rule)configuration.getRule());
        EList<Feature> features = result.getFeatures();
        for (Feature vp : configuration.getFeatures()) {
            Feature feature = this.createFeature();
            feature.setName(new String(vp.getName()));
            feature.setBinding(vp.getBinding());
            features.add((Object)feature);
        }
        return result;
    }

    @Override
    public ConfigurationPackage getConfigurationPackage() {
        return (ConfigurationPackage)this.getEPackage();
    }

    @Deprecated
    public static ConfigurationPackage getPackage() {
        return ConfigurationPackage.eINSTANCE;
    }
}

