/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.refactoring.logic;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import mergeSuggestion.MergeRule;
import mergeSuggestion.MergeRuleElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.refactoring.logic.MergeInException;
import org.eclipse.emf.henshin.variability.mergein.refactoring.logic.MergeRuleElementRulesMapping;
import org.eclipse.emf.henshin.variability.mergein.refactoring.logic.NewMerger;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityFactory;

public abstract class NewMergerTester {
    private static final String TEST = "-test";
    private static final String TESTCOMPLETE = "-testcomplete";
    private static final String HENSHIN = ".henshin";

    public static void testSortMergeRuleElements(NewMerger merger) {
        System.out.println("===");
        MergeRule mr = merger.getMergeRule();
        for (MergeRuleElement mre : mr.getElements()) {
            String str = String.valueOf(mre.getName()) + ":";
            for (GraphElement elem : mre.getReferenceElements()) {
                str = String.valueOf(str) + " " + elem;
            }
            System.out.println(str);
        }
        System.out.println("===");
    }

    public static void testSetPresenceConditions(NewMerger merger) {
        System.out.println("===");
        MergeRule mr = merger.getMergeRule();
        for (MergeRuleElement mre : mr.getElements()) {
            String str = String.valueOf(mre.getName()) + ":";
            for (GraphElement elem : mre.getReferenceElements()) {
                str = String.valueOf(str) + " " + elem + "(" + VariabilityFactory.createVariabilityGraphElement((GraphElement)elem).getPresenceCondition() + ")";
            }
            System.out.println(str);
        }
        System.out.println("===");
    }

    public static void testFillNodesMap(NewMerger merger) {
        System.out.println("===");
        HashMap<Node, Node> map = merger.getNodesMap();
        for (GraphElement graphElement : map.keySet()) {
            System.out.println("Key: " + graphElement + "; Value: " + map.get(graphElement));
        }
        System.out.println("=> Number of pairs: " + map.size());
        System.out.println("===");
    }

    public static void testPartitionMergeRuleElements(NewMerger merger) {
        String str;
        System.out.println("=== LSH elements");
        for (MergeRuleElement mre : merger.getElementsLhs()) {
            str = String.valueOf(mre.getName()) + ":";
            for (GraphElement elem : mre.getReferenceElements()) {
                str = String.valueOf(str) + " " + elem;
            }
            System.out.println(str);
        }
        System.out.println("=== RSH elements");
        for (MergeRuleElement mre : merger.getElementsRhs()) {
            str = String.valueOf(mre.getName()) + ":";
            for (GraphElement elem : mre.getReferenceElements()) {
                str = String.valueOf(str) + " " + elem;
            }
            System.out.println(str);
        }
        System.out.println("=== Conditions elements");
        for (MergeRuleElement mre : merger.getElementsConditions()) {
            str = String.valueOf(mre.getName()) + ":";
            for (GraphElement elem : mre.getReferenceElements()) {
                str = String.valueOf(str) + " " + elem;
            }
            System.out.println(str);
        }
        System.out.println("=== Nested rules elements");
        for (MergeRuleElement mre : merger.getElementsNestedRules()) {
            str = String.valueOf(mre.getName()) + ":";
            for (GraphElement elem : mre.getReferenceElements()) {
                str = String.valueOf(str) + " " + elem;
            }
            System.out.println(str);
        }
        System.out.println("===");
    }

    public static void testUnifyParameterNames(NewMerger merger) {
        System.out.println("===");
        Rule masterRule = merger.getMasterRule();
        String str = String.valueOf(masterRule.getName()) + ":";
        for (Parameter param : masterRule.getParameters()) {
            str = String.valueOf(str) + " " + param.getName();
        }
        System.out.println(str);
        for (Rule rule : merger.getFurtherRules()) {
            str = String.valueOf(rule.getName()) + ":";
            for (Parameter param : rule.getParameters()) {
                str = String.valueOf(str) + " " + param.getName();
            }
            System.out.println(str);
        }
        System.out.println("===");
        NewMergerTester.testSortMergeRuleElements(merger);
    }

    public static void testMergeParametersIntoMasterRule(NewMerger merger) {
        System.out.println("===");
        Rule masterRule = merger.getMasterRule();
        String str = String.valueOf(masterRule.getName()) + ":";
        for (Parameter param : masterRule.getParameters()) {
            str = String.valueOf(str) + " " + param.getName();
        }
        System.out.println(str);
        for (Rule rule : merger.getFurtherRules()) {
            str = String.valueOf(rule.getName()) + ":";
            for (Parameter param : rule.getParameters()) {
                str = String.valueOf(str) + " " + param.getName();
            }
            System.out.println(str);
        }
        System.out.println("===");
    }

    public static void testMergeLhsGraph(NewMerger merger) {
        System.out.println("===");
        Rule masterRule = merger.getMasterRule();
        System.out.println(String.valueOf(masterRule.getName()) + ":");
        NewMergerTester.printGraph(masterRule.getLhs());
        for (Rule rule : merger.getFurtherRules()) {
            System.out.println("---");
            System.out.println(String.valueOf(rule.getName()) + ":");
            NewMergerTester.printGraph(rule.getLhs());
        }
        System.out.println("===");
    }

    private static void printGraph(Graph graph) {
        for (Node node : graph.getNodes()) {
            System.out.println(node);
            for (Attribute attr : node.getAttributes()) {
                System.out.println(attr);
            }
        }
        for (Edge edge : graph.getEdges()) {
            System.out.println(edge);
        }
    }

    public static void testMergeRhsGraph(NewMerger merger) {
        System.out.println("===");
        Rule masterRule = merger.getMasterRule();
        System.out.println(String.valueOf(masterRule.getName()) + ":");
        NewMergerTester.printGraph(masterRule.getRhs());
        for (Rule rule : merger.getFurtherRules()) {
            System.out.println("---");
            System.out.println(String.valueOf(rule.getName()) + ":");
            NewMergerTester.printGraph(rule.getRhs());
        }
        System.out.println("===");
    }

    public static void testAddLhsRhsMapping(NewMerger merger) {
        System.out.println("===");
        Rule masterRule = merger.getMasterRule();
        System.out.println(String.valueOf(masterRule.getName()) + ":");
        NewMergerTester.printGraph(masterRule.getLhs());
        System.out.println("---");
        NewMergerTester.printGraph(masterRule.getRhs());
        System.out.println("---");
        NewMergerTester.printMapping(masterRule.getMappings());
        System.out.println("===");
    }

    private static void printMapping(MappingList mappings) {
        Iterator iter = mappings.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    public static void testPrepareRuleSets(NewMerger merger) {
        System.out.println("===");
        EList<MergeRuleElementRulesMapping> mappings = merger.getMergeRuleElementRulesMappings();
        for (MergeRuleElementRulesMapping mapping : mappings) {
            String str = String.valueOf(mapping.getMergeRuleElement().getName()) + ":";
            for (Rule rule : mapping.getRules()) {
                str = String.valueOf(str) + " " + rule.getName();
            }
            System.out.println(str);
        }
        System.out.println("===");
    }

    public static void testMergeConditionsIntoMasterRule(NewMerger merger) {
        System.out.println("===");
        try {
            String fileName = NewMergerTester.getHenshinFile(merger.getModule()).getName();
            int index = fileName.lastIndexOf(HENSHIN);
            String rawFileName = fileName.substring(0, index);
            fileName = String.valueOf(rawFileName) + TEST + HENSHIN;
            String filePath = NewMergerTester.getHenshinFile(merger.getModule()).getParent();
            fileName = String.valueOf(filePath) + "\\" + fileName;
            merger.saveModule(fileName);
            System.out.println("saved to " + fileName);
        }
        catch (MergeInException e) {
            e.printStackTrace();
        }
        System.out.println("===");
    }

    public static void testCompleteMerging(NewMerger merger) {
        System.out.println("===");
        try {
            String fileName = NewMergerTester.getHenshinFile(merger.getModule()).getName();
            int index = fileName.lastIndexOf(HENSHIN);
            String rawFileName = fileName.substring(0, index);
            fileName = String.valueOf(rawFileName) + TESTCOMPLETE + HENSHIN;
            String filePath = NewMergerTester.getHenshinFile(merger.getModule()).getParent();
            fileName = String.valueOf(filePath) + "\\" + fileName;
            merger.saveModule(fileName);
            System.out.println("saved to " + fileName);
        }
        catch (MergeInException e) {
            e.printStackTrace();
        }
        System.out.println("===");
    }

    private static File getHenshinFile(Module module) throws MergeInException {
        Path path;
        URI uri = module.eResource().getURI();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile((IPath)(path = new Path(uri.toPlatformString(true))));
        if (file != null && file.getLocation() != null) {
            File f = file.getLocation().toFile();
            return f;
        }
        throw new MergeInException("Can not locate Henshin file.");
    }
}

