/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser.javaExpr;

import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.parser.javaExpr.ASTExpression;
import agg.attribute.parser.javaExpr.ASTIdNotDeclaredException;
import agg.attribute.parser.javaExpr.ASTMissingValueException;
import agg.attribute.parser.javaExpr.Node;
import agg.attribute.parser.javaExpr.ObjectConstNode;
import agg.attribute.parser.javaExpr.SimpleNode;
import java.util.Vector;

public class ASTId
extends SimpleNode {
    static final long serialVersionUID = 1L;
    String name;
    boolean isClass = false;

    ASTId(String id) {
        super(id);
    }

    public static Node jjtCreate(String id) {
        return new ASTId(id);
    }

    @Override
    protected boolean isConstantExpr() {
        return false;
    }

    @Override
    public String toString() {
        Class<?> clazz = this.getNodeClass();
        String cname = "";
        if (this.isClass) {
            cname = String.valueOf(cname) + "(Class name) ";
        }
        cname = String.valueOf(cname) + "\"" + this.name + "\"";
        if (clazz != null) {
            cname = String.valueOf(cname) + " [" + clazz.toString() + "]";
        }
        return String.valueOf(this.identifier) + " " + cname;
    }

    @Override
    public void checkContext() {
        Class<?> clazz = null;
        HandlerType tabEntry = null;
        if (classResolver != null) {
            clazz = classResolver.forName(this.name);
        } else {
            try {
                clazz = Class.forName(this.name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            this.isClass = false;
            if (symtab == null) {
                throw new ASTIdNotDeclaredException(this.name);
            }
            tabEntry = symtab.getType(this.name);
            if (tabEntry == null) {
                throw new ASTIdNotDeclaredException(this.name);
            }
            clazz = tabEntry.getClazz();
            if (clazz == null) {
                throw new ASTIdNotDeclaredException(this.name);
            }
        } else {
            this.isClass = true;
        }
        this.setNodeClass(clazz);
    }

    @Override
    public void interpret() {
        Object value = null;
        HandlerExpr tabEntry = null;
        this.checkContext();
        if (this.isClass) {
            value = this.getNodeClass();
        } else if (symtab == null || (tabEntry = symtab.getExpr(this.name)) == null || (value = tabEntry.getValue()) == null) {
            throw new ASTMissingValueException("Missing value exception for: " + this.name);
        }
        ++top;
        Node obj = ObjectConstNode.jjtCreate(String.valueOf(this.identifier) + " to ObjectConstNode");
        ((ObjectConstNode)obj).obj = value;
        obj.jjtSetParent(this.jjtGetParent());
        ((ObjectConstNode)obj).setNodeClass(this.getNodeClass());
        this.jjtGetParent().replaceChild(this, obj);
        this.jjtSetParent(null);
        if (value != null) {
            obj.interpret();
        }
    }

    @Override
    public void rewrite() {
        this.checkContext();
        HandlerExpr newExpr = symtab.getExpr(this.name);
        if (newExpr == null) {
            throw new ASTMissingValueException("Missing value exception for: " + this.name);
        }
        Node newTree = newExpr.getAST();
        if (newTree instanceof ASTExpression && this.jjtGetParent() instanceof ASTExpression) {
            Node tmp = newTree.jjtGetChild(0);
            ((ASTExpression)newTree).children.removeElement(tmp);
            tmp.jjtSetParent(null);
            newTree = tmp;
        }
        newTree.jjtSetParent(this.jjtGetParent());
        this.jjtGetParent().replaceChild(this, newTree);
        this.jjtSetParent(null);
    }

    @Override
    public String getString() {
        return this.name;
    }

    @Override
    public void getAllVariablesinExpression(Vector<String> v) {
        v.addElement(this.name);
    }

    @Override
    public Node copy() {
        Node copy = super.copy();
        ((ASTId)copy).name = new String(this.name);
        ((ASTId)copy).isClass = this.isClass;
        return copy;
    }
}

