/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.AGGAppl;
import agg.gui.AGGConstraints;
import agg.gui.cpa.CriticalPairAnalysis;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.ruleappl.ApplicabilityRuleSequence;
import agg.gui.termination.TerminationAnalysis;
import agg.gui.treeview.GraGraTreeView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class AGGAnalyzer
implements EditEventListener {
    private CriticalPairAnalysis criticalPairAnalysis;
    private ApplicabilityRuleSequence applRuleSequence;
    private AGGConstraints aggConstraints;
    private TerminationAnalysis termination;
    private final JMenu menu;
    private JMenuItem cpaOoptions;
    private final Vector<JMenu> menus;
    private final AGGAppl parent;

    public AGGAnalyzer(AGGAppl appl, GraGraTreeView tree) {
        this.parent = appl;
        this.menus = new Vector(1);
        this.menu = new JMenu("Analyzer", true);
        this.menu.setMnemonic('A');
        this.menus.addElement(this.menu);
    }

    public void addCriticalPairAnalysis(CriticalPairAnalysis cpa) {
        this.criticalPairAnalysis = cpa;
        Enumeration<JMenu> e = cpa.getMenus();
        while (e.hasMoreElements()) {
            this.menu.add(e.nextElement());
        }
        this.menu.addSeparator();
    }

    public void addApplicabilityRuleSequence(ApplicabilityRuleSequence applRuleSeq) {
        this.applRuleSequence = applRuleSeq;
        Enumeration<JMenu> e = this.applRuleSequence.getMenus();
        while (e.hasMoreElements()) {
            this.menu.add(e.nextElement());
        }
        this.menu.addSeparator();
    }

    public void addConstraints(AGGConstraints constraints) {
        this.aggConstraints = constraints;
        Enumeration<JMenu> e = constraints.getMenus();
        while (e.hasMoreElements()) {
            this.menu.add(e.nextElement());
        }
        this.menu.addSeparator();
    }

    public void addTerminationAnalysis(TerminationAnalysis term) {
        this.termination = term;
        this.menu.add(term.getMenuItem());
        this.menu.addSeparator();
    }

    public void addCPAOptions() {
        this.cpaOoptions = new JMenuItem("CPA Options...");
        this.cpaOoptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AGGAnalyzer.this.parent != null) {
                    AGGAnalyzer.this.parent.getPreferences().showOptionGUI(3);
                }
            }
        });
        this.menu.add(this.cpaOoptions);
    }

    public Enumeration<JMenu> getMenus() {
        return this.menus.elements();
    }

    public CriticalPairAnalysis getCriticalPairAnalysis() {
        return this.criticalPairAnalysis;
    }

    public AGGConstraints getConstraints() {
        return this.aggConstraints;
    }

    public TerminationAnalysis getTerminationAnalysis() {
        return this.termination;
    }

    @Override
    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -10 && e.getMessage().equals("Analyzer")) {
            this.menu.doClick();
        }
    }
}

