/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.cpa;

import agg.editor.impl.EdGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VariableEqualityDialog
extends JDialog {
    protected final EdGraph graph;

    public VariableEqualityDialog(EdGraph graph, Point location) {
        super(new JFrame(), "Variable Equalities", false);
        this.graph = graph;
        String text = graph.getBasisGraph().getHelpInfoAboutVariableEquality();
        text = text.substring(1, text.length() - 1).replaceAll(" ", "");
        String[] array = text.split(",");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                VariableEqualityDialog.this.setVisible(false);
            }
        });
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)new JLabel("                    "), "North");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("  " + graph.getName() + "  "), "North");
        JPanel p = new JPanel(new GridLayout(array.length + 3, 1));
        p.add(new JLabel("        "));
        int i = 0;
        while (i < array.length) {
            String s = array[i];
            JLabel l = new JLabel("    " + s + "    ");
            l.setForeground(Color.RED);
            p.add(l);
            ++i;
        }
        p.add(new JLabel("        "));
        panel.add((Component)p, "Center");
        JButton close = new JButton("OK");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariableEqualityDialog.this.setVisible(false);
            }
        });
        JPanel pb = new JPanel();
        pb.add(new JLabel("  "));
        pb.add(close);
        pb.add(new JLabel("  "));
        panel.add((Component)pb, "South");
        content.add((Component)panel, "Center");
        content.add((Component)new JLabel("                    "), "South");
        this.setContentPane(content);
        this.setLocation(location.x, location.y);
        this.pack();
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    public EdGraph getGraph() {
        return this.graph;
    }

    public static Hashtable<String, String> getVarNameEquality(String varsEquality) {
        String[] array = varsEquality.split(",");
        Hashtable<String, String> map = new Hashtable<String, String>(array.length);
        int i = 0;
        while (i < array.length) {
            String s = array[i];
            String[] vars = s.split("=");
            if (vars.length == 2) {
                map.put(vars[0], vars[1]);
            }
            ++i;
        }
        return map;
    }
}

