/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class RulePriority {
    private Hashtable<Rule, Integer> rulePriority;
    private Vector<Rule> rulesVec;

    public RulePriority(Enumeration<Rule> rules) {
        this.rulesVec = new Vector(0);
        while (rules.hasMoreElements()) {
            this.rulesVec.addElement(rules.nextElement());
        }
        this.initRulePriority();
    }

    public RulePriority(List<Rule> rules) {
        this.rulesVec = new Vector(0);
        int i = 0;
        while (i < rules.size()) {
            this.rulesVec.add(rules.get(i));
            ++i;
        }
        this.initRulePriority();
    }

    public RulePriority(Vector<Rule> rules) {
        this.rulesVec = rules;
        this.initRulePriority();
    }

    public void setPriority(Rule rule, int p) {
        rule.setPriority(p);
        this.rulePriority.put(rule, p);
    }

    private void initRulePriority() {
        this.rulePriority = new Hashtable();
        int i = 0;
        while (i < this.rulesVec.size()) {
            Rule rule = this.rulesVec.elementAt(i);
            this.rulePriority.put(rule, rule.getPriority());
            ++i;
        }
    }

    public Hashtable<Rule, Integer> getRulePriority() {
        return this.rulePriority;
    }

    public Integer getStartPriority() {
        int startPriority = Integer.MAX_VALUE;
        Integer result = null;
        Enumeration<Rule> keys = this.rulePriority.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            Integer p = this.rulePriority.get(key);
            if (p >= startPriority) continue;
            startPriority = p;
            result = p;
        }
        return result;
    }

    public Hashtable<Integer, HashSet<Rule>> invertPriority() {
        Hashtable<Integer, HashSet<Rule>> inverted = new Hashtable<Integer, HashSet<Rule>>();
        Enumeration<Rule> keys = this.rulePriority.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            Integer value = this.rulePriority.get(key);
            HashSet<Rule> invertedValue = inverted.get(value);
            if (invertedValue == null) {
                invertedValue = new HashSet();
                invertedValue.add(key);
                inverted.put(value, invertedValue);
                continue;
            }
            invertedValue.add(key);
        }
        return inverted;
    }

    public String toString() {
        String resultString = "Rule:\t\tPriority:\n";
        Enumeration<Rule> keys = this.rulePriority.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            Integer value = this.rulePriority.get(key);
            resultString = String.valueOf(resultString) + key.getName() + "\t\t" + value.toString() + "    " + key.getPriority() + "\n";
        }
        return resultString;
    }
}

